/*
 * Decompiled with CFR 0.152.
 */
package me.lightspeed7.mongofs.util;

import java.util.Date;

public final class TimeMachine {
    private long milliseconds;
    private long number;

    public static TimeMachine now() {
        return new TimeMachine(new Date().getTime());
    }

    public static TimeMachine from(long start) {
        return new TimeMachine(start);
    }

    private TimeMachine(long milliseconds) {
        this.milliseconds = milliseconds;
    }

    public TimeMachine forward(int number) {
        this.number = number;
        return this;
    }

    public TimeMachine backward(int number) {
        this.number = 0 - number;
        return this;
    }

    public Date toDate() {
        return this.inTime();
    }

    public Date inTime() {
        return new Date(this.milliseconds);
    }

    public TimeMachine seconds() {
        this.milliseconds += this.number * 1000L;
        this.number = 0L;
        return this;
    }

    public TimeMachine minutes() {
        this.milliseconds += this.number * 60L * 1000L;
        this.number = 0L;
        return this;
    }

    public TimeMachine hours() {
        this.milliseconds += this.number * 60L * 60L * 1000L;
        this.number = 0L;
        return this;
    }

    public TimeMachine days() {
        this.milliseconds += this.number * 24L * 60L * 60L * 1000L;
        this.number = 0L;
        return this;
    }

    public TimeMachine years() {
        this.milliseconds += this.number * 365L * 24L * 60L * 60L * 1000L;
        this.number = 0L;
        return this;
    }
}

