/*
 * Decompiled with CFR 0.152.
 */
package me.lightspeed7.mongofs.util;

import java.io.File;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class FileUtil {
    private FileUtil() {
    }

    public static String getExtension(File f) {
        return FileUtil.getExtension(f.getName());
    }

    public static String getExtension(String f) {
        return f.substring(f.lastIndexOf(46) + 1);
    }

    public static String toHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            String s = Integer.toHexString(0xFF & b);
            if (s.length() < 2) {
                sb.append("0");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String hexMD5(byte[] data) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.reset();
            md5.update(data);
            byte[] digest = md5.digest();
            return FileUtil.toHex(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error - this implementation of Java doesn't support MD5.");
        }
    }

    public static String getContentType(String filename) {
        FileNameMap mapNew = URLConnection.getFileNameMap();
        String temp = mapNew.getContentTypeFor("." + FileUtil.getExtension(filename));
        return temp == null ? "application/octet-stream" : temp;
    }
}

