/*
 * Decompiled with CFR 0.152.
 */
package me.lightspeed7.mongofs.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BytesCopier {
    private final InputStream in;
    private final OutputStream out;
    private final int blocksize;
    private boolean closeStreamOnPersist;

    public BytesCopier(InputStream in, OutputStream out) {
        this(8192, in, out, false);
    }

    public BytesCopier(InputStream in, OutputStream out, boolean closeStreamOnPersist) {
        this(8192, in, out, closeStreamOnPersist);
    }

    public BytesCopier(int blocksize, InputStream in, OutputStream out) {
        this(blocksize, in, out, false);
    }

    public BytesCopier(int blocksize, InputStream in, OutputStream out, boolean closeStreamOnPersist) {
        this.closeStreamOnPersist = closeStreamOnPersist;
        this.blocksize = blocksize;
        this.in = in;
        this.out = out;
    }

    public BytesCopier closeOutput() {
        this.closeStreamOnPersist = true;
        return this;
    }

    public void transfer(boolean flush) throws IOException {
        int nread;
        byte[] buf = new byte[this.blocksize];
        while ((nread = this.in.read(buf)) != -1) {
            this.out.write(buf, 0, nread);
        }
        if (flush) {
            this.out.flush();
        }
        if (this.closeStreamOnPersist) {
            this.in.close();
        }
    }

    public void transfer(long bytesToRead, boolean flush) throws IOException {
        long bytesLeft = bytesToRead;
        while (bytesLeft > 0L) {
            long buffSize = bytesToRead < (long)this.blocksize ? bytesToRead : (long)this.blocksize;
            bytesLeft -= (long)this.blocksize;
            byte[] buf = new byte[(int)buffSize];
            int nread = this.in.read(buf);
            if (nread != -1) {
                this.out.write(buf, 0, nread);
            }
            if ((long)nread == buffSize) continue;
            if (flush) {
                this.out.flush();
            }
            if (this.closeStreamOnPersist) {
                this.in.close();
            }
            bytesLeft = 0L;
        }
        if (flush) {
            this.out.flush();
        }
    }
}

