/*
 * Decompiled with CFR 0.152.
 */
package me.lightspeed7.mongofs.url;

public enum StorageFormat {
    GRIDFS(null, false, false),
    GZIPPED("gz", true, false),
    ENCRYPTED("enc", false, true),
    ENCRYPTED_GZIP("encgz", true, true);

    private final String code;
    private final boolean compressed;
    private final boolean encrypted;

    private StorageFormat(String code, boolean compressed, boolean encrypted) {
        this.code = code;
        this.compressed = compressed;
        this.encrypted = encrypted;
    }

    public String getCode() {
        return this.code;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public static final StorageFormat find(String str) {
        if (str == null) {
            return GRIDFS;
        }
        for (StorageFormat fmt : StorageFormat.values()) {
            if (fmt.name().equals(str)) {
                return fmt;
            }
            if (fmt.getCode() == null || !fmt.getCode().equals(str)) continue;
            return fmt;
        }
        return null;
    }

    public static final StorageFormat detect(boolean compress, boolean encrypt) {
        for (StorageFormat fmt : StorageFormat.values()) {
            if (fmt.isCompressed() != compress || fmt.isEncrypted() != encrypt) continue;
            return fmt;
        }
        return GRIDFS;
    }
}

