/*
 * Decompiled with CFR 0.152.
 */
package me.lightspeed7.mongofs.url;

import java.net.MalformedURLException;
import java.net.URL;
import me.lightspeed7.mongofs.url.Handler;
import me.lightspeed7.mongofs.url.StorageFormat;
import me.lightspeed7.mongofs.util.CompressionMediaTypes;
import org.bson.types.ObjectId;

public final class Parser {
    private Parser() {
    }

    public static URL construct(ObjectId id, String fileName, String mediaType, StorageFormat format) throws MalformedURLException {
        boolean compressed;
        String protocol = "mongofile";
        boolean bl = compressed = format.isCompressed() && CompressionMediaTypes.isCompressable(mediaType);
        if (compressed && format.isEncrypted()) {
            protocol = protocol + ":" + StorageFormat.ENCRYPTED_GZIP.getCode();
        } else if (compressed) {
            protocol = protocol + ":" + StorageFormat.GZIPPED.getCode();
        } else if (format.isEncrypted()) {
            protocol = protocol + ":" + StorageFormat.ENCRYPTED.getCode();
        }
        return Parser.construct(String.format("%s:%s?%s#%s", protocol, fileName, id.toString(), mediaType == null ? "" : mediaType.toString()));
    }

    public static URL construct(String spec) throws MalformedURLException {
        return new URL(null, spec, new Handler());
    }
}

