/*
 * Decompiled with CFR 0.152.
 */
package me.lightspeed7.mongofs.url;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import me.lightspeed7.mongofs.url.Parser;
import me.lightspeed7.mongofs.url.StorageFormat;
import me.lightspeed7.mongofs.util.CompressionMediaTypes;
import me.lightspeed7.mongofs.util.FileUtil;
import org.bson.types.ObjectId;

public class MongoFileUrl {
    public static final String PROTOCOL = "mongofile";
    private URL url;

    public static final MongoFileUrl construct(ObjectId id, String fileName, String mediaType, StorageFormat format) throws MalformedURLException {
        return MongoFileUrl.construct(Parser.construct(id, fileName, mediaType, format));
    }

    public static final MongoFileUrl construct(String spec) throws MalformedURLException {
        return MongoFileUrl.construct(Parser.construct(spec));
    }

    public static final MongoFileUrl construct(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (!url.getProtocol().equals(PROTOCOL)) {
            throw new IllegalStateException(String.format("Only %s protocal is valid to be wrapped", PROTOCOL));
        }
        return new MongoFileUrl(url);
    }

    public static final boolean isValidUrl(String spec) {
        try {
            return null != MongoFileUrl.construct(spec);
        }
        catch (Throwable t) {
            return false;
        }
    }

    MongoFileUrl(URL url) {
        this.url = url;
    }

    public String toString() {
        return this.url.toString();
    }

    public String getProtocol() {
        return this.url.getProtocol();
    }

    public URL getUrl() {
        return this.url;
    }

    public ObjectId getMongoFileId() {
        return new ObjectId(this.url.getQuery());
    }

    public String getFilePath() {
        return this.url.getPath();
    }

    public String getFileName() {
        return new File(this.url.getPath()).getName();
    }

    public String getExtension() {
        return FileUtil.getExtension(new File(this.url.getPath())).toLowerCase();
    }

    public String getMediaType() {
        return this.url.getRef();
    }

    public StorageFormat getFormat() {
        return StorageFormat.find(this.url.getHost());
    }

    public boolean isStoredCompressed() {
        StorageFormat fmt = StorageFormat.find(this.url.getHost());
        return fmt != null ? fmt.isCompressed() : false;
    }

    public boolean isStoredEncrypted() {
        StorageFormat fmt = StorageFormat.find(this.url.getHost());
        return fmt != null ? fmt.isEncrypted() : false;
    }

    public boolean isDataCompressable() {
        return CompressionMediaTypes.isCompressable(this.getMediaType());
    }
}

