/*
 * Decompiled with CFR 0.152.
 */
package me.lightspeed7.mongofs.gridfs;

import java.io.IOException;
import java.io.InputStream;
import me.lightspeed7.mongofs.gridfs.GridFSDBFile;

public class GridFSInputStream
extends InputStream {
    private final int numberOfChunks;
    private int currentChunkId = -1;
    private int offset = 0;
    private byte[] buffer = null;
    private GridFSDBFile that;

    GridFSInputStream(GridFSDBFile that) {
        this.that = that;
        this.numberOfChunks = that.numChunks();
    }

    @Override
    public int available() {
        if (this.buffer == null) {
            return 0;
        }
        return this.buffer.length - this.offset;
    }

    @Override
    public int read() {
        byte[] b = new byte[1];
        int res = this.read(b);
        if (res < 0) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (this.buffer == null || this.offset >= this.buffer.length) {
            if (this.currentChunkId + 1 >= this.numberOfChunks) {
                return -1;
            }
            this.buffer = this.that.getChunk(++this.currentChunkId);
            this.offset = 0;
        }
        int r = Math.min(len, this.buffer.length - this.offset);
        System.arraycopy(this.buffer, this.offset, b, off, r);
        this.offset += r;
        return r;
    }

    @Override
    public long skip(long bytesToSkip) throws IOException {
        if (bytesToSkip <= 0L) {
            return 0L;
        }
        if (this.currentChunkId == this.numberOfChunks) {
            return 0L;
        }
        long offsetInFile = 0L;
        long chunkSize = this.that.getChunkSize();
        if (this.currentChunkId >= 0) {
            offsetInFile = (long)this.currentChunkId * chunkSize + (long)this.offset;
        }
        if (bytesToSkip + offsetInFile >= this.that.getLength()) {
            this.currentChunkId = this.numberOfChunks;
            this.buffer = null;
            return this.that.getLength() - offsetInFile;
        }
        int temp = this.currentChunkId;
        this.currentChunkId = (int)((bytesToSkip + offsetInFile) / chunkSize);
        if (temp != this.currentChunkId) {
            this.buffer = this.that.getChunk(this.currentChunkId);
        }
        this.offset = (int)((bytesToSkip + offsetInFile) % chunkSize);
        return bytesToSkip;
    }
}

