/*
 * Decompiled with CFR 0.152.
 */
package me.lightspeed7.mongofs.gridfs;

import com.mongodb.DBCollection;
import com.mongodb.MongoException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import me.lightspeed7.mongofs.BufferedChunksOutputStream;
import me.lightspeed7.mongofs.FileChunksOutputStreamSink;
import me.lightspeed7.mongofs.InputFile;
import me.lightspeed7.mongofs.MongoFileConstants;
import me.lightspeed7.mongofs.gridfs.GridFS;
import me.lightspeed7.mongofs.gridfs.GridFSFile;
import me.lightspeed7.mongofs.gridfs.GridFSInputFileAdapter;
import me.lightspeed7.mongofs.util.BytesCopier;
import org.bson.types.ObjectId;
import org.mongodb.Document;
import org.mongodb.MongoCollection;

public class GridFSInputFile
extends GridFSFile
implements InputFile {
    private final InputStream inputStream;
    private final boolean closeStreamOnPersist;
    private boolean savedChunks = false;
    private OutputStream outputStream = null;

    protected GridFSInputFile(GridFS fs, InputStream in, String filename, boolean closeStreamOnPersist) {
        this.fs = fs;
        this.inputStream = in;
        this.filename = filename;
        this.closeStreamOnPersist = closeStreamOnPersist;
        this.id = new ObjectId();
        this.chunkSize = 261120;
        this.uploadDate = new Date();
    }

    private OutputStream generateOutputStream(DBCollection collection) {
        GridFSInputFileAdapter adapter = new GridFSInputFileAdapter(this);
        FileChunksOutputStreamSink streamSink = new FileChunksOutputStreamSink(new MongoCollection<Document>(collection), this.id, adapter, null);
        BufferedChunksOutputStream stream = new BufferedChunksOutputStream((OutputStream)streamSink, this.chunkSize);
        return stream;
    }

    protected GridFSInputFile(GridFS fs, InputStream in, String filename) {
        this(fs, in, filename, false);
    }

    protected GridFSInputFile(GridFS fs, String filename) {
        this(fs, null, filename);
    }

    protected GridFSInputFile(GridFS fs) {
        this(fs, null, null);
    }

    public void setId(Object id) {
        this.id = id;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setChunkSize(int chunkSize) {
        if (this.outputStream != null || this.savedChunks) {
            return;
        }
        this.chunkSize = chunkSize;
    }

    @Override
    public void save() {
        this.save(this.chunkSize);
    }

    final void superSave() {
        super.save();
    }

    public void save(int chunkSize) {
        if (this.outputStream != null) {
            throw new MongoException("cannot mix OutputStream and regular save()");
        }
        if (!this.savedChunks) {
            try {
                this.saveChunks(chunkSize);
            }
            catch (IOException ioe) {
                throw new MongoException("couldn't save chunks", (Throwable)ioe);
            }
        }
        super.save();
    }

    public int saveChunks() throws IOException {
        return this.saveChunks(this.chunkSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveChunks(int chunkSize) throws IOException {
        if (this.outputStream != null) {
            throw new MongoException("Cannot mix OutputStream and regular save()");
        }
        if (this.savedChunks) {
            throw new MongoException("Chunks already saved!");
        }
        if (chunkSize <= 0) {
            throw new MongoException("chunkSize must be greater than zero");
        }
        if (this.chunkSize != chunkSize) {
            this.chunkSize = chunkSize;
        }
        this.outputStream = this.generateOutputStream(this.fs.getChunksCollection());
        try {
            new BytesCopier(this.inputStream, this.outputStream, this.closeStreamOnPersist).transfer(false);
        }
        finally {
            this.outputStream.close();
        }
        return (int)this.getAsLong(MongoFileConstants.chunkCount.name());
    }

    public OutputStream getOutputStream() {
        if (this.outputStream == null) {
            this.outputStream = this.generateOutputStream(this.fs.getChunksCollection());
        }
        return this.outputStream;
    }
}

