/*
 * Decompiled with CFR 0.152.
 */
package me.lightspeed7.mongofs.gridfs;

import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.util.JSON;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.lightspeed7.mongofs.MongoFileConstants;
import me.lightspeed7.mongofs.gridfs.GridFS;
import org.bson.BSONObject;

public abstract class GridFSFile
implements DBObject {
    final DBObject extra = new BasicDBObject();
    GridFS fs;
    Object id;
    String filename;
    String contentType;
    long length;
    int chunkSize;
    Date uploadDate;
    String md5;

    public void save() {
        if (this.fs == null) {
            throw new MongoException("need fs");
        }
        this.fs.getFilesCollection().save((DBObject)this);
    }

    public void validate() {
        if (this.fs == null) {
            throw new MongoException("no fs");
        }
        if (this.md5 == null) {
            throw new MongoException("no md5 stored");
        }
        BasicDBObject cmd = new BasicDBObject("filemd5", this.id);
        cmd.put("root", (Object)this.fs.getBucketName());
        CommandResult res = this.fs.getDB().command((DBObject)cmd);
        if (res != null && res.containsField("md5")) {
            String m = res.get("md5").toString();
            if (m.equals(this.md5)) {
                return;
            }
            throw new MongoException("md5 differ.  mine [" + this.md5 + "] theirs [" + m + "]");
        }
        throw new MongoException("no md5 returned from server: " + res);
    }

    public int numChunks() {
        double d = this.length;
        return (int)Math.ceil(d /= (double)this.chunkSize);
    }

    public Object getId() {
        return this.id;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getLength() {
        return this.length;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public Date getUploadDate() {
        return this.uploadDate;
    }

    public List<String> getAliases() {
        return (List)this.extra.get("aliases");
    }

    public DBObject getMetaData() {
        return (DBObject)this.extra.get("metadata");
    }

    public void setMetaData(DBObject metadata) {
        this.extra.put("metadata", (Object)metadata);
    }

    public String getMD5() {
        return this.md5;
    }

    public long getAsLong(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        Object value = this.get(key);
        if (value == null) {
            return -1L;
        }
        return Long.parseLong(value.toString());
    }

    public Object put(String key, Object v) {
        if (key == null) {
            throw new RuntimeException("key should never be null");
        }
        if (key.equals("_id")) {
            this.id = v;
        } else if (key.equals("filename")) {
            this.filename = v == null ? null : v.toString();
        } else if (key.equals("contentType")) {
            this.contentType = (String)v;
        } else if (key.equals("length")) {
            this.length = ((Number)v).longValue();
        } else if (key.equals("chunkSize")) {
            this.chunkSize = ((Number)v).intValue();
        } else if (key.equals("uploadDate")) {
            this.uploadDate = (Date)v;
        } else if (key.equals("md5")) {
            this.md5 = (String)v;
        } else {
            this.extra.put(key, v);
        }
        return v;
    }

    public Object get(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key should never be null");
        }
        if (key.equals("_id")) {
            return this.id;
        }
        if (key.equals("filename")) {
            return this.filename;
        }
        if (key.equals("contentType")) {
            return this.contentType;
        }
        if (key.equals("length")) {
            return this.length;
        }
        if (key.equals("chunkSize")) {
            return this.chunkSize;
        }
        if (key.equals("uploadDate")) {
            return this.uploadDate;
        }
        if (key.equals("md5")) {
            return this.md5;
        }
        return this.extra.get(key);
    }

    @Deprecated
    public boolean containsKey(String key) {
        return this.containsField(key);
    }

    public boolean containsField(String s) {
        return this.keySet().contains(s);
    }

    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(MongoFileConstants.getFields(false));
        keys.addAll(this.extra.keySet());
        return keys;
    }

    public boolean isPartialObject() {
        return false;
    }

    public void markAsPartialObject() {
        throw new MongoException("Can't load partial GridFSFile file");
    }

    public String toString() {
        return JSON.serialize((Object)this);
    }

    public void putAll(BSONObject o) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    public Map<?, ?> toMap() {
        throw new UnsupportedOperationException();
    }

    public Object removeField(String key) {
        throw new UnsupportedOperationException();
    }
}

