/*
 * Decompiled with CFR 0.152.
 */
package me.lightspeed7.mongofs.gridfs;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import me.lightspeed7.mongofs.gridfs.GridFSFile;
import me.lightspeed7.mongofs.gridfs.GridFSInputStream;

public class GridFSDBFile
extends GridFSFile {
    public InputStream getInputStream() {
        return new GridFSInputStream(this);
    }

    public long writeTo(String filename) throws IOException {
        return this.writeTo(new File(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeTo(File f) throws IOException {
        try (FileOutputStream out = null;){
            out = new FileOutputStream(f);
            long l = this.writeTo(out);
            return l;
        }
    }

    public long writeTo(OutputStream out) throws IOException {
        int nc = this.numChunks();
        for (int i = 0; i < nc; ++i) {
            out.write(this.getChunk(i));
        }
        return this.length;
    }

    byte[] getChunk(int i) {
        if (this.fs == null) {
            throw new IllegalStateException("No GridFS instance defined!");
        }
        DBObject chunk = this.fs.getChunksCollection().findOne((DBObject)new BasicDBObject("files_id", this.id).append("n", (Object)i));
        if (chunk == null) {
            throw new MongoException("Can't find a chunk!  file id: " + this.id + " chunk: " + i);
        }
        return (byte[])chunk.get("data");
    }

    void remove() {
        this.fs.getFilesCollection().remove((DBObject)new BasicDBObject("_id", this.id));
        this.fs.getChunksCollection().remove((DBObject)new BasicDBObject("files_id", this.id));
    }
}

