/*
 * Decompiled with CFR 0.152.
 */
package me.lightspeed7.mongofs.crypto;

import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import me.lightspeed7.mongofs.crypto.Crypto;
import me.lightspeed7.mongofs.util.ChunkSize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicCrypto
implements Crypto {
    private static final String SALT = "SayNoToOracle";
    private static final char[] PASSWORD = "MongoDB Rules The World!".toCharArray();
    private static final String CIHPER_NAME = "AES";
    private static final Logger LOG = LoggerFactory.getLogger(Crypto.class);
    private Cipher cipher;
    private Cipher decipher;
    private ChunkSize chunkSize = ChunkSize.small_32K;

    public BasicCrypto() {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec spec = new PBEKeySpec(PASSWORD, SALT.getBytes("UTF-8"), 1024, 128);
            SecretKey tmp = factory.generateSecret(spec);
            SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), CIHPER_NAME);
            this.cipher = Cipher.getInstance(CIHPER_NAME);
            this.cipher.init(1, secret);
            this.decipher = Cipher.getInstance(CIHPER_NAME);
            this.decipher.init(2, secret);
        }
        catch (Throwable t) {
            LOG.error(String.format("Unable to initialize %s crypto", CIHPER_NAME));
        }
    }

    public BasicCrypto(ChunkSize chunkSize) {
        this();
        this.chunkSize = chunkSize;
    }

    @Override
    public byte[] encrypt(byte[] dataIn, int offset, int length) throws GeneralSecurityException {
        return this.cipher.doFinal(dataIn, offset, length);
    }

    @Override
    public byte[] decrypt(byte[] dataIn, int offset, int length) throws GeneralSecurityException {
        return this.decipher.doFinal(dataIn, offset, length);
    }

    @Override
    public ChunkSize getChunkSize() {
        return this.chunkSize;
    }
}

