/*
 * Decompiled with CFR 0.152.
 */
package me.lightspeed7.mongofs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import me.lightspeed7.mongofs.MongoFile;
import me.lightspeed7.mongofs.MongoFileConstants;
import me.lightspeed7.mongofs.MongoFileStore;
import me.lightspeed7.mongofs.MongoFileWriter;
import me.lightspeed7.mongofs.MongoManifest;
import me.lightspeed7.mongofs.util.FileUtil;

public class MongoZipFileExpander {
    private MongoFileStore store;
    private MongoFile zip;

    MongoZipFileExpander(MongoFileStore store, MongoFile zip) {
        this.store = store;
        this.zip = zip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MongoManifest expandFrom(InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("passed inputStream cannot be null");
        }
        MongoManifest manifest = new MongoManifest(this.zip);
        this.zip.put(MongoFileConstants.manifestId, this.zip.get(MongoFileConstants._id));
        this.zip.put(MongoFileConstants.manifestNum, (Object)0);
        ZipInputStream zipStream = new ZipInputStream(in);
        long readBytesTotal = 0L;
        long storageBytesTotal = 0L;
        try {
            byte[] buff = new byte[2048];
            long fileNumber = 1L;
            ZipEntry zipEntry = zipStream.getNextEntry();
            while (zipEntry != null) {
                String name = zipEntry.getName();
                if (!zipEntry.isDirectory()) {
                    MongoFileWriter writer = this.store.createNew(name, FileUtil.getContentType(name));
                    MongoFile mongoFile = writer.getMongoFile();
                    mongoFile.put(MongoFileConstants.manifestId, this.zip.get(MongoFileConstants._id));
                    mongoFile.put(MongoFileConstants.manifestNum, (Object)fileNumber);
                    manifest.addMongoFile(mongoFile);
                    OutputStream out = writer.getOutputStream();
                    try {
                        int l = zipStream.read(buff);
                        while (l > 0) {
                            out.write(buff, 0, l);
                            readBytesTotal += (long)l;
                            l = zipStream.read(buff);
                        }
                        out.flush();
                    }
                    finally {
                        if (out != null) {
                            out.close();
                        }
                        storageBytesTotal += mongoFile.getStorageLength();
                    }
                    ++fileNumber;
                }
                zipEntry = zipStream.getNextEntry();
            }
        }
        finally {
            zipStream.close();
            this.zip.put(MongoFileConstants.storage, (Object)0);
            double ratio = (double)storageBytesTotal / (double)readBytesTotal;
            this.zip.put(MongoFileConstants.ratio, (Object)ratio);
            this.zip.save();
        }
        return manifest;
    }
}

