/*
 * Decompiled with CFR 0.152.
 */
package me.lightspeed7.mongofs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import me.lightspeed7.mongofs.BufferedChunksOutputStream;
import me.lightspeed7.mongofs.CountingOutputStream;
import me.lightspeed7.mongofs.FileChunksOutputStreamSink;
import me.lightspeed7.mongofs.MongoEncryptionOutputStream;
import me.lightspeed7.mongofs.MongoFile;
import me.lightspeed7.mongofs.MongoFileConstants;
import me.lightspeed7.mongofs.MongoFileStore;
import me.lightspeed7.mongofs.MongoFileWriterAdapter;
import me.lightspeed7.mongofs.MongoGZipOutputStream;
import me.lightspeed7.mongofs.MongoManifest;
import me.lightspeed7.mongofs.MongoZipFileExpander;
import me.lightspeed7.mongofs.url.MongoFileUrl;
import me.lightspeed7.mongofs.util.BytesCopier;
import org.mongodb.Document;
import org.mongodb.MongoCollection;

public class MongoFileWriter {
    private MongoFile file;
    private MongoFileUrl url;
    private MongoCollection<Document> chunksCollection;
    private MongoFileStore store;

    public MongoFileWriter(MongoFileStore store, MongoFileUrl url, MongoFile file, MongoCollection<Document> chunksCollection) {
        this.store = store;
        this.url = url;
        this.file = file;
        this.chunksCollection = chunksCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MongoFile write(InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("passed inputStream cannot be null");
        }
        try (OutputStream out = this.getOutputStream();){
            new BytesCopier(in, out).transfer(true);
        }
        this.file.validate();
        return this.store.findOne(this.file.getId());
    }

    public OutputStream getOutputStream() throws IOException {
        MongoFileWriterAdapter adapter = new MongoFileWriterAdapter(this.file);
        FileChunksOutputStreamSink chunks = new FileChunksOutputStreamSink(this.chunksCollection, this.file.getId(), adapter, this.file.getExpiresAt());
        OutputStream sink = new BufferedChunksOutputStream((OutputStream)chunks, this.file.getChunkSize());
        if (this.url.isStoredEncrypted()) {
            sink = new MongoEncryptionOutputStream(this.store.getConfig(), this.file, sink);
        }
        if (this.url.isStoredCompressed()) {
            return new MongoGZipOutputStream(this.file, sink);
        }
        return new CountingOutputStream(MongoFileConstants.length, this.file, sink);
    }

    public MongoManifest uploadZipFile(InputStream in) throws IOException {
        return new MongoZipFileExpander(this.store, this.file).expandFrom(in);
    }

    public MongoFile getMongoFile() {
        return this.file;
    }

    public String toString() {
        return String.format("MongoFileWriter [chunksCollection=%s, url=%s]", this.chunksCollection, this.url);
    }
}

