/*
 * Decompiled with CFR 0.152.
 */
package me.lightspeed7.mongofs;

import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import me.lightspeed7.mongofs.crypto.Crypto;
import me.lightspeed7.mongofs.util.ChunkSize;

public final class MongoFileStoreConfig {
    public static final ChunkSize DEFAULT_CHUNKSIZE = ChunkSize.medium_256K;
    private String bucket = "fileStore";
    private WriteConcern writeConcern = WriteConcern.JOURNALED;
    private ReadPreference readPreference = ReadPreference.primary();
    private boolean enableCompression = true;
    private ChunkSize chunkSize = DEFAULT_CHUNKSIZE;
    private boolean asyncDeletes = true;
    private Crypto crypto = null;

    private MongoFileStoreConfig() {
    }

    public String getBucket() {
        return this.bucket;
    }

    private void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    private void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    private void setReadPreference(ReadPreference readPreference) {
        this.readPreference = readPreference;
    }

    public boolean isCompressionEnabled() {
        return this.enableCompression;
    }

    private void setEnableCompression(boolean enableCompression) {
        this.enableCompression = enableCompression;
    }

    public ChunkSize getChunkSize() {
        return this.chunkSize;
    }

    private void setChunkSize(ChunkSize chunkSize) {
        this.chunkSize = chunkSize;
    }

    public boolean isAsyncDeletes() {
        return this.asyncDeletes;
    }

    private void setAsyncDeletes(boolean asyncDeletes) {
        this.asyncDeletes = asyncDeletes;
    }

    public Crypto getEncryption() {
        return this.crypto;
    }

    public void setEnryption(Crypto crypto) {
        this.crypto = crypto;
    }

    public boolean isEncryptionEnabled() {
        return this.crypto != null;
    }

    public String toString() {
        return String.format("MongoFileStoreConfig [bucket=%s, chunkSize=%s, enableCompression=%s, cryptoEnabled=%s, writeConcern=%s, readPreference=%s]", new Object[]{this.bucket, this.chunkSize, this.enableCompression, this.crypto != null, this.writeConcern, this.readPreference});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private MongoFileStoreConfig config = new MongoFileStoreConfig();

        public MongoFileStoreConfig build() {
            return this.config;
        }

        public Builder asyncDeletes(boolean value) {
            this.config.setAsyncDeletes(value);
            return this;
        }

        public Builder bucket(String value) {
            if (value == null || value.trim().isEmpty()) {
                throw new IllegalArgumentException("bucket name cannot be nul of empty");
            }
            this.config.setBucket(value);
            return this;
        }

        public MongoFileStoreConfig gridFSCompatible(String bucket) {
            this.config.asyncDeletes = false;
            this.config.bucket = bucket;
            this.config.chunkSize = ChunkSize.medium_256K;
            this.config.crypto = null;
            this.config.enableCompression = false;
            this.config.crypto = null;
            this.config.readPreference = null;
            this.config.writeConcern = null;
            return this.config;
        }

        public Builder chunkSize(ChunkSize chunkSize) {
            this.config.setChunkSize(chunkSize);
            return this;
        }

        public Builder enableCompression(boolean value) {
            this.config.setEnableCompression(value);
            return this;
        }

        public Builder enableEncryption(Crypto crypto) {
            if (crypto == null) {
                return this;
            }
            if (crypto.getChunkSize() == null) {
                throw new IllegalArgumentException("Encryption algorithm must specfic chunk size");
            }
            if (crypto.getChunkSize().greaterThan(this.config.getChunkSize())) {
                throw new IllegalArgumentException("Encryption chunk size cannot be greater than file chunk size ");
            }
            if (crypto.getChunkSize() == ChunkSize.mongo_16M) {
                throw new IllegalArgumentException("Encryption chunk size cannot be be 'mongo_16M', since that is the max size for MongoDB documents and excrypting may increase the size of the data to be saved in a single chunk");
            }
            this.config.setEnryption(crypto);
            return this;
        }

        public Builder readPreference(ReadPreference value) {
            this.config.setReadPreference(value);
            return this;
        }

        public Builder writeConcern(WriteConcern value) {
            this.config.setWriteConcern(value);
            return this;
        }
    }
}

