/*
 * Decompiled with CFR 0.152.
 */
package me.lightspeed7.mongofs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.lightspeed7.mongofs.MongoFile;
import me.lightspeed7.mongofs.MongoFileStore;
import org.mongodb.Document;
import org.mongodb.MongoCursor;
import org.mongodb.ServerCursor;
import org.mongodb.connection.ServerAddress;

public class MongoFileCursor
implements MongoCursor<MongoFile>,
Iterator<MongoFile>,
Iterable<MongoFile> {
    private final MongoCursor<Document> cursor;
    private final MongoFileStore store;

    MongoFileCursor(MongoFileStore store, MongoCursor<Document> cursor) {
        this.store = store;
        this.cursor = cursor;
    }

    @Override
    public Iterator<MongoFile> iterator() {
        return this;
    }

    @Override
    public MongoFile next() {
        if (this.cursor.hasNext()) {
            return new MongoFile(this.store, this.cursor.next());
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.cursor.hasNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    @Override
    public ServerAddress getServerAddress() {
        return this.cursor.getServerAddress();
    }

    @Override
    public ServerCursor getServerCursor() {
        return this.cursor.getServerCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MongoFile> toList() {
        ArrayList<MongoFile> files = new ArrayList<MongoFile>();
        try {
            while (this.cursor.hasNext()) {
                files.add(new MongoFile(this.store, this.cursor.next()));
            }
        }
        finally {
            if (this.cursor != null) {
                this.cursor.close();
            }
        }
        return files;
    }

    public String toString() {
        return String.format("MongoFileCursor [ store=%s, %n  cursor=%s%n]", this.store, this.cursor);
    }
}

