/*
 * Decompiled with CFR 0.152.
 */
package me.lightspeed7.mongofs;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.zip.GZIPInputStream;
import me.lightspeed7.mongofs.CountingInputStream;
import me.lightspeed7.mongofs.DecryptInputStream;
import me.lightspeed7.mongofs.FileChunksInputStreamSource;
import me.lightspeed7.mongofs.InputFile;
import me.lightspeed7.mongofs.MongoFileConstants;
import me.lightspeed7.mongofs.MongoFileStore;
import me.lightspeed7.mongofs.url.MongoFileUrl;
import me.lightspeed7.mongofs.url.Parser;
import me.lightspeed7.mongofs.url.StorageFormat;
import me.lightspeed7.mongofs.util.BytesCopier;
import org.bson.types.ObjectId;
import org.mongodb.Document;
import org.mongodb.MongoException;

public class MongoFile
implements InputFile {
    private final Document surrogate;
    private final MongoFileStore store;
    private StorageFormat format;

    MongoFile(MongoFileStore store, Document surrogate) {
        this.store = store;
        this.surrogate = surrogate;
        this.format = this.fetchFormat(surrogate);
    }

    private StorageFormat fetchFormat(Document surrogate) {
        String format = surrogate.getString(MongoFileConstants.format);
        if (format == null) {
            format = surrogate.getString(MongoFileConstants.compressionFormat);
        }
        if (format == null) {
            return StorageFormat.GRIDFS;
        }
        return StorageFormat.find(format);
    }

    MongoFile(MongoFileStore store, MongoFileUrl url, long chunkSize) {
        this.store = store;
        this.format = url.getFormat();
        this.surrogate = new Document();
        this.surrogate.put(MongoFileConstants._id.toString(), url.getMongoFileId());
        this.surrogate.put(MongoFileConstants.uploadDate.toString(), new Date());
        this.surrogate.put(MongoFileConstants.chunkSize.toString(), chunkSize);
        this.surrogate.put(MongoFileConstants.filename.toString(), url.getFilePath());
        this.surrogate.put(MongoFileConstants.contentType.toString(), url.getMediaType());
        if (url.getFormat() != null) {
            this.surrogate.put(MongoFileConstants.format.toString(), url.getFormat().getCode());
        }
    }

    private String getBucketName() {
        return this.store.getFilesCollection().getName().split("\\.")[0];
    }

    public void save() {
        this.store.getFilesCollection().save(this.surrogate);
    }

    public void validate() {
        MongoFileConstants md5key = MongoFileConstants.md5;
        String md5 = this.getString(md5key);
        if (md5 == null) {
            throw new MongoException("no md5 stored");
        }
        Document cmd = new Document("filemd5", this.get(MongoFileConstants._id));
        cmd.put("root", this.getBucketName());
        Document res = this.store.getFilesCollection().getDatabase().executeCommand(cmd).getResponse();
        if (res != null && res.containsKey(md5key.toString())) {
            String m = res.get(md5key.toString()).toString();
            if (m.equals(md5)) {
                return;
            }
            throw new MongoException("md5 differ.  mine [" + md5 + "] theirs [" + m + "]");
        }
        throw new MongoException("no md5 returned from server: " + res);
    }

    public MongoFileUrl getURL() throws MalformedURLException {
        URL url = Parser.construct(this.getId(), this.getFilename(), this.getContentType(), this.format);
        return MongoFileUrl.construct(url);
    }

    public final InputStream getInputStream() throws IOException {
        InputStream returned = new FileChunksInputStreamSource(this.store, this);
        returned = new CountingInputStream(this, returned);
        if (this.getURL().isStoredEncrypted()) {
            if (this.store.getConfig().getEncryption() == null) {
                throw new IllegalStateException("File is stored in ecrypted but store is not configured for decryption");
            }
            returned = new DecryptInputStream(this.store.getConfig().getEncryption(), this, returned);
        }
        if (this.getURL().isStoredCompressed()) {
            returned = new GZIPInputStream(returned);
        }
        return returned;
    }

    public OutputStream readInto(OutputStream out, boolean flush) throws IOException {
        new BytesCopier(this.getInputStream(), out).transfer(flush);
        return out;
    }

    public String readIntoString() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(this.getChunkSize() * this.getChunkCount());
        new BytesCopier(this.getInputStream(), out).transfer(true);
        return out.toString("UTF-8");
    }

    public int getChunkCount() {
        int chunkCount = this.getInt(MongoFileConstants.chunkCount, -1);
        if (chunkCount == -1) {
            chunkCount = (int)Math.ceil((double)this.getLength() / (double)this.getChunkSize());
        }
        return chunkCount;
    }

    public long getLength() {
        return this.getLong(MongoFileConstants.length);
    }

    public long getStorageLength() {
        if (this.containsKey(MongoFileConstants.storage.name())) {
            return this.getLong(MongoFileConstants.storage);
        }
        return this.getLong(MongoFileConstants.compressedLength);
    }

    public String getMD5() {
        return this.getString(MongoFileConstants.md5);
    }

    public ObjectId getId() {
        return (ObjectId)this.surrogate.get("_id");
    }

    public String getFilename() {
        return this.getString(MongoFileConstants.filename);
    }

    public String getContentType() {
        return this.getString(MongoFileConstants.contentType);
    }

    public int getChunkSize() {
        return this.getInt(MongoFileConstants.chunkSize);
    }

    public Date getUploadDate() {
        return (Date)this.get(MongoFileConstants.uploadDate);
    }

    public boolean isDeleted() {
        return this.getBoolean(MongoFileConstants.deleted, false);
    }

    public List<String> getAliases() {
        return (List)this.get(MongoFileConstants.aliases);
    }

    public void setAliases(List<String> aliases) {
        this.put(MongoFileConstants.aliases, aliases);
    }

    public Document getMetaData() {
        Object object = this.get(MongoFileConstants.metadata);
        if (object == null) {
            return null;
        }
        return new Document((DBObject)((BasicDBObject)object));
    }

    public void setMetaData(Document metadata) {
        this.put(MongoFileConstants.metadata, (Object)metadata);
    }

    public Object setInMetaData(String key, Object value) {
        Document object = this.getMetaData();
        if (object == null) {
            object = new Document();
            this.setMetaData(object);
        }
        return object.put(key, value);
    }

    void setExpiresAt(Date when) {
        this.put(MongoFileConstants.expireAt, (Object)when);
    }

    public Date getExpiresAt() {
        return this.getDate(MongoFileConstants.expireAt, null);
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key should never be null");
        }
        return this.surrogate.put(key, value);
    }

    public Object put(MongoFileConstants key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key should never be null");
        }
        return this.surrogate.put(key.name(), value);
    }

    @Override
    public Object get(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key should never be null");
        }
        return this.surrogate.get(key);
    }

    public Object get(MongoFileConstants key) {
        if (key == null) {
            throw new IllegalArgumentException("Key should never be null");
        }
        return this.surrogate.get(key.name());
    }

    public String getString(MongoFileConstants key) {
        return (String)this.surrogate.get(key.name());
    }

    public int getInt(MongoFileConstants key) {
        return this.getInt(key, -1);
    }

    public long getLong(MongoFileConstants key) {
        return this.getLong(key, -1L);
    }

    public int getInt(MongoFileConstants key, int def) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        Object value = this.surrogate.get(key.name());
        if (value == null) {
            return def;
        }
        return Integer.parseInt(value.toString());
    }

    public long getLong(MongoFileConstants key, long def) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        Object value = this.surrogate.get(key.name());
        if (value == null) {
            return def;
        }
        return Long.parseLong(value.toString());
    }

    public double getDouble(MongoFileConstants key, double def) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        Object value = this.surrogate.get(key.name());
        if (value == null) {
            return def;
        }
        return Double.parseDouble(value.toString());
    }

    public String getString(MongoFileConstants key, String def) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        Object value = this.surrogate.get(key.name());
        if (value == null) {
            return def;
        }
        return value.toString();
    }

    public boolean getBoolean(MongoFileConstants key, boolean def) {
        Object foo = this.surrogate.get(key.name());
        if (foo == null) {
            return def;
        }
        if (foo instanceof Number) {
            return ((Number)foo).intValue() > 0;
        }
        if (foo instanceof Boolean) {
            return (Boolean)foo;
        }
        throw new IllegalArgumentException("can't coerce to bool:" + foo.getClass());
    }

    public ObjectId getObjectId(MongoFileConstants key, ObjectId def) {
        Object foo = this.surrogate.get(key.toString());
        return foo != null ? (ObjectId)foo : def;
    }

    public Date getDate(MongoFileConstants key, Date def) {
        Object foo = this.surrogate.get(key.toString());
        return foo != null ? (Date)foo : def;
    }

    public boolean containsKey(String key) {
        return this.surrogate.containsKey(key);
    }

    public String toString() {
        return this.surrogate.toString();
    }

    public boolean isCompressed() {
        return this.format.isCompressed();
    }

    public boolean isEncrypted() {
        return this.format.isEncrypted();
    }

    public boolean isExpandedZipFile() {
        return 0 == this.getInt(MongoFileConstants.manifestNum, -1);
    }
}

