/*
 * Decompiled with CFR 0.152.
 */
package me.lightspeed7.mongofs;

import java.io.IOException;
import java.io.OutputStream;
import me.lightspeed7.mongofs.BufferedChunksOutputStream;
import me.lightspeed7.mongofs.CountingOutputStream;
import me.lightspeed7.mongofs.EncryptChunkOutputStream;
import me.lightspeed7.mongofs.MongoFile;
import me.lightspeed7.mongofs.MongoFileConstants;
import me.lightspeed7.mongofs.MongoFileStoreConfig;

public class MongoEncryptionOutputStream
extends OutputStream {
    private MongoFile inputFile;
    private OutputStream surrogate;

    public MongoEncryptionOutputStream(MongoFileStoreConfig config, MongoFile inputFile, OutputStream given) throws IOException {
        CountingOutputStream after = new CountingOutputStream(MongoFileConstants.storage, inputFile, given);
        EncryptChunkOutputStream encryption = new EncryptChunkOutputStream(config.getEncryption(), after);
        BufferedChunksOutputStream chunking = new BufferedChunksOutputStream((OutputStream)encryption, config.getEncryption().getChunkSize());
        CountingOutputStream before = new CountingOutputStream(MongoFileConstants.length, inputFile, chunking);
        this.surrogate = before;
        this.inputFile = inputFile;
    }

    @Override
    public void write(int b) throws IOException {
        this.surrogate.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.surrogate.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.surrogate.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.surrogate.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            this.surrogate.close();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException("Unhandled exception caught", t);
        }
        finally {
            long length = this.inputFile.getLong(MongoFileConstants.length, 0L);
            long compressed = this.inputFile.getLong(MongoFileConstants.storage, 0L);
            double ratio = 0.0;
            if (length > 0L) {
                ratio = (double)compressed / (double)length;
            }
            this.inputFile.put(MongoFileConstants.ratio.toString(), (Object)ratio);
            this.inputFile.save();
        }
    }
}

