/*
 * Decompiled with CFR 0.152.
 */
package me.lightspeed7.mongofs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import me.lightspeed7.mongofs.ChunksStatisticsAdapter;
import me.lightspeed7.mongofs.MongoFileConstants;
import org.mongodb.Document;
import org.mongodb.MongoCollection;

public class FileChunksOutputStreamSink
extends OutputStream {
    private Object id;
    private MongoCollection<Document> collection;
    private int currentChunkNumber = 0;
    private ChunksStatisticsAdapter adapter;
    private Date expiresAt;

    public FileChunksOutputStreamSink(MongoCollection<Document> collection, Object fileId, ChunksStatisticsAdapter adapter, Date expiresAt) {
        this.collection = collection;
        this.id = fileId;
        this.adapter = adapter;
        this.expiresAt = expiresAt;
    }

    @Override
    public void write(int b) throws IOException {
        throw new IllegalStateException("Single byte writing not supported with this OutputStream");
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (b == null) {
            throw new IllegalArgumentException("buffer cannot be null");
        }
        super.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        byte[] internal = buffer;
        if (offset != 0 || length != buffer.length) {
            internal = new byte[length];
            System.arraycopy(buffer, offset, internal, 0, length);
        }
        Document dbObject = new Document("files_id", this.id).append("n", this.currentChunkNumber).append("sz", length).append("data", internal);
        if (this.expiresAt != null) {
            dbObject.put(MongoFileConstants.expireAt.toString(), this.expiresAt);
        }
        ++this.currentChunkNumber;
        this.collection.save(dbObject);
        this.adapter.collectFromChunk(dbObject);
    }

    @Override
    public void flush() throws IOException {
        this.adapter.flush();
    }

    @Override
    public void close() throws IOException {
        this.adapter.close();
    }
}

