/*
 * Decompiled with CFR 0.152.
 */
package me.lightspeed7.mongofs;

import java.io.IOException;
import java.io.InputStream;
import me.lightspeed7.mongofs.MongoFile;
import me.lightspeed7.mongofs.MongoFileStore;
import org.mongodb.Document;
import org.mongodb.MongoException;

public class FileChunksInputStreamSource
extends InputStream {
    private MongoFileStore store;
    private MongoFile file;
    private int currentChunkId = -1;
    private int offset = 0;
    private byte[] buffer = null;

    public FileChunksInputStreamSource(MongoFileStore store, MongoFile file) {
        this.store = store;
        this.file = file;
    }

    @Override
    public int available() {
        if (this.buffer == null) {
            return 0;
        }
        return this.buffer.length - this.offset;
    }

    @Override
    public int read() {
        byte[] b = new byte[1];
        int res = this.read(b);
        if (res < 0) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (this.buffer == null || this.offset >= this.buffer.length) {
            if (this.currentChunkId + 1 >= this.file.getChunkCount()) {
                return -1;
            }
            this.buffer = this.getChunk(++this.currentChunkId);
            this.offset = 0;
        }
        int r = Math.min(len, this.buffer.length - this.offset);
        System.arraycopy(this.buffer, this.offset, b, off, r);
        this.offset += r;
        return r;
    }

    @Override
    public long skip(long bytesToSkip) throws IOException {
        if (bytesToSkip <= 0L) {
            return 0L;
        }
        if (this.currentChunkId == this.file.getChunkCount()) {
            return 0L;
        }
        long offsetInFile = 0L;
        int chunkSize = this.file.getChunkSize();
        if (this.currentChunkId >= 0) {
            offsetInFile = this.currentChunkId * chunkSize + this.offset;
        }
        if (bytesToSkip + offsetInFile >= this.file.getLength()) {
            this.currentChunkId = this.file.getChunkCount();
            this.buffer = null;
            return this.file.getLength() - offsetInFile;
        }
        int temp = this.currentChunkId;
        this.currentChunkId = (int)((bytesToSkip + offsetInFile) / (long)chunkSize);
        if (temp != this.currentChunkId) {
            this.buffer = this.getChunk(this.currentChunkId);
        }
        this.offset = (int)((bytesToSkip + offsetInFile) % (long)chunkSize);
        return bytesToSkip;
    }

    byte[] getChunk(int i) {
        if (this.store == null) {
            throw new IllegalStateException("No MongoFileStore instance defined!");
        }
        Document chunk = this.store.getChunksCollection().find(new Document("files_id", this.file.getId()).append("n", i)).get().next();
        if (chunk == null) {
            throw new MongoException("Can't find a chunk!  file id: " + this.file.getId().toString() + " chunk: " + i);
        }
        return (byte[])chunk.get("data");
    }
}

