/*
 * Decompiled with CFR 0.152.
 */
package me.lightspeed7.mongofs;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import me.lightspeed7.mongofs.crypto.Crypto;

public class EncryptChunkOutputStream
extends OutputStream {
    private DataOutputStream out;
    private Crypto crypto;

    public EncryptChunkOutputStream(Crypto crypto, OutputStream out) {
        this.crypto = crypto;
        this.out = new DataOutputStream(out);
    }

    @Override
    public void write(int b) throws IOException {
        throw new IllegalStateException("cannot write sinle bytes to this outputstream");
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            byte[] encrypt = this.crypto.encrypt(b, off, len);
            this.out.writeInt(len);
            this.out.writeInt(encrypt.length);
            this.out.write(encrypt, 0, encrypt.length);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Error in crypto", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

