/*
 * Decompiled with CFR 0.152.
 */
package me.lightspeed7.mongofs;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import me.lightspeed7.mongofs.MongoFile;
import me.lightspeed7.mongofs.crypto.Crypto;

public class DecryptInputStream
extends InputStream {
    private Crypto crypto;
    private DataInputStream inputStream;
    private int offset = 0;
    private byte[] buffer = null;
    private long remainingBytes;

    public DecryptInputStream(Crypto crypto, MongoFile file, InputStream inputStream) {
        this.crypto = crypto;
        this.inputStream = new DataInputStream(inputStream);
        this.remainingBytes = file.getStorageLength();
    }

    @Override
    public int available() {
        if (this.buffer == null) {
            return 0;
        }
        return this.buffer.length - this.offset;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int res = this.read(b);
        if (res < 0) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.buffer == null || this.offset >= this.buffer.length) {
            if (this.remainingBytes <= 0L) {
                return -1;
            }
            this.readEncryptedChunk(true);
        }
        int r = Math.min(len, this.buffer.length - this.offset);
        System.arraycopy(this.buffer, this.offset, b, off, r);
        this.offset += r;
        return r;
    }

    private int readEncryptedChunk(boolean readActualHeader) throws IOException {
        int actualLength = readActualHeader ? this.inputStream.readInt() : -1;
        int chunkLength = this.inputStream.readInt();
        this.remainingBytes -= readActualHeader ? 8L : 4L;
        byte[] temp = new byte[chunkLength];
        if (chunkLength != this.fillBuffer(temp, 0, chunkLength)) {
            throw new IllegalStateException("Unable to pull a full chunk of data from file");
        }
        try {
            this.buffer = this.crypto.decrypt(temp, 0, chunkLength);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Error decrypting data", e);
        }
        this.offset = 0;
        return actualLength;
    }

    private int fillBuffer(byte[] temp, int offset, int length) throws IOException {
        int read = this.inputStream.read(temp, offset, length);
        this.remainingBytes -= (long)read;
        if (length != read) {
            read += this.fillBuffer(temp, read, length - read);
        }
        return read;
    }

    @Override
    public long skip(long bytesToSkip) throws IOException {
        if (bytesToSkip <= 0L) {
            return 0L;
        }
        long stillToSkip = bytesToSkip;
        while (stillToSkip > 0L) {
            if (this.buffer == null) {
                int chunkLength = this.inputStream.readInt();
                this.remainingBytes -= 4L;
                if (stillToSkip > (long)chunkLength) {
                    int length = this.inputStream.readInt();
                    long skipped = this.inputStream.skip(length);
                    this.remainingBytes -= skipped + 4L;
                    stillToSkip -= (long)chunkLength;
                    continue;
                }
                this.readEncryptedChunk(false);
                this.offset = (int)stillToSkip;
                stillToSkip = 0L;
                continue;
            }
            int toSkip = (int)Math.min(stillToSkip, (long)(this.buffer.length - this.offset));
            this.offset += toSkip;
            this.remainingBytes -= (long)toSkip;
            stillToSkip -= (long)toSkip;
            if (this.buffer.length > this.offset) continue;
            this.buffer = null;
            this.offset = 0;
        }
        return bytesToSkip;
    }
}

