/*
 * Decompiled with CFR 0.152.
 */
package me.lightspeed7.mongofs;

import java.io.IOException;
import java.io.OutputStream;
import me.lightspeed7.mongofs.MongoFile;
import me.lightspeed7.mongofs.MongoFileConstants;

public class CountingOutputStream
extends OutputStream {
    private long count = 0L;
    private MongoFileConstants key;
    private MongoFile inputFile;
    private OutputStream out;

    public CountingOutputStream(MongoFileConstants key, MongoFile inputFile, OutputStream out) {
        this.key = key;
        this.inputFile = inputFile;
        this.out = out;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.count;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.count += (long)len;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        this.inputFile.put(this.key.toString(), (Object)this.count);
        this.inputFile.save();
    }

    public long getCount() {
        return this.count;
    }
}

