/*
 * Decompiled with CFR 0.152.
 */
package me.lightspeed7.mongofs;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import me.lightspeed7.mongofs.InputFile;
import me.lightspeed7.mongofs.MongoFileConstants;
import me.lightspeed7.mongofs.util.FileUtil;
import org.mongodb.Document;

public abstract class ChunksStatisticsAdapter {
    private InputFile file;
    private MessageDigest messageDigest;
    private int chunkCount;
    private long totalSize;

    public ChunksStatisticsAdapter(InputFile file) {
        this.file = file;
        try {
            this.messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("No MD5!");
        }
    }

    public void collectFromChunk(Document obj) {
        byte[] data = (byte[])obj.get("data");
        ++this.chunkCount;
        this.messageDigest.update(data);
        this.totalSize += (long)data.length;
    }

    public void close() {
        this.file.put(MongoFileConstants.chunkCount.name(), this.chunkCount);
        this.file.put(MongoFileConstants.length.name(), this.totalSize);
        this.file.put(MongoFileConstants.md5.name(), FileUtil.toHex(this.messageDigest.digest()));
    }

    public void flush() {
    }
}

