/*
 * Decompiled with CFR 0.152.
 */
package me.lightspeed7.mongofs;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import me.lightspeed7.mongofs.util.ChunkSize;

public class BufferedChunksOutputStream
extends FilterOutputStream {
    private byte[] myBuffer;
    private int currentPosition;
    private int chunkSize;

    public BufferedChunksOutputStream(OutputStream out) {
        this(out, 8192);
    }

    public BufferedChunksOutputStream(OutputStream out, ChunkSize chunkSize) {
        this(out, chunkSize.getChunkSize());
    }

    public BufferedChunksOutputStream(OutputStream out, int chunkSize) {
        super(out);
        this.chunkSize = chunkSize;
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.myBuffer = new byte[chunkSize];
    }

    private void flushBuffer() throws IOException {
        if (this.currentPosition > 0) {
            this.out.write(this.myBuffer, 0, this.currentPosition);
            this.currentPosition = 0;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.myBuffer[this.currentPosition++] = (byte)b;
        if (this.currentPosition >= this.chunkSize) {
            this.flushBuffer();
        }
    }

    @Override
    public void write(byte[] inBuffer, int offset, int length) throws IOException {
        if (length <= 0) {
            return;
        }
        int bytesToCopy = length;
        if (bytesToCopy >= this.chunkSize - this.currentPosition) {
            if (this.currentPosition == 0) {
                System.arraycopy(inBuffer, offset, this.myBuffer, this.currentPosition, this.chunkSize);
                this.currentPosition += this.chunkSize;
                this.flushBuffer();
                this.write(inBuffer, offset + this.chunkSize, length - this.chunkSize);
            } else {
                bytesToCopy = this.chunkSize - this.currentPosition;
                System.arraycopy(inBuffer, offset, this.myBuffer, this.currentPosition, bytesToCopy);
                this.currentPosition += bytesToCopy;
                assert (this.currentPosition == this.chunkSize);
                this.flushBuffer();
                this.write(inBuffer, offset + bytesToCopy, length - bytesToCopy);
            }
        } else if (bytesToCopy > 0) {
            System.arraycopy(inBuffer, offset, this.myBuffer, this.currentPosition, bytesToCopy);
            this.currentPosition += bytesToCopy;
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }
}

