/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.reflection;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.netty.buffer.ByteBufHelper;
import com.github.retrooper.packetevents.protocol.entity.armadillo.ArmadilloState;
import com.github.retrooper.packetevents.protocol.entity.cat.CatVariant;
import com.github.retrooper.packetevents.protocol.entity.cat.CatVariants;
import com.github.retrooper.packetevents.protocol.entity.chicken.ChickenVariant;
import com.github.retrooper.packetevents.protocol.entity.chicken.ChickenVariants;
import com.github.retrooper.packetevents.protocol.entity.cow.CowVariant;
import com.github.retrooper.packetevents.protocol.entity.cow.CowVariants;
import com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import com.github.retrooper.packetevents.protocol.entity.data.EntityDataType;
import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import com.github.retrooper.packetevents.protocol.entity.frog.FrogVariant;
import com.github.retrooper.packetevents.protocol.entity.frog.FrogVariants;
import com.github.retrooper.packetevents.protocol.entity.pig.PigVariant;
import com.github.retrooper.packetevents.protocol.entity.pig.PigVariants;
import com.github.retrooper.packetevents.protocol.entity.pose.EntityPose;
import com.github.retrooper.packetevents.protocol.entity.sniffer.SnifferState;
import com.github.retrooper.packetevents.protocol.entity.wolfvariant.WolfVariant;
import com.github.retrooper.packetevents.protocol.entity.wolfvariant.WolfVariants;
import com.github.retrooper.packetevents.protocol.mapper.MappedEntity;
import com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import com.github.retrooper.packetevents.protocol.nbt.NBTList;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.protocol.player.TextureProperty;
import com.github.retrooper.packetevents.protocol.player.UserProfile;
import com.github.retrooper.packetevents.protocol.sound.SoundCategory;
import com.github.retrooper.packetevents.protocol.world.BlockFace;
import com.github.retrooper.packetevents.protocol.world.painting.PaintingVariant;
import com.github.retrooper.packetevents.protocol.world.painting.PaintingVariants;
import com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import com.github.retrooper.packetevents.protocol.world.states.type.StateTypes;
import com.github.retrooper.packetevents.resources.ResourceLocation;
import com.github.retrooper.packetevents.util.Vector3f;
import com.github.retrooper.packetevents.util.mappings.GlobalRegistryHolder;
import com.github.retrooper.packetevents.util.mappings.IRegistry;
import com.github.retrooper.packetevents.util.mappings.IRegistryHolder;
import com.github.retrooper.packetevents.util.mappings.SynchronizedRegistriesHandler;
import com.github.retrooper.packetevents.util.mappings.VersionedRegistry;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.configuration.server.WrapperConfigServerRegistryData;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.ProfileResult;
import io.netty.buffer.ByteBuf;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.AnimalColor;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.RabbitType;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableAquaWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ArrowWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.BoatWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ChestBoatWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.FishWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.GuardianWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.IllagerWizardWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.InsentientWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ItemFrameWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.MinecartSpawnerWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.MinecartTntWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.MinecartWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ModdedWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.OcelotWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.PufferFishWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SlimeWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SpiderWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SplashPotionWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.TNTWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.TameableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.TippedArrowWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.DisguiseValues;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.SkinUtils;
import me.libraryaddict.disguise.utilities.reflection.ClassMappings;
import me.libraryaddict.disguise.utilities.reflection.FakeBoundingBox;
import me.libraryaddict.disguise.utilities.reflection.LibsProfileLookupCaller;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManagerAbstract;
import me.libraryaddict.disguise.utilities.reflection.WatcherValue;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsAddedIn;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsRemovedIn;
import me.libraryaddict.disguise.utilities.reflection.legacy.LegacyReflectionManager;
import me.libraryaddict.disguise.utilities.sounds.SoundGroup;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.TreeSpecies;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fish;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Frog;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.Monster;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Salmon;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReflectionManager {
    private static String craftbukkitVersion;
    private static NmsVersion version;
    private static ReflectionManagerAbstract nmsReflection;
    private static Field trackedPlayersMap;
    private static Method fillProfileProperties;
    private static MinecraftSessionService sessionService;
    private static String minecraftVersion;
    private static Method propertyName;
    private static Method propertyValue;
    private static Method propertySignature;
    private static boolean mojangMapped;
    private static boolean runningPaper;
    private static String workingBackend;

    public static void init() {
        try {
            nmsReflection = ReflectionManager.getReflectionManager(ReflectionManager.getVersion());
            ReflectionManager.loadAuthlibStuff();
            if (ReflectionManager.isRunningPaper() && !NmsVersion.v1_17.isSupported()) {
                trackedPlayersMap = ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayerMap");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void tryLoadRegistriesIntoPE() {
        ServerVersion serverVersion = PacketEvents.getAPI().getServerManager().getVersion();
        ClientVersion cacheKey = serverVersion.toClientVersion();
        for (ByteBuf buf : ReflectionManager.getNmsReflection().getRegistryPacketdata()) {
            List elements;
            ResourceLocation key;
            WrapperConfigServerRegistryData wrapper = new WrapperConfigServerRegistryData((NBTCompound)null);
            wrapper.buffer = buf;
            wrapper.setServerVersion(serverVersion);
            wrapper.read();
            if (wrapper.getRegistryKey() != null) {
                key = wrapper.getRegistryKey();
                elements = wrapper.getElements();
            } else {
                NBTCompound compound = wrapper.getRegistryData();
                key = new ResourceLocation(compound.getStringTagValueOrThrow("type"));
                @NotNull NBTList nbtElements = compound.getCompoundListTagOrNull("value");
                if (nbtElements == null) continue;
                elements = WrapperConfigServerRegistryData.RegistryElement.convertNbt((NBTList)nbtElements);
            }
            // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable SynchronizedRegistriesHandler.RegistryEntry registryEntry = SynchronizedRegistriesHandler.getRegistryEntry((ResourceLocation)key);
            if (registryEntry == null) continue;
            registryEntry.computeSyncedRegistry((Object)cacheKey, () -> registryEntry.createFromElements(elements, (PacketWrapper)wrapper));
        }
    }

    private static void loadAuthlibStuff() throws InvocationTargetException, IllegalAccessException {
        sessionService = ReflectionManager.getNmsReflection().getMinecraftSessionService();
        try {
            fillProfileProperties = sessionService.getClass().getMethod("fillProfileProperties", GameProfile.class, Boolean.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            propertyName = Property.class.getMethod("getName", new Class[0]);
            propertyValue = Property.class.getMethod("getValue", new Class[0]);
            propertySignature = Property.class.getMethod("getSignature", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static long getGameTime(Entity entity) {
        if (entity == null || entity.getWorld() == null || !NmsVersion.v1_19_R3.isSupported()) {
            return 0L;
        }
        return entity.getWorld().getGameTime();
    }

    public static boolean hasInvul(Entity entity) {
        return ReflectionManager.getNmsReflection().hasInvul(entity);
    }

    public static int getIncrementedStateId(Player player) {
        return ReflectionManager.getNmsReflection().getIncrementedStateId(player);
    }

    public static boolean isSupported(AccessibleObject obj) {
        NmsAddedIn added;
        if (obj.isAnnotationPresent(NmsAddedIn.class) && !(added = obj.getAnnotation(NmsAddedIn.class)).value().isSupported()) {
            return false;
        }
        if (obj.isAnnotationPresent(NmsRemovedIn.class)) {
            NmsRemovedIn removed = obj.getAnnotation(NmsRemovedIn.class);
            return !removed.value().isSupported();
        }
        return true;
    }

    public static boolean isSupported(Class cl, String name) {
        try {
            for (Field field : cl.getFields()) {
                if (!field.getName().equals(name)) continue;
                return ReflectionManager.isSupported(field);
            }
            for (AccessibleObject accessibleObject : cl.getMethods()) {
                if (!((Method)accessibleObject).getName().equals(name)) continue;
                return ReflectionManager.isSupported(accessibleObject);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    public static String getResourceAsString(File file, String fileName) {
        try {
            return ReflectionManager.getResourceAsStringEx(file, fileName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static int getJarFileCount(File file) throws IOException {
        try (JarFile jar = new JarFile(file);){
            int count = 0;
            Enumeration<JarEntry> entry = jar.entries();
            while (entry.hasMoreElements()) {
                if (entry.nextElement().isDirectory()) continue;
                ++count;
            }
            int n = count;
            return n;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getResourceAsStringEx(File file, String fileName) {
        try (JarFile jar = new JarFile(file);){
            String string;
            block13: {
                JarEntry entry = jar.getJarEntry(fileName);
                InputStream stream = jar.getInputStream(entry);
                try {
                    string = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                    if (stream == null) break block13;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stream.close();
            }
            return string;
        }
    }

    public static List<File> getFilesByPlugin(String pluginName) {
        return ReflectionManager.getFilesByPlugin(LibsDisguises.getInstance().getDataFolder().getAbsoluteFile().getParentFile(), pluginName);
    }

    public static List<File> getFilesByPlugin(File containingFolder, String pluginName) {
        ArrayList<File> files = new ArrayList<File>();
        for (File file : containingFolder.listFiles()) {
            YamlConfiguration config;
            block3: {
                if (!file.isFile() || !file.getName().toLowerCase(Locale.ENGLISH).endsWith(".jar")) continue;
                config = null;
                try {
                    config = ReflectionManager.getPluginYAMLEx(file);
                }
                catch (Throwable ex) {
                    if (!DisguiseConfig.isVerboseLogging()) break block3;
                    ex.printStackTrace();
                }
            }
            if (config == null || !pluginName.equalsIgnoreCase(config.getString("name"))) continue;
            files.add(file);
        }
        return files;
    }

    public static YamlConfiguration getPluginYAML(File file) {
        try {
            return ReflectionManager.getPluginYAMLEx(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static YamlConfiguration getPluginYAMLEx(File file) throws Exception {
        String s = ReflectionManager.getResourceAsString(file, "plugin.yml");
        if (s == null) {
            return null;
        }
        YamlConfiguration config = new YamlConfiguration();
        config.loadFromString(ReflectionManager.getResourceAsString(file, "plugin.yml"));
        return config;
    }

    public static int getNewEntityId() {
        return ReflectionManager.getNewEntityId(true);
    }

    public static int getNewEntityId(boolean increment) {
        return ReflectionManager.getNmsReflection().getNewEntityId(increment);
    }

    public static WrapperPlayServerEntityMetadata getMetadataPacket(int entityId, List<WatcherValue> values) {
        ArrayList entityData = new ArrayList();
        values.forEach(v -> entityData.add(v.getDataValue()));
        return new WrapperPlayServerEntityMetadata(entityId, entityData);
    }

    public static Object getPlayerConnectionOrPlayer(Player player) {
        return ReflectionManager.getNmsReflection().getPlayerConnectionOrPlayer(player);
    }

    public static FakeBoundingBox getBoundingBox(Entity entity) {
        double[] boundingBox = ReflectionManager.getNmsReflection().getBoundingBox(entity);
        return new FakeBoundingBox(boundingBox[0], boundingBox[1], boundingBox[2]);
    }

    public static Object getPlayerFromPlayerConnection(Object nmsEntity) {
        return ReflectionManager.getNmsReflection().getPlayerFromPlayerConnection(nmsEntity);
    }

    public static Entity getBukkitEntity(Object nmsEntity) {
        return ReflectionManager.getNmsReflection().getBukkitEntity(nmsEntity);
    }

    public static ItemStack getBukkitItem(Object nmsItem) {
        return ReflectionManager.getNmsReflection().getBukkitItem(nmsItem);
    }

    public static boolean isCraftItem(ItemStack bukkitItem) {
        return bukkitItem.getClass().getName().contains(".craftbukkit.");
    }

    public static ItemStack getCraftItem(ItemStack bukkitItem) {
        return ReflectionManager.getNmsReflection().getCraftItem(bukkitItem);
    }

    public static NmsVersion getVersion() {
        if (craftbukkitVersion == null) {
            if (Bukkit.getServer() == null) {
                version = NmsVersion.values()[NmsVersion.values().length - 1];
            } else {
                ReflectionManager.getCraftBukkitPackage();
            }
        }
        return version;
    }

    public static String getMinecraftVersion() {
        if (minecraftVersion == null) {
            Matcher matcher = Pattern.compile(" \\(MC: ([^)]+?)\\)").matcher(Bukkit.getVersion());
            if (!matcher.find()) {
                throw new IllegalStateException("Lib's Disguises is unable to find and parse a ` (MC: 1.10.1)` version in Bukkit.getVersion()");
            }
            minecraftVersion = matcher.group(1);
            try {
                Class<?> c = Class.forName(new String(Base64.getDecoder().decode("bWUubGlicmFyeWFkZGljdC5kaXNndWlzZS51dGlsaXRpZXMuTGlic1ByZW1pdW0="), StandardCharsets.UTF_8));
                Field f = c.getDeclaredField("t1hi2sP3lug4in5IsP6ai7dF8o9r".replaceAll("\\d", ""));
                f.setAccessible(true);
                Boolean b1 = (Boolean)f.get(null);
                if (b1 != null && b1.booleanValue()) {
                    runningPaper = false;
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        return minecraftVersion;
    }

    @Deprecated
    public static String getNmsPackage() {
        String[] spl;
        if (craftbukkitVersion == null) {
            ReflectionManager.getCraftBukkitPackage();
        }
        if ((spl = craftbukkitVersion.split("\\.")).length != 4) {
            return "";
        }
        return spl[3];
    }

    public static String getCraftBukkitPackage() {
        if (craftbukkitVersion == null) {
            craftbukkitVersion = Bukkit.getServer().getClass().getPackage().getName();
            String mcVersion = ReflectionManager.getMinecraftVersion();
            for (NmsVersion v : NmsVersion.values()) {
                if (!v.isMinecraftVersion(mcVersion)) continue;
                version = v;
            }
        }
        return craftbukkitVersion;
    }

    public static Class<?> getCraftClass(String className) {
        try {
            return Class.forName(ReflectionManager.getLocation("org.bukkit.craftbukkit", className));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ReflectionManagerAbstract getReflectionManager(NmsVersion nmsVersion) {
        try {
            String versionName = nmsVersion.name();
            if (nmsVersion == NmsVersion.v1_18) {
                versionName = Bukkit.getVersion().contains("1.18.1") ? versionName + "_1" : versionName + "_2";
            }
            Class<?> aClass = Class.forName("me.libraryaddict.disguise.utilities.reflection." + versionName + ".ReflectionManager");
            Object o = aClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            return (ReflectionManagerAbstract)o;
        }
        catch (ClassNotFoundException ex) {
            try {
                return new LegacyReflectionManager();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to load legacy reflection manager", e);
            }
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Constructor getCraftConstructor(Class clazz, Class<?> ... parameters) {
        try {
            Constructor declaredConstructor = clazz.getDeclaredConstructor(parameters);
            declaredConstructor.setAccessible(true);
            return declaredConstructor;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Constructor getCraftConstructor(String className, Class<?> ... parameters) {
        return ReflectionManager.getCraftConstructor(ReflectionManager.getCraftClass(className), parameters);
    }

    public static Object getEntityTracker(Entity target) throws Exception {
        return ReflectionManager.getNmsReflection().getEntityTracker(target);
    }

    public static Object getEntityTrackerEntry(Entity target, Object entityTracker) throws Exception {
        return ReflectionManager.getNmsReflection().getEntityTrackerEntry(target, entityTracker);
    }

    @Deprecated
    public static Object getEntityTrackerEntry(Entity target) throws Exception {
        return ReflectionManager.getEntityTrackerEntry(target, ReflectionManager.getEntityTracker(target));
    }

    public static Object getMinecraftServer() {
        return ReflectionManager.getNmsReflection().getMinecraftServer();
    }

    public static GameProfile convertProfile(UserProfile profile) {
        GameProfile gProfile = new GameProfile(profile.getUUID(), profile.getName());
        List textures = profile.getTextureProperties();
        for (TextureProperty property : textures) {
            gProfile.getProperties().put((Object)property.getName(), (Object)new Property(property.getName(), property.getValue(), property.getSignature()));
        }
        return gProfile;
    }

    public static PlayerProfile createProfile(UserProfile profile) {
        try {
            return (PlayerProfile)ReflectionManager.getCraftConstructor("CraftGameProfile", GameProfile.class).newInstance(ReflectionManager.convertProfile(profile));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static GameProfile getGameProfile(Player player) {
        return ReflectionManager.getNmsReflection().getProfile(player);
    }

    public static UserProfile getUserProfile(Player player) {
        return ReflectionManager.getUserProfile(ReflectionManager.getGameProfile(player));
    }

    public static UserProfile getUserProfile(GameProfile userProfile) {
        UserProfile uProfile = new UserProfile(userProfile.getId(), userProfile.getName());
        Collection textures = userProfile.getProperties().get((Object)"textures");
        if (textures == null || textures.isEmpty()) {
            return uProfile;
        }
        ArrayList<TextureProperty> properties = new ArrayList<TextureProperty>();
        try {
            for (Property property : textures) {
                String sig;
                String value;
                String name;
                if (propertyName != null) {
                    name = (String)propertyName.invoke((Object)property, new Object[0]);
                    value = (String)propertyValue.invoke((Object)property, new Object[0]);
                    sig = (String)propertySignature.invoke((Object)property, new Object[0]);
                } else {
                    name = property.name();
                    value = property.value();
                    sig = property.signature();
                }
                properties.add(new TextureProperty(name, value, sig));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        uProfile.setTextureProperties(properties);
        return uProfile;
    }

    public static UserProfile getUserProfile(UUID uuid, String playerName) {
        return ReflectionManagerAbstract.getUserProfile((UUID)(uuid == null ? ReflectionManager.getRandomUUID() : uuid), (String)playerName);
    }

    public static UserProfile getClonedProfile(UserProfile userProfile) {
        return ReflectionManager.getUserProfileWithThisSkin(null, userProfile.getName(), userProfile);
    }

    public static UserProfile getUserProfileWithThisSkin(UUID uuid, String playerName, UserProfile profileWithSkin) {
        try {
            UserProfile userProfile = new UserProfile(uuid != null ? uuid : ReflectionManager.getRandomUUID(), playerName == null || playerName.length() < 17 ? playerName : playerName.substring(0, 16));
            if (profileWithSkin != null) {
                userProfile.setTextureProperties(profileWithSkin.getTextureProperties());
            }
            return userProfile;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static UUID getRandomUUID() {
        UUID uuid = UUID.randomUUID();
        if (DisguiseConfig.getUUIDGeneratedVersion() == 4) {
            return uuid;
        }
        return new UUID(uuid.getMostSignificantBits() & 0xFFFFFFFFFFFFBFFFL | (long)DisguiseConfig.getUUIDGeneratedVersion() << 12, uuid.getLeastSignificantBits());
    }

    private static String getLocation(String pack, String className) {
        return ClassMappings.getClass(pack, className);
    }

    public static Class getNmsClass(String className) {
        try {
            return Class.forName(ReflectionManager.getLocation("net.minecraft", className));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Class getNmsClassIgnoreErrors(String className) {
        try {
            return Class.forName(ReflectionManager.getLocation("net.minecraft", className));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Constructor getNmsConstructor(Class clazz, Class<?> ... parameters) {
        try {
            Constructor declaredConstructor = clazz.getDeclaredConstructor(parameters);
            declaredConstructor.setAccessible(true);
            return declaredConstructor;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Constructor getNmsConstructor(String className, Class<?> ... parameters) {
        return ReflectionManager.getNmsConstructor(ReflectionManager.getNmsClass(className), parameters);
    }

    public static Object getNmsEntity(Entity entity) {
        return ReflectionManager.getNmsReflection().getNmsEntity(entity);
    }

    public static Field getNmsField(Class clazz, String fieldName) {
        try {
            Field declaredField = clazz.getDeclaredField(fieldName);
            declaredField.setAccessible(true);
            return declaredField;
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Field getNmsField(String className, String fieldName) {
        return ReflectionManager.getNmsField(ReflectionManager.getNmsClass(className), fieldName);
    }

    public static Set getClonedTrackedPlayers(Object entityTracker, Object entityTrackerEntry) {
        return (Set)new HashSet(ReflectionManager.getTrackedPlayers(entityTracker, entityTrackerEntry)).clone();
    }

    public static Set getTrackedPlayers(Object entityTracker, Object entityTrackerEntry) {
        return ReflectionManager.getNmsReflection().getTrackedEntities(NmsVersion.v1_17.isSupported() ? entityTracker : entityTrackerEntry);
    }

    public static void clearEntityTracker(Object entityTracker, Object trackerEntry, Object player) {
        ReflectionManager.getNmsReflection().clearEntityTracker(NmsVersion.v1_14.isSupported() ? entityTracker : trackerEntry, player);
    }

    public static void addEntityTracker(Object entityTracker, Object trackerEntry, Object player) {
        ReflectionManager.getNmsReflection().addEntityTracker(NmsVersion.v1_14.isSupported() ? entityTracker : trackerEntry, player);
    }

    public static void addEntityToTrackedMap(Object entityTracker, Object entityTrackerEntry, Player player) {
        Object nmsEntity = ReflectionManager.getPlayerConnectionOrPlayer(player);
        if (!ReflectionManager.isRunningPaper() || NmsVersion.v1_17.isSupported()) {
            ReflectionManager.getTrackedPlayers(entityTracker, entityTrackerEntry).add(nmsEntity);
        } else {
            Map map = (Map)trackedPlayersMap.get(entityTrackerEntry);
            map.put(nmsEntity, true);
        }
    }

    public static void removeEntityFromTracked(Object entityTracker, Object entityTrackerEntry, Player player) {
        Object nmsEntity = ReflectionManager.getPlayerConnectionOrPlayer(player);
        if (!ReflectionManager.isRunningPaper() || NmsVersion.v1_17.isSupported()) {
            ReflectionManager.getTrackedPlayers(entityTracker, entityTrackerEntry).remove(nmsEntity);
        } else {
            Map map = (Map)trackedPlayersMap.get(entityTrackerEntry);
            map.remove(nmsEntity);
        }
    }

    public static Method getCraftMethod(String className, String methodName, Class<?> ... parameters) {
        return ReflectionManager.getCraftMethod(ReflectionManager.getCraftClass(className), methodName, parameters);
    }

    public static Method getCraftMethod(Class<?> clazz, String methodName, Class<?> ... parameters) {
        try {
            Method declaredMethod = clazz.getDeclaredMethod(methodName, parameters);
            declaredMethod.setAccessible(true);
            return declaredMethod;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method getNmsMethod(Class<?> clazz, String methodName, Class<?> ... parameters) {
        try {
            Method declaredMethod = clazz.getDeclaredMethod(methodName, parameters);
            declaredMethod.setAccessible(true);
            return declaredMethod;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method getNmsMethod(String className, String methodName, Class<?> ... parameters) {
        return ReflectionManager.getNmsMethod(ReflectionManager.getNmsClass(className), methodName, parameters);
    }

    public static double getPing(Player player) {
        return ReflectionManager.getNmsReflection().getPing(player);
    }

    public static float[] getSize(Entity entity) {
        return ReflectionManager.getNmsReflection().getSize(entity);
    }

    public static UserProfile getSkullBlob(UserProfile userProfile) {
        try {
            if (fillProfileProperties == null) {
                ProfileResult result = sessionService.fetchProfile(userProfile.getUUID(), true);
                if (result == null) {
                    return null;
                }
                return ReflectionManager.getUserProfile(result.profile());
            }
            GameProfile gameProfile = new GameProfile(userProfile.getUUID(), userProfile.getName());
            return ReflectionManager.getUserProfile((GameProfile)fillProfileProperties.invoke((Object)sessionService, gameProfile, true));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Float getSoundModifier(Object entity) {
        return ReflectionManager.getNmsReflection().getSoundModifier(entity);
    }

    public static UserProfile grabProfileAddUUID(String playername) {
        try {
            UserProfile result = null;
            if (!"".equals(workingBackend)) {
                AtomicInteger responseCode = new AtomicInteger(-1);
                for (String backend : new String[]{"https://api.minecraftservices.com/minecraft/profile/lookup/name/%s", "https://api.mojang.com/users/profiles/minecraft/%s"}) {
                    if (workingBackend == null) {
                        LibsDisguises.getInstance().getLogger().info("Trying to resolve a working backend for fetching names... You may see an error pop in console. This should only happen 1-2 times per startup");
                    } else if (!backend.equals(workingBackend)) continue;
                    result = SkinUtils.getUUID(backend, playername, responseCode);
                    if (responseCode.get() == 403) continue;
                    workingBackend = backend;
                    break;
                }
                if (responseCode.get() == 403 && result == null) {
                    workingBackend = "";
                }
            }
            if ("".equals(workingBackend) && result == null) {
                LibsProfileLookupCaller callback = new LibsProfileLookupCaller();
                ReflectionManager.getNmsReflection().injectCallback(playername, (ProfileLookupCallback)callback);
                result = callback.getUserProfile();
            }
            if (result == null) {
                result = ReflectionManager.getUserProfile(null, playername);
            }
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void setBoundingBox(Entity entity, FakeBoundingBox newBox, double scale) {
        double x = newBox.getX();
        double y = newBox.getY();
        double z = newBox.getZ();
        if (NmsVersion.v1_20_R4.isSupported()) {
            x *= scale;
            y *= scale;
            z *= scale;
        }
        ReflectionManager.getNmsReflection().setBoundingBox(entity, x, y, z);
    }

    public static SoundCategory getSoundCategory(DisguiseType disguiseType) {
        if (disguiseType == DisguiseType.PLAYER) {
            return SoundCategory.PLAYER;
        }
        Class entityClass = disguiseType.getEntityType().getEntityClass();
        if (Monster.class.isAssignableFrom(entityClass)) {
            return SoundCategory.HOSTILE;
        }
        if (Ambient.class.isAssignableFrom(entityClass)) {
            return SoundCategory.AMBIENT;
        }
        return SoundCategory.NEUTRAL;
    }

    public static String getSoundString(Sound sound) {
        return ReflectionManager.getNmsReflection().getSoundString(sound);
    }

    public static <T> T convertMetaFromSerialized(MetaIndex<T> index, Object value) {
        if (index == MetaIndex.BOAT_TYPE_OLD) {
            return (T)TreeSpecies.getByData((byte)((byte)((Integer)value).intValue()));
        }
        if (index == MetaIndex.CAT_TYPE) {
            if (value instanceof CatVariant) {
                value = ((CatVariant)value).getId(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion());
            }
            return (T)ReflectionManager.getNmsReflection().getTypeFromInt(Cat.Type.class, ((Integer)value).intValue());
        }
        if (index == MetaIndex.FROG_VARIANT) {
            if (value instanceof FrogVariant) {
                value = ((FrogVariant)value).getId(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion());
            }
            return (T)ReflectionManager.getNmsReflection().getTypeFromInt(Frog.Variant.class, ((Integer)value).intValue());
        }
        if (index == MetaIndex.PAINTING) {
            return (T)ReflectionManager.getNmsReflection().getTypeFromInt(Art.class, ((PaintingVariant)value).getId(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion()));
        }
        if (index == MetaIndex.WOLF_VARIANT) {
            return (T)ReflectionManager.getNmsReflection().getTypeFromInt(Wolf.Variant.class, ((WolfVariant)value).getId(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion()));
        }
        if (index == MetaIndex.CHICKEN_VARIANT) {
            return (T)ReflectionManager.getNmsReflection().getTypeFromInt(Chicken.Variant.class, ((ChickenVariant)value).getId(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion()));
        }
        if (index == MetaIndex.PIG_VARIANT) {
            return (T)ReflectionManager.getNmsReflection().getTypeFromInt(Pig.Variant.class, ((PigVariant)value).getId(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion()));
        }
        if (index == MetaIndex.MUSHROOM_COW_TYPE) {
            if (!NmsVersion.v1_21_R4.isSupported()) {
                return (T)ReflectionManager.fromEnum(MushroomCow.Variant.class, (String)value);
            }
            return (T)ReflectionManager.fromEnum(MushroomCow.Variant.class, (Integer)value);
        }
        if (index == MetaIndex.COW_VARIANT) {
            return (T)ReflectionManager.getNmsReflection().getTypeFromInt(Cow.Variant.class, ((CowVariant)value).getId(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion()));
        }
        if (index == MetaIndex.SALMON_VARIANT) {
            if (NmsVersion.v1_21_R3.isSupported()) {
                return (T)Salmon.Variant.values()[(Integer)value];
            }
            return (T)Salmon.Variant.valueOf((String)((String)value).toUpperCase(Locale.ENGLISH));
        }
        if (index == MetaIndex.CAT_COLLAR || index == MetaIndex.WOLF_COLLAR) {
            return (T)((Object)AnimalColor.getColorByWool((Integer)value));
        }
        if (index.isItemStack()) {
            return (T)DisguiseUtilities.toBukkitItemStack((com.github.retrooper.packetevents.protocol.item.ItemStack)value);
        }
        if (index.isBlock() || index.isBlockOpt()) {
            return (T)ReflectionManager.getWrappedBlockStateByCombinedId((Integer)value);
        }
        if (index == MetaIndex.AREA_EFFECT_CLOUD_COLOR) {
            return (T)Color.fromRGB((int)((Integer)value));
        }
        if (index == MetaIndex.PARROT_VARIANT) {
            return (T)ReflectionManager.fromEnum(Parrot.Variant.class, (Integer)value);
        }
        if (index == MetaIndex.AXOLOTL_VARIANT) {
            return (T)ReflectionManager.fromEnum(Axolotl.Variant.class, (Integer)value);
        }
        if (index == MetaIndex.OCELOT_TYPE) {
            return (T)ReflectionManager.fromEnum(Ocelot.Type.class, (Integer)value);
        }
        if (index == MetaIndex.FOX_TYPE) {
            return (T)ReflectionManager.fromEnum(Fox.Type.class, (Integer)value);
        }
        if (index == MetaIndex.RABBIT_TYPE) {
            return (T)RabbitType.getType((Integer)value);
        }
        if (index == MetaIndex.LLAMA_COLOR) {
            return (T)ReflectionManager.fromEnum(Llama.Color.class, (Integer)value);
        }
        if (index == MetaIndex.PANDA_MAIN_GENE || index == MetaIndex.PANDA_HIDDEN_GENE) {
            return (T)ReflectionManager.fromEnum(Panda.Gene.class, ((Byte)value).byteValue());
        }
        if (index == MetaIndex.ITEM_DISPLAY_TRANSFORM) {
            return (T)ReflectionManager.fromEnum(ItemDisplay.ItemDisplayTransform.class, ((Byte)value).byteValue());
        }
        if (index == MetaIndex.BOAT_TYPE_NEW) {
            return (T)ReflectionManager.fromEnum(Boat.Type.class, (Integer)value);
        }
        return (T)value;
    }

    public static Object convertMetaToSerialized(MetaIndex index, Object value) {
        return ReflectionManager.convertMetaToSerialized(GlobalRegistryHolder.INSTANCE, index, value);
    }

    public static Object convertMetaToSerialized(IRegistryHolder registryHolder, MetaIndex index, Object value) {
        if (value instanceof Optional) {
            if (!((Optional)value).isPresent()) {
                if (index.getDataType() == EntityDataTypes.OPTIONAL_BLOCK_STATE) {
                    return 0;
                }
                return value;
            }
            Object dVal = ((Optional)value).get();
            if (dVal instanceof WrappedBlockState) {
                value = dVal;
            }
        }
        if (value instanceof WrappedBlockState) {
            return ReflectionManager.getCombinedIdByWrappedBlockState((WrappedBlockState)value);
        }
        if (NmsVersion.v1_14.isSupported()) {
            if (value instanceof Cat.Type) {
                int asInt = ReflectionManager.getNmsReflection().getIntFromType(value);
                if (index.getDataType() != EntityDataTypes.TYPED_CAT_VARIANT) {
                    return asInt;
                }
                return registryHolder.getRegistryOr((IRegistry)CatVariants.getRegistry()).getById(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion(), asInt);
            }
            if (value instanceof MushroomCow.Variant) {
                if (NmsVersion.v1_21_R4.isSupported()) {
                    return ReflectionManager.enumOrdinal(value);
                }
                return ((Enum)value).name().toLowerCase(Locale.ENGLISH);
            }
            if (NmsVersion.v1_19_R1.isSupported()) {
                if (value instanceof Frog.Variant) {
                    int asInt = ReflectionManager.getNmsReflection().getIntFromType(value);
                    if (index.getDataType() != EntityDataTypes.TYPED_FROG_VARIANT) {
                        return asInt;
                    }
                    return registryHolder.getRegistryOr((IRegistry)FrogVariants.getRegistry()).getById(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion(), asInt);
                }
                if (value instanceof Art) {
                    return registryHolder.getRegistryOr((IRegistry)PaintingVariants.getRegistry()).getById(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion(), ReflectionManager.getNmsReflection().getIntFromType(value));
                }
                if (value instanceof Boat.Type) {
                    return ReflectionManager.enumOrdinal(value);
                }
                if (NmsVersion.v1_20_R4.isSupported()) {
                    if (value instanceof Wolf.Variant) {
                        return registryHolder.getRegistryOr((IRegistry)WolfVariants.getRegistry()).getById(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion(), ReflectionManager.getNmsReflection().getIntFromType(value));
                    }
                    if (NmsVersion.v1_21_R2.isSupported()) {
                        if (value instanceof Salmon.Variant) {
                            if (NmsVersion.v1_21_R3.isSupported()) {
                                return ((Salmon.Variant)value).ordinal();
                            }
                            return ((Salmon.Variant)value).name().toLowerCase(Locale.ENGLISH);
                        }
                        if (NmsVersion.v1_21_R4.isSupported()) {
                            if (value instanceof Cow.Variant) {
                                return registryHolder.getRegistryOr((IRegistry)CowVariants.getRegistry()).getById(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion(), ReflectionManager.getNmsReflection().getIntFromType(value));
                            }
                            if (value instanceof Chicken.Variant) {
                                return registryHolder.getRegistryOr((IRegistry)ChickenVariants.getRegistry()).getById(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion(), ReflectionManager.getNmsReflection().getIntFromType(value));
                            }
                            if (value instanceof Pig.Variant) {
                                return registryHolder.getRegistryOr((IRegistry)PigVariants.getRegistry()).getById(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion(), ReflectionManager.getNmsReflection().getIntFromType(value));
                            }
                        }
                    }
                }
            }
        }
        if (value instanceof Color) {
            return ((Color)value).asRGB();
        }
        if (value instanceof TreeSpecies) {
            return (int)((TreeSpecies)value).getData();
        }
        if (value instanceof ItemStack) {
            return DisguiseUtilities.fromBukkitItemStack((ItemStack)value);
        }
        if (value instanceof Rabbit.Type) {
            return RabbitType.getTypeId((Rabbit.Type)value);
        }
        if (index == MetaIndex.CAT_COLLAR || index == MetaIndex.WOLF_COLLAR) {
            return (int)((AnimalColor)((Object)value)).getDyeColor().getWoolData();
        }
        if (!(!(value instanceof Enum) || value instanceof SnifferState || value instanceof EntityPose || value instanceof BlockFace || value instanceof ArmadilloState)) {
            int v = ReflectionManager.enumOrdinal(value);
            if (index.isByteValues()) {
                return (byte)v;
            }
            return v;
        }
        return value;
    }

    public static Material getMaterial(String name) {
        return ReflectionManager.getNmsReflection().getMaterial(name);
    }

    public static String getItemName(Material material) {
        return ReflectionManager.getNmsReflection().getItemName(material);
    }

    public static boolean isAssignableFrom(Class baseAbstractClass, Class extendingClass) {
        if (!NmsVersion.v1_14.isSupported() && extendingClass != baseAbstractClass && extendingClass == OcelotWatcher.class) {
            extendingClass = TameableWatcher.class;
        }
        if (!NmsVersion.v1_21_R2.isSupported() && extendingClass != baseAbstractClass && AgeableAquaWatcher.class.isAssignableFrom(extendingClass) && baseAbstractClass.isAssignableFrom(AgeableWatcher.class)) {
            extendingClass = InsentientWatcher.class;
        }
        return baseAbstractClass.isAssignableFrom(extendingClass);
    }

    public static Class getSuperClass(Class cl) {
        if (cl == FlagWatcher.class) {
            return null;
        }
        if (!NmsVersion.v1_14.isSupported() && cl == OcelotWatcher.class) {
            return TameableWatcher.class;
        }
        if (!NmsVersion.v1_21_R2.isSupported() && cl == AgeableAquaWatcher.class) {
            return InsentientWatcher.class;
        }
        return cl.getSuperclass();
    }

    public static Object createMinecraftKey(String name) {
        return ReflectionManager.getNmsReflection().createMinecraftKey(name);
    }

    public static Object getEntityType(EntityType entityType) {
        return ReflectionManager.getNmsReflection().getEntityType(entityType);
    }

    public static Object registerEntityType(NamespacedKey key) {
        return ReflectionManager.getNmsReflection().registerEntityType(key);
    }

    public static int getEntityTypeId(Object entityTypes) {
        return ReflectionManager.getNmsReflection().getEntityTypeId(entityTypes);
    }

    public static int getEntityTypeId(EntityType entityType) {
        return ReflectionManager.getNmsReflection().getEntityTypeId(entityType);
    }

    public static Object getEntityType(NamespacedKey name) {
        return ReflectionManager.getNmsReflection().getEntityType(name);
    }

    public static EntityData getEntityData(MetaIndex index, Object obj, boolean bukkitReadable) {
        return new EntityData(index.getIndex(), index.getDataType(), bukkitReadable ? ReflectionManager.convertMetaToSerialized(index, obj) : obj);
    }

    public static int getCombinedIdByBlockData(BlockData data) {
        return ReflectionManager.getNmsReflection().getCombinedIdByBlockData(data);
    }

    public static int getCombinedIdByWrappedBlockState(WrappedBlockState state) {
        if (NmsVersion.v1_13.isSupported()) {
            return state.getGlobalId();
        }
        return state.getType().getMapped().getId(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion());
    }

    public static WrappedBlockState getWrappedBlockStateByCombinedId(int combinedId) {
        if (NmsVersion.v1_13.isSupported()) {
            return WrappedBlockState.getByGlobalId((int)combinedId);
        }
        return StateTypes.getById((ClientVersion)PacketEvents.getAPI().getServerManager().getVersion().toClientVersion(), (int)combinedId).createBlockState(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion());
    }

    public static int getCombinedIdByItemStack(ItemStack itemStack) {
        return ReflectionManager.getNmsReflection().getCombinedIdByItemStack(itemStack);
    }

    public static BlockData getBlockDataByCombinedId(int id) {
        return ReflectionManager.getNmsReflection().getBlockDataByCombinedId(id);
    }

    public static ItemStack getItemStackByCombinedId(int id) {
        return ReflectionManager.getNmsReflection().getItemStackByCombinedId(id);
    }

    public static Object getWorldServer(World w) {
        return ReflectionManager.getNmsReflection().getWorldServer(w);
    }

    public static ItemMeta getDeserializedItemMeta(Map<String, Object> meta) {
        return ReflectionManager.getNmsReflection().getDeserializedItemMeta(meta);
    }

    private static Class<? extends FlagWatcher> getFlagWatcher(DisguiseType disguiseType) {
        Class watcherClass;
        try {
            switch (disguiseType) {
                case MARKER: {
                    watcherClass = FlagWatcher.class;
                    break;
                }
                case GLOW_ITEM_FRAME: {
                    watcherClass = ItemFrameWatcher.class;
                    break;
                }
                case ARROW: {
                    watcherClass = TippedArrowWatcher.class;
                    break;
                }
                case MODDED_LIVING: 
                case MODDED_MISC: {
                    watcherClass = ModdedWatcher.class;
                    break;
                }
                case COD: {
                    watcherClass = FishWatcher.class;
                    break;
                }
                case SPECTRAL_ARROW: {
                    watcherClass = ArrowWatcher.class;
                    break;
                }
                case PRIMED_TNT: {
                    watcherClass = TNTWatcher.class;
                    break;
                }
                case MINECART_MOB_SPAWNER: {
                    watcherClass = MinecartSpawnerWatcher.class;
                    break;
                }
                case MINECART_TNT: {
                    watcherClass = MinecartTntWatcher.class;
                    break;
                }
                case MINECART_CHEST: 
                case MINECART_HOPPER: {
                    watcherClass = MinecartWatcher.class;
                    break;
                }
                case CAVE_SPIDER: {
                    watcherClass = SpiderWatcher.class;
                    break;
                }
                case PIG_ZOMBIE: 
                case HUSK: 
                case DROWNED: 
                case ZOMBIFIED_PIGLIN: {
                    watcherClass = ZombieWatcher.class;
                    break;
                }
                case MAGMA_CUBE: {
                    watcherClass = SlimeWatcher.class;
                    break;
                }
                case ELDER_GUARDIAN: {
                    watcherClass = GuardianWatcher.class;
                    break;
                }
                case ILLUSIONER: 
                case EVOKER: {
                    watcherClass = IllagerWizardWatcher.class;
                    break;
                }
                case PUFFERFISH: {
                    watcherClass = PufferFishWatcher.class;
                    break;
                }
                case ACACIA_CHEST_BOAT: 
                case BAMBOO_CHEST_RAFT: 
                case BIRCH_CHEST_BOAT: 
                case CHERRY_CHEST_BOAT: 
                case DARK_OAK_CHEST_BOAT: 
                case JUNGLE_CHEST_BOAT: 
                case MANGROVE_CHEST_BOAT: 
                case OAK_CHEST_BOAT: 
                case PALE_OAK_CHEST_BOAT: 
                case SPRUCE_CHEST_BOAT: {
                    watcherClass = ChestBoatWatcher.class;
                    break;
                }
                case ACACIA_BOAT: 
                case BAMBOO_RAFT: 
                case BIRCH_BOAT: 
                case CHERRY_BOAT: 
                case DARK_OAK_BOAT: 
                case JUNGLE_BOAT: 
                case MANGROVE_BOAT: 
                case OAK_BOAT: 
                case PALE_OAK_BOAT: 
                case SPRUCE_BOAT: {
                    watcherClass = BoatWatcher.class;
                    break;
                }
                case LINGERING_POTION: {
                    watcherClass = SplashPotionWatcher.class;
                    break;
                }
                default: {
                    watcherClass = Class.forName("me.libraryaddict.disguise.disguisetypes.watchers." + ReflectionManager.toReadable(disguiseType.name()) + "Watcher");
                    break;
                }
            }
        }
        catch (ClassNotFoundException ex) {
            Class entityClass = disguiseType.getEntityType().getEntityClass();
            if (entityClass != null) {
                watcherClass = Tameable.class.isAssignableFrom(entityClass) ? TameableWatcher.class : (Ageable.class.isAssignableFrom(entityClass) ? AgeableWatcher.class : (Creature.class.isAssignableFrom(entityClass) ? InsentientWatcher.class : (LivingEntity.class.isAssignableFrom(entityClass) ? LivingWatcher.class : (Fish.class.isAssignableFrom(entityClass) ? FishWatcher.class : FlagWatcher.class))));
            }
            watcherClass = FlagWatcher.class;
        }
        return watcherClass;
    }

    public static void registerValues() {
        int maxErrorsThrown = 5;
        for (DisguiseType disguiseType : DisguiseType.values()) {
            try {
                if (disguiseType.getEntityType() == null) continue;
                Class<? extends FlagWatcher> watcherClass = ReflectionManager.getFlagWatcher(disguiseType);
                if (watcherClass == null) {
                    LibsDisguises.getInstance().getLogger().severe("Error loading " + disguiseType.name() + ", FlagWatcher not assigned");
                    continue;
                }
                if (LibsPremium.isPremium().booleanValue() && (LibsPremium.getPaidInformation() != null && LibsPremium.getPaidInformation().isPremium() && !LibsPremium.getPaidInformation().isPaid() || LibsPremium.getPluginInformation() != null && LibsPremium.getPluginInformation().isPremium() && !LibsPremium.getPluginInformation().isPaid())) {
                    throw new IllegalStateException("Error while checking pi rate on startup! Please re-download the jar from SpigotMC before reporting this error!");
                }
                disguiseType.setWatcherClass(watcherClass);
                if (LibsDisguises.getInstance() == null || DisguiseValues.getDisguiseValues(disguiseType) != null) continue;
                ReflectionManager.createNMSValues(disguiseType);
            }
            catch (Throwable throwable) {
                if (maxErrorsThrown-- <= 0) {
                    throw throwable;
                }
                throwable.printStackTrace();
            }
        }
    }

    public static byte[] readFuzzyFully(InputStream input) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        while ((bytesRead = input.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
        }
        return output.toByteArray();
    }

    private static void createNMSValues(DisguiseType disguiseType) {
        String nmsEntityName;
        if (disguiseType == DisguiseType.UNKNOWN || disguiseType.isCustom()) {
            DisguiseValues disguiseValues = new DisguiseValues(disguiseType, 0.0, 0);
            disguiseValues.setAdultBox(new FakeBoundingBox(0.0, 0.0, 0.0));
            for (SoundGroup group : SoundGroup.getGroups(disguiseType.name())) {
                group.setDamageAndIdleSoundVolume(1.0f);
            }
            return;
        }
        if (NmsVersion.v1_17.isSupported()) {
            nmsEntityName = disguiseType.getEntityType().getKey().getKey();
        } else {
            nmsEntityName = ReflectionManager.toReadable(disguiseType.name());
            Class nmsClass = ReflectionManager.getNmsClassIgnoreErrors("Entity" + nmsEntityName);
            if (nmsClass == null || Modifier.isAbstract(nmsClass.getModifiers())) {
                Object[] split = ReflectionManager.splitReadable(disguiseType.name());
                ArrayUtils.reverse((Object[])split);
                nmsEntityName = StringUtils.join((Object[])split);
                nmsClass = ReflectionManager.getNmsClassIgnoreErrors("Entity" + nmsEntityName);
                if (nmsClass == null || Modifier.isAbstract(nmsClass.getModifiers())) {
                    nmsEntityName = null;
                }
            }
            if (nmsEntityName == null) {
                switch (disguiseType) {
                    case DONKEY: {
                        nmsEntityName = "HorseDonkey";
                        break;
                    }
                    case ARROW: {
                        nmsEntityName = "TippedArrow";
                        break;
                    }
                    case DROPPED_ITEM: {
                        nmsEntityName = "Item";
                        break;
                    }
                    case FIREBALL: {
                        nmsEntityName = "LargeFireball";
                        break;
                    }
                    case FIREWORK: {
                        nmsEntityName = "Fireworks";
                        break;
                    }
                    case GIANT: {
                        nmsEntityName = "GiantZombie";
                        break;
                    }
                    case HUSK: {
                        nmsEntityName = "ZombieHusk";
                        break;
                    }
                    case ILLUSIONER: {
                        nmsEntityName = "IllagerIllusioner";
                        break;
                    }
                    case LEASH_HITCH: {
                        nmsEntityName = "Leash";
                        break;
                    }
                    case MINECART: {
                        nmsEntityName = "MinecartRideable";
                        break;
                    }
                    case MINECART_COMMAND: {
                        nmsEntityName = "MinecartCommandBlock";
                        break;
                    }
                    case MINECART_TNT: {
                        nmsEntityName = "MinecartTNT";
                        break;
                    }
                    case MULE: {
                        nmsEntityName = "HorseMule";
                        break;
                    }
                    case PRIMED_TNT: {
                        nmsEntityName = "TNTPrimed";
                        break;
                    }
                    case PUFFERFISH: {
                        nmsEntityName = "PufferFish";
                        break;
                    }
                    case SPLASH_POTION: {
                        nmsEntityName = "Potion";
                        break;
                    }
                    case STRAY: {
                        nmsEntityName = "SkeletonStray";
                        break;
                    }
                    case TRADER_LLAMA: {
                        nmsEntityName = "LLamaTrader";
                        break;
                    }
                    case TRIDENT: {
                        nmsEntityName = "ThrownTrident";
                        break;
                    }
                    case WANDERING_TRADER: {
                        nmsEntityName = "VillagerTrader";
                        break;
                    }
                    case ZOMBIFIED_PIGLIN: {
                        nmsEntityName = "PigZombie";
                        break;
                    }
                }
                if (nmsEntityName == null) {
                    LibsDisguises.getInstance().getLogger().warning("Entity name not found! (" + disguiseType.name() + ")");
                    return;
                }
            }
        }
        try {
            Float soundStrength;
            Object nmsEntity = ReflectionManager.getNmsReflection().createEntityInstance(disguiseType.getEntityType(), nmsEntityName);
            if (nmsEntity == null) {
                LibsDisguises.getInstance().getLogger().warning("Entity not found! (" + nmsEntityName + ")");
                return;
            }
            disguiseType.setTypeId(NmsVersion.v1_13.isSupported() ? ReflectionManager.getEntityType(disguiseType.getEntityType()) : null, ReflectionManager.getEntityTypeId(disguiseType.getEntityType()));
            Entity bukkitEntity = ReflectionManager.getBukkitEntity(nmsEntity);
            DisguiseValues disguiseValues = new DisguiseValues(disguiseType, bukkitEntity instanceof Damageable ? ((Damageable)bukkitEntity).getMaxHealth() : 0.0, ReflectionManager.getNmsReflection().getAmbientSoundInterval(bukkitEntity));
            List<EntityData<?>> watcher = ReflectionManager.getEntityWatcher(bukkitEntity);
            ArrayList<MetaIndex> indexes = MetaIndex.getMetaIndexes(disguiseType.getWatcherClass());
            boolean loggedName = false;
            for (EntityData<?> data : watcher) {
                MetaIndex metaIndex = MetaIndex.getMetaIndex(disguiseType.getWatcherClass(), data.getIndex());
                if (metaIndex == null) {
                    LibsDisguises.getInstance().getLogger().severe(StringUtils.repeat((String)"-", (int)20));
                    LibsDisguises.getInstance().getLogger().severe("MetaIndex not found for " + (Object)((Object)disguiseType) + "! Index: " + data.getIndex());
                    LibsDisguises.getInstance().getLogger().severe("Value: " + data.getValue() + " (" + data.getValue().getClass() + ") (" + nmsEntity.getClass() + ") & " + disguiseType.getWatcherClass().getSimpleName());
                    continue;
                }
                indexes.remove(metaIndex);
                Object ourDefaultBukkit = metaIndex.getDefault();
                Object ourDefaultSerialized = ReflectionManager.convertMetaToSerialized(metaIndex, ourDefaultBukkit);
                Object minecraftDefaultBukkit = ReflectionManager.convertMetaFromSerialized(metaIndex, data.getValue());
                Object minecraftDefaultSerialized = data.getValue();
                if (ourDefaultBukkit == null) {
                    ourDefaultBukkit = "ld-bukkit-null";
                }
                if (ourDefaultSerialized == null) {
                    ourDefaultSerialized = "ld-minecraft-null";
                }
                if (minecraftDefaultBukkit == null) {
                    minecraftDefaultBukkit = "mc-bukkit-null";
                }
                if (minecraftDefaultSerialized == null) {
                    minecraftDefaultSerialized = "mc-minecraft-null";
                }
                if (minecraftDefaultBukkit.getClass().getSimpleName().equals("CraftItemStack") && ourDefaultBukkit.getClass().getSimpleName().equals("ItemStack")) {
                    ourDefaultBukkit = ReflectionManager.getCraftItem((ItemStack)ourDefaultBukkit);
                }
                if (ourDefaultBukkit.getClass() == minecraftDefaultBukkit.getClass() && metaIndex.getDataType() == data.getType() && minecraftDefaultSerialized.getClass() == ourDefaultSerialized.getClass()) continue;
                if (!loggedName) {
                    LibsDisguises.getInstance().getLogger().severe(StringUtils.repeat((String)"=", (int)20));
                    LibsDisguises.getInstance().getLogger().severe("MetaIndex mismatch! Disguise " + (Object)((Object)disguiseType) + ", Entity " + nmsEntityName);
                    loggedName = true;
                }
                LibsDisguises.getInstance().getLogger().severe(StringUtils.repeat((String)"-", (int)20));
                LibsDisguises.getInstance().getLogger().severe("Index: " + data.getIndex() + " | " + metaIndex.getFlagWatcher().getSimpleName() + " | " + MetaIndex.getName(metaIndex));
                LibsDisguises.getInstance().getLogger().severe("LibsDisguises Bukkit: " + ourDefaultBukkit + " (" + ourDefaultBukkit.getClass() + ")");
                LibsDisguises.getInstance().getLogger().severe("LibsDisguises Serialized: " + ourDefaultSerialized + " (" + ourDefaultSerialized.getClass() + ")");
                LibsDisguises.getInstance().getLogger().severe("LibsDisguises Data Type: " + metaIndex.getDataType().getName());
                LibsDisguises.getInstance().getLogger().severe("Minecraft Bukkit: " + minecraftDefaultBukkit + " (" + minecraftDefaultBukkit.getClass() + ")");
                LibsDisguises.getInstance().getLogger().severe("Minecraft Serialized: " + minecraftDefaultSerialized + " (" + minecraftDefaultSerialized.getClass() + ")");
                LibsDisguises.getInstance().getLogger().severe("Minecraft Data Type: " + data.getType().getName());
                LibsDisguises.getInstance().getLogger().severe("LibsDisguises Serializer Data Type: " + metaIndex.getDataType().getName());
                LibsDisguises.getInstance().getLogger().severe("Minecraft Serializer Data Type: " + data.getType().getName());
                LibsDisguises.getInstance().getLogger().severe(StringUtils.repeat((String)"-", (int)20));
            }
            for (MetaIndex index : indexes) {
                LibsDisguises.getInstance().getLogger().severe(StringUtils.repeat((String)"-", (int)20));
                LibsDisguises.getInstance().getLogger().severe((Object)((Object)disguiseType) + " has MetaIndex remaining! " + index.getFlagWatcher().getSimpleName() + " at index " + index.getIndex());
            }
            SoundGroup[] groups = SoundGroup.getGroups(disguiseType.name());
            if (groups.length > 0 && (soundStrength = ReflectionManager.getSoundModifier(nmsEntity)) != null) {
                for (SoundGroup sound : groups) {
                    sound.setDamageAndIdleSoundVolume(soundStrength.floatValue());
                }
                if (!LibsDisguises.getInstance().isJenkins() && disguiseType == DisguiseType.COW) {
                    if (soundStrength.floatValue() != 0.4f) {
                        LibsDisguises.getInstance().getLogger().severe("The hurt sound volume may be wrong on the COW disguise! Bad nms update?");
                    } else if (disguiseValues.getAmbientSoundInterval() != 120) {
                        LibsDisguises.getInstance().getLogger().severe("The ambient interval may be wrong on the COW disguise! Bad nms update?");
                    }
                }
            }
            disguiseValues.setAdultBox(ReflectionManager.getBoundingBox(bukkitEntity));
            if (bukkitEntity instanceof Ageable) {
                ((Ageable)bukkitEntity).setBaby();
                disguiseValues.setBabyBox(ReflectionManager.getBoundingBox(bukkitEntity));
            } else if (bukkitEntity instanceof Zombie) {
                ((Zombie)bukkitEntity).setBaby(true);
                disguiseValues.setBabyBox(ReflectionManager.getBoundingBox(bukkitEntity));
            } else if (bukkitEntity instanceof ArmorStand) {
                ((ArmorStand)bukkitEntity).setSmall(true);
                disguiseValues.setBabyBox(ReflectionManager.getBoundingBox(bukkitEntity));
            }
        }
        catch (Exception ex) {
            LibsDisguises.getInstance().getLogger().severe("Uh oh! Trouble while making values for the disguise " + disguiseType.name() + "!");
            LibsDisguises.getInstance().getLogger().severe("Before reporting this error, please make sure you are using the latest version of LibsDisguises and PacketEvents.");
            LibsDisguises.getInstance().getLogger().severe("Development builds are available at (PacketEvents) https://ci.codemc.io/job/retrooper/job/packetevents/ and (LibsDisguises) https://ci.md-5.net/job/LibsDisguises/");
            ex.printStackTrace();
        }
    }

    public static List<EntityData<?>> getEntityWatcher(Entity entity) {
        try {
            ByteBuf buffer = ReflectionManager.getNmsReflection().getDataWatcherValues(entity);
            PacketWrapper wrapper = PacketWrapper.createUniversalPacketWrapper((Object)buffer);
            List list = wrapper.readEntityMetadata();
            ByteBufHelper.release((Object)buffer);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setScore(Scoreboard scoreboard, String name, int score) {
        ReflectionManager.setScore(scoreboard, name, score, true);
    }

    private static void setScore(final Scoreboard scoreboard, final String name, final int score, boolean canScheduleTask) {
        if (canScheduleTask && (!Bukkit.isPrimaryThread() || ReflectionManager.isRunningPaper())) {
            new BukkitRunnable(){

                public void run() {
                    ReflectionManager.setScore(scoreboard, name, score, false);
                }
            }.runTask((Plugin)LibsDisguises.getInstance());
            return;
        }
        ReflectionManager.getNmsReflection().setScore(scoreboard, "health", name, score);
    }

    public static Map<String, Command> getCommands(CommandMap map) {
        try {
            Field field = SimpleCommandMap.class.getDeclaredField("knownCommands");
            field.setAccessible(true);
            return (Map)field.get(map);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static SimpleCommandMap getCommandMap() {
        try {
            Field commandMap = SimplePluginManager.class.getDeclaredField("commandMap");
            commandMap.setAccessible(true);
            return (SimpleCommandMap)commandMap.get(Bukkit.getPluginManager());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static String[] splitReadable(String string) {
        String[] split = string.split("_");
        for (int i = 0; i < split.length; ++i) {
            split[i] = split[i].charAt(0) + split[i].substring(1).toLowerCase(Locale.ENGLISH);
        }
        return split;
    }

    public static String toReadable(String string) {
        return ReflectionManager.toReadable(string, "");
    }

    public static String toReadable(String string, String joiner) {
        return StringUtils.join((Object[])ReflectionManager.splitReadable(string), (String)joiner);
    }

    public static EntityDataType getEntityDataType(MetaIndex index, Field field) {
        try {
            if (index.isBlock()) {
                return EntityDataTypes.BLOCK_STATE;
            }
            if (index.isBlockOpt()) {
                return EntityDataTypes.OPTIONAL_BLOCK_STATE;
            }
            if (index.isItemStack()) {
                return EntityDataTypes.ITEMSTACK;
            }
            if (index == MetaIndex.WOLF_VARIANT) {
                return EntityDataTypes.TYPED_WOLF_VARIANT;
            }
            if (index == MetaIndex.CAT_TYPE && NmsVersion.v1_19_R1.isSupported()) {
                return EntityDataTypes.TYPED_CAT_VARIANT;
            }
            if (index == MetaIndex.FROG_VARIANT) {
                return EntityDataTypes.TYPED_FROG_VARIANT;
            }
            if (index == MetaIndex.PAINTING) {
                return EntityDataTypes.PAINTING_VARIANT;
            }
            if (index == MetaIndex.ENTITY_POSE) {
                return EntityDataTypes.ENTITY_POSE;
            }
            if (index == MetaIndex.SNIFFER_STATE) {
                return EntityDataTypes.SNIFFER_STATE;
            }
            if (index == MetaIndex.ARMADILLO_STATE) {
                return EntityDataTypes.ARMADILLO_STATE;
            }
            if (index.getDefault() instanceof BlockFace) {
                return EntityDataTypes.BLOCK_FACE;
            }
            if (index == MetaIndex.AREA_EFFECT_CLOUD_COLOR) {
                return EntityDataTypes.INT;
            }
            if (index == MetaIndex.CHICKEN_VARIANT) {
                return EntityDataTypes.CHICKEN_VARIANT;
            }
            if (index == MetaIndex.PIG_VARIANT) {
                return EntityDataTypes.PIG_VARIANT;
            }
            if (index == MetaIndex.COW_VARIANT) {
                return EntityDataTypes.COW_VARIANT;
            }
            if (index == MetaIndex.MUSHROOM_COW_TYPE && !NmsVersion.v1_21_R4.isSupported()) {
                return EntityDataTypes.STRING;
            }
            if (index == MetaIndex.SALMON_VARIANT) {
                if (NmsVersion.v1_21_R3.isSupported()) {
                    return EntityDataTypes.INT;
                }
                return EntityDataTypes.STRING;
            }
            Type type1 = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            if (type1 instanceof Class && Enum.class.isAssignableFrom((Class)type1)) {
                if (index.isByteValues()) {
                    return EntityDataTypes.BYTE;
                }
                return EntityDataTypes.INT;
            }
            if (type1 == ItemStack.class) {
                return EntityDataTypes.ITEMSTACK;
            }
            if (type1 == Integer.class) {
                return EntityDataTypes.INT;
            }
            if (type1 == Byte.class) {
                return EntityDataTypes.BYTE;
            }
            if (type1 == Vector3f.class) {
                if (index.isRotation()) {
                    return EntityDataTypes.ROTATION;
                }
                return EntityDataTypes.VECTOR3F;
            }
            if (type1 == String.class) {
                return EntityDataTypes.STRING;
            }
            ArrayList<EntityDataType> found = new ArrayList<EntityDataType>();
            for (Field f : EntityDataTypes.class.getFields()) {
                if (f.getType() != EntityDataType.class || !Modifier.isPublic(f.getModifiers()) || !Modifier.isStatic(f.getModifiers()) || !(f.getGenericType() instanceof ParameterizedType)) continue;
                Type type2 = ((ParameterizedType)f.getGenericType()).getActualTypeArguments()[0];
                if (!type1.toString().equals(type2.toString())) continue;
                found.add((EntityDataType)f.get(null));
            }
            if (found.isEmpty()) {
                throw new IllegalStateException("Unable to find an entity type for " + field.getName() + ". Type is " + type1);
            }
            if (found.size() > 1) {
                for (EntityDataType type : found) {
                    LibsDisguises.getInstance().getLogger().severe("Found multiple entity data type for " + field.getName() + " of type " + type1 + ": " + type.getName());
                }
            }
            return (EntityDataType)found.get(0);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int enumOrdinal(Object obj) {
        return ((Enum)obj).ordinal();
    }

    public static String enumName(Object obj) {
        if (obj instanceof Enum) {
            return ((Enum)obj).name();
        }
        return ((Keyed)obj).getKey().getKey();
    }

    public static String keyedName(Object obj) {
        return ((Keyed)obj).getKey().toString();
    }

    public static <T> T[] enumValues(Class<T> clss) {
        if (clss.isEnum()) {
            return clss.getEnumConstants();
        }
        return Bukkit.getRegistry(clss).stream().toArray(i -> (Object[])Array.newInstance(clss, i));
    }

    public static <T extends MappedEntity> T randomRegistry(VersionedRegistry<T> registry) {
        int rnd = DisguiseUtilities.getRandom().nextInt(registry.size());
        Iterator iterator = registry.getEntries().iterator();
        while (iterator.hasNext()) {
            MappedEntity obj = (MappedEntity)iterator.next();
            if (iterator.hasNext() && --rnd >= 0) continue;
            return (T)obj;
        }
        return null;
    }

    public static <T> T randomEnum(Class<T> clss) {
        if (clss.isEnum()) {
            T[] enums = clss.getEnumConstants();
            return enums[DisguiseUtilities.getRandom().nextInt(enums.length)];
        }
        List enums = Bukkit.getRegistry(clss).stream().collect(Collectors.toList());
        return enums.get(DisguiseUtilities.getRandom().nextInt(enums.size()));
    }

    public static <T> T fromEnum(Class<T> clss, int ordinal) {
        if (!clss.isEnum()) {
            throw new IllegalStateException("Attempted to convert " + clss + " to an enum and use the ordinal, but that shouldn't be used in newer versions of Minecraft. This is a bug in Lib's Disguises, please report to libraryaddict");
        }
        return clss.getEnumConstants()[Math.max(0, ordinal) % clss.getEnumConstants().length];
    }

    public static <T> T fromEnum(Class<T> clss, String name) {
        String[] split = name.split(":");
        if (split.length != 2) {
            split = new String[]{"minecraft", name};
        }
        if (clss.isEnum()) {
            for (T e : clss.getEnumConstants()) {
                if (!((Enum)e).name().equalsIgnoreCase(split[1])) continue;
                return e;
            }
            return null;
        }
        return (T)Bukkit.getRegistry(clss).get(new NamespacedKey(split[0], split[1]));
    }

    @Generated
    public static ReflectionManagerAbstract getNmsReflection() {
        return nmsReflection;
    }

    @Generated
    public static boolean isMojangMapped() {
        return mojangMapped;
    }

    @Generated
    public static boolean isRunningPaper() {
        return runningPaper;
    }

    static {
        try {
            runningPaper = Class.forName("com.destroystokyo.paper.VersionHistoryManager$VersionData") != null;
        }
        catch (Exception ignored) {
            runningPaper = false;
        }
        try {
            Class.forName("net.minecraft.world.entity.MobCategory");
            mojangMapped = true;
        }
        catch (ClassNotFoundException ex) {
            mojangMapped = false;
        }
        workingBackend = null;
    }
}

