/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.parser;

import com.github.retrooper.packetevents.protocol.player.UserProfile;
import com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MiscDisguise;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.ModdedDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.BlockDisplayWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.DroppedItemWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.FallingBlockWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ItemDisplayWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.OminousItemSpawnerWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.PaintingWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.SkinUtils;
import me.libraryaddict.disguise.utilities.modded.ModdedEntity;
import me.libraryaddict.disguise.utilities.modded.ModdedManager;
import me.libraryaddict.disguise.utilities.params.ParamInfo;
import me.libraryaddict.disguise.utilities.params.ParamInfoManager;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.parser.DisguisePermissions;
import me.libraryaddict.disguise.utilities.parser.WatcherGetterSetter;
import me.libraryaddict.disguise.utilities.parser.WatcherMethod;
import me.libraryaddict.disguise.utilities.parser.constructors.ArtPaintingDisguiseParam;
import me.libraryaddict.disguise.utilities.parser.constructors.BlockStateDisguiseParam;
import me.libraryaddict.disguise.utilities.parser.constructors.ExtraDisguiseParam;
import me.libraryaddict.disguise.utilities.parser.constructors.IntegerPaintingDisguiseParam;
import me.libraryaddict.disguise.utilities.parser.constructors.ItemDisguiseParam;
import me.libraryaddict.disguise.utilities.parser.constructors.ItemFrameDisguiseParam;
import me.libraryaddict.disguise.utilities.parser.constructors.PlayerDisguiseParam;
import me.libraryaddict.disguise.utilities.parser.constructors.SplashPotionDisguiseParam;
import me.libraryaddict.disguise.utilities.parser.constructors.TextDisplayParam;
import me.libraryaddict.disguise.utilities.parser.constructors.WrappedBlockDisguiseParam;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import me.libraryaddict.disguise.utilities.translations.TranslateType;
import me.libraryaddict.disguise.utilities.watchers.DisguiseMethods;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;

public class DisguiseParser {
    private static final List<WatcherGetterSetter> watcherMethods = new ArrayList<WatcherGetterSetter>();
    private static final List<ExtraDisguiseParam> extraDisguiseParams = new ArrayList<ExtraDisguiseParam>();
    private static final ConcurrentHashMap<String, List<Consumer<UserProfile>>> fetchingSkins = new ConcurrentHashMap();
    private static long lastPremiumMessage;
    private static final Queue<Long> failedSkins;
    private static final ConcurrentHashMap<String, InvalidSkinHits> invalidSkinFilesExpiresAt;

    public static void createDefaultMethods() {
        try {
            ArrayList<WatcherMethod> allMethods = ParamInfoManager.getDisguiseMethods().getMethods();
            for (DisguiseType type : DisguiseType.values()) {
                WatcherMethod[] methods;
                TargetedDisguise disguise;
                if (type.getEntityType() == null) continue;
                if (type.isMisc()) {
                    disguise = new MiscDisguise(type);
                } else if (type.isMob()) {
                    disguise = new MobDisguise(type);
                } else {
                    if (!type.isPlayer()) continue;
                    disguise = new PlayerDisguise("Foobar");
                }
                FlagWatcher watcher = type.getWatcherClass().getConstructor(Disguise.class).newInstance(disguise);
                for (WatcherMethod setMethod : methods = ParamInfoManager.getDisguiseWatcherMethods(watcher.getClass(), true)) {
                    if (setMethod.getName().equals("addPotionEffect") || setMethod.getName().equals("setSkin") && setMethod.getParam() == String.class || setMethod.getName().equals("setTarget") && setMethod.getParam() != Integer.TYPE || (setMethod.getName().equals("setCustomName") || setMethod.getName().equals("setCustomNameVisible")) && disguise.isPlayerDisguise() || setMethod.getName().equals("setItemInMainHand") && setMethod.getParam() == Material.class || setMethod.getName().matches("setArmor") && setMethod.getParam() == ItemStack[].class) continue;
                    String sharedName = setMethod.getMappedName().substring(3);
                    String getPrefix = "get";
                    if (sharedName.matches("^Has(Nectar|Stung)$") || sharedName.matches("^Has((Left)|(Right))Horn$")) {
                        sharedName = sharedName.substring(3);
                        getPrefix = "has";
                    } else {
                        getPrefix = setMethod.getParam().isAssignableFrom(Boolean.TYPE) ? "is" : "get";
                    }
                    String getName = getPrefix + sharedName;
                    WatcherMethod getMethod = null;
                    for (WatcherMethod m : allMethods) {
                        if (m.getWatcherClass() != setMethod.getWatcherClass() || m.getParam() != null || !m.getMappedName().equals(getName)) continue;
                        getMethod = m;
                        break;
                    }
                    if (getMethod == null) {
                        LibsDisguises.getInstance().getLogger().severe(String.format("No such method '%s' when looking for the companion of '%s' in '%s'", getName, setMethod.getMappedName(), setMethod.getWatcherClass().getSimpleName()));
                        continue;
                    }
                    if (getMethod.getReturnType() != setMethod.getParam()) {
                        LibsDisguises.getInstance().getLogger().severe(String.format("Invalid return type of '%s' when looking for the companion of '%s' in '%s'", getName, setMethod.getMappedName(), setMethod.getWatcherClass().getSimpleName()));
                        continue;
                    }
                    if (getMethod.getAdded() != setMethod.getAdded() || getMethod.getRemoved() != setMethod.getRemoved()) {
                        LibsDisguises.getInstance().getLogger().severe(String.format("The methods %s and %s do not have matching NmsAdded and NmsRemoved, this is an oversight by the author of LibsDisguises", getMethod.getName(), setMethod.getName()));
                    }
                    Object defaultValue = null;
                    if (!setMethod.isRandomDefault()) {
                        Object invokeWith = watcher;
                        if (!ReflectionManager.isAssignableFrom(FlagWatcher.class, getMethod.getWatcherClass())) {
                            invokeWith = disguise;
                        }
                        defaultValue = getMethod.getMethod().bindTo(invokeWith).invoke();
                    }
                    DisguiseParser.addWatcherDefault(new WatcherGetterSetter(setMethod, getMethod, defaultValue, sharedName));
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        ArrayList<DisguiseType> blockDisguises = new ArrayList<DisguiseType>();
        blockDisguises.add(DisguiseType.MINECART);
        blockDisguises.add(DisguiseType.BLOCK_DISPLAY);
        if (NmsVersion.v1_20_R3.isSupported()) {
            blockDisguises.add(DisguiseType.PRIMED_TNT);
        }
        extraDisguiseParams.add(new BlockStateDisguiseParam(blockDisguises.toArray(new DisguiseType[0])));
        extraDisguiseParams.add(new WrappedBlockDisguiseParam(DisguiseType.FALLING_BLOCK));
        extraDisguiseParams.add(new ArtPaintingDisguiseParam());
        extraDisguiseParams.add(new IntegerPaintingDisguiseParam());
        extraDisguiseParams.add(new ItemDisguiseParam());
        extraDisguiseParams.add(new ItemFrameDisguiseParam());
        extraDisguiseParams.add(new PlayerDisguiseParam());
        extraDisguiseParams.add(new SplashPotionDisguiseParam());
        extraDisguiseParams.add(new TextDisplayParam());
    }

    private static String getSkin(String[] args) {
        if (args.length < 2 || !args[0].toLowerCase(Locale.ENGLISH).matches("p|player")) {
            return null;
        }
        for (int i = 0; i < args.length - 1; ++i) {
            if (!args[i].equalsIgnoreCase("setskin")) continue;
            return args[i + 1];
        }
        return args[1];
    }

    private static void grabSkin(final CommandSender sender, final String skinFile, PlayerDisguise disguise) {
        String usable;
        if (skinFile == null || !skinFile.toLowerCase(Locale.ENGLISH).matches(".*\\.png($|\\W.*)")) {
            return;
        }
        if (DisguiseUtilities.hasUserProfile(skinFile, true)) {
            return;
        }
        if (!LibsPremium.isPremium().booleanValue()) {
            if (sender == Bukkit.getConsoleSender()) {
                if (lastPremiumMessage + TimeUnit.HOURS.toMillis(3L) > System.currentTimeMillis()) {
                    return;
                }
                lastPremiumMessage = System.currentTimeMillis();
            }
            DisguiseUtilities.sendMessage(sender, "<red>Using a skin file inline with a player disguise is a Lib's Disguises premium feature, you must use /saveskin and save as that, or /savedisguise and disguise as the saved disguise.</red>");
            return;
        }
        while (!failedSkins.isEmpty() && failedSkins.peek() + TimeUnit.HOURS.toMillis(1L) < System.currentTimeMillis()) {
            failedSkins.poll();
        }
        if (failedSkins.size() >= 10) {
            LibsMsg.SKIN_API_TOO_MANY_FAILURES.send(sender, skinFile);
            return;
        }
        InvalidSkinHits skinInvalidAt = invalidSkinFilesExpiresAt.get(skinFile);
        if (skinInvalidAt != null && !(sender instanceof Player)) {
            if (skinInvalidAt.isRemove()) {
                invalidSkinFilesExpiresAt.remove(skinFile);
            } else if (!skinInvalidAt.hasExpired()) {
                LibsMsg.SKIN_API_TOO_MANY_FAILURES_NON_PLAYER.send(sender, skinFile);
                return;
            }
        }
        if ((usable = SkinUtils.getUsableStatus()) != null) {
            DisguiseUtilities.sendMessage(sender, usable);
            return;
        }
        Consumer<UserProfile> consumer = disguise::setSkin;
        List<Consumer<UserProfile>> list = fetchingSkins.get(skinFile);
        if (list != null) {
            list.add(consumer);
            return;
        }
        list = new ArrayList<Consumer<UserProfile>>();
        fetchingSkins.put(skinFile, list);
        list.add(consumer);
        SkinUtils.grabSkin(sender, skinFile, new SkinUtils.SkinCallback(){

            @Override
            public void onError(LibsMsg msg, Object ... args) {
                msg.send(sender, args);
                fetchingSkins.remove(skinFile);
                failedSkins.add(System.currentTimeMillis());
                switch (msg) {
                    case SKIN_API_IMAGE_TIMEOUT: 
                    case SKIN_API_TIMEOUT: 
                    case SKIN_API_TIMEOUT_ERROR: 
                    case SKIN_API_TIMER: 
                    case SKIN_API_TOO_MANY_FAILURES: 
                    case SKIN_API_TOO_MANY_FAILURES_NON_PLAYER: 
                    case SKIN_API_FAIL: 
                    case SKIN_API_BAD_FILE: 
                    case SKIN_API_BAD_FILE_NAME: 
                    case SKIN_API_FAIL_TOO_FAST: 
                    case SKIN_API_IN_USE: 
                    case SKIN_API_FAIL_CODE_EXCEPTIONAL: 
                    case SKIN_API_TIMEOUT_API_KEY_ERROR: 
                    case SKIN_API_FAIL_CODE: 
                    case SKIN_API_INVALID_NAME: {
                        InvalidSkinHits hits = invalidSkinFilesExpiresAt.computeIfAbsent(skinFile, k -> new InvalidSkinHits());
                        hits.addHit();
                        break;
                    }
                }
            }

            @Override
            public void onInfo(LibsMsg msg, Object ... args) {
                msg.send(sender, args);
            }

            @Override
            public void onSuccess(UserProfile profile) {
                DisguiseUtilities.doSkinUUIDWarning(sender);
                DisguiseAPI.addGameProfile(skinFile, profile);
                ((List)fetchingSkins.remove(skinFile)).forEach(a -> a.accept(profile));
            }
        });
    }

    public static void updateDisguiseName(Disguise disguise) {
        if (disguise == null || disguise.isCustomDisguiseName() || disguise.getWatcher() == null) {
            return;
        }
        ItemStack toResolve = null;
        WrappedBlockState blockState = null;
        String name = null;
        TranslateType prefixType = TranslateType.DISGUISES;
        String prefixName = disguise.getType().toReadable();
        switch (disguise.getType()) {
            case PAINTING: {
                name = ReflectionManager.enumName(((PaintingWatcher)disguise.getWatcher()).getArt());
                break;
            }
            case PLAYER: {
                prefixName = null;
                name = ((PlayerDisguise)disguise).getName();
                break;
            }
            case DROPPED_ITEM: {
                toResolve = ((DroppedItemWatcher)disguise.getWatcher()).getItemStack();
                break;
            }
            case ITEM_DISPLAY: {
                prefixName = "Item";
                prefixType = TranslateType.DISGUISE_OPTIONS_PARAMETERS;
                toResolve = ((ItemDisplayWatcher)disguise.getWatcher()).getItemStack();
                break;
            }
            case BLOCK_DISPLAY: {
                prefixName = "Block";
                prefixType = TranslateType.DISGUISE_OPTIONS_PARAMETERS;
                blockState = ((BlockDisplayWatcher)disguise.getWatcher()).getBlockState();
                break;
            }
            case FALLING_BLOCK: {
                prefixName = "Block";
                prefixType = TranslateType.DISGUISE_OPTIONS_PARAMETERS;
                blockState = ((FallingBlockWatcher)disguise.getWatcher()).getBlockState();
                break;
            }
            case OMINOUS_ITEM_SPAWNER: {
                toResolve = ((OminousItemSpawnerWatcher)disguise.getWatcher()).getItemStack();
                break;
            }
            default: {
                return;
            }
        }
        String toTranslate = null;
        if (toResolve != null) {
            toTranslate = toResolve.getType().name();
        } else if (blockState != null) {
            toTranslate = blockState.getType().getName();
        }
        if (toTranslate != null) {
            name = ReflectionManager.toReadable(toTranslate, " ");
        }
        if (name == null || name.trim().isEmpty()) {
            return;
        }
        String disguiseName = TranslateType.DISGUISE_OPTIONS_PARAMETERS.get(name);
        if (prefixName != null && !prefixName.trim().isEmpty() && (prefixName = prefixType.get(prefixName.trim())) != null && !prefixName.trim().isEmpty()) {
            disguiseName = prefixName + " " + disguiseName;
        }
        disguise.setDisguiseName(disguiseName);
    }

    public static String parseToString(Disguise disguise) {
        return DisguiseParser.parseToString(disguise, true);
    }

    public static String parseToString(Disguise disguise, boolean outputSkinData) {
        return DisguiseParser.parseToString(disguise, outputSkinData, false);
    }

    public static String parseToString(Disguise disguise, WatcherMethod method) throws Throwable {
        if (method.getOwner() != null) {
            method = method.getOwner().getGetter();
        }
        Object invokeWith = method.getWatcherClass().isInstance(disguise) ? disguise : disguise.getWatcher();
        Object ourValue = method.getMethod().bindTo(invokeWith).invoke();
        if ("".equals(ourValue) && method.getMappedName().equals("getCustomName")) {
            ourValue = null;
        }
        if (method.getMappedName().equals("getSkin") && disguise.isPlayerDisguise()) {
            PlayerDisguise pDisg = (PlayerDisguise)disguise;
            ourValue = pDisg.getName();
            if (pDisg.getSkin() != null) {
                if (pDisg.getSkin().length() <= 32) {
                    ourValue = pDisg.getSkin();
                }
            } else if (pDisg.getUserProfile() != null && pDisg.getUserProfile().getName() != null) {
                ourValue = pDisg.getUserProfile().getName();
            }
        }
        if (ourValue != null) {
            ParamInfo paramInfo = ourValue instanceof String ? ParamInfoManager.getParamInfo(String.class) : ParamInfoManager.getParamInfo(method.getReturnType());
            if (paramInfo == null) {
                LibsDisguises.getInstance().getLogger().info("Unhandled parameter for " + ourValue.getClass() + ", ParamInfo was not found");
                return "null";
            }
            String valueString = paramInfo.toString(ourValue);
            if (ourValue instanceof String) {
                return TranslateType.DISGUISE_OPTIONS_PARAMETERS.reverseGet(valueString);
            }
            return valueString;
        }
        return TranslateType.DISGUISE_OPTIONS_PARAMETERS.reverseGet("null");
    }

    public static String parseToString(Disguise disguise, boolean outputSkinData, boolean includeCustomData) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(TranslateType.DISGUISES.reverseGet(disguise.getType().toReadable().replace(" ", "_")));
            if (disguise.isPlayerDisguise()) {
                stringBuilder.append(" ").append(DisguiseUtilities.quote(((PlayerDisguise)disguise).getName()));
            }
            WatcherMethod[] methods = ParamInfoManager.getDisguiseWatcherMethods(disguise.getType().getWatcherClass());
            for (int i = methods.length - 1; i >= 0; --i) {
                String valueString;
                WatcherGetterSetter getterSetter = methods[i].getOwner();
                if (getterSetter == null) continue;
                WatcherMethod setter = getterSetter.getSetter();
                WatcherMethod watcherMethod = getterSetter.getGetter();
                if (watcherMethod.getMappedName().equals("getPotionEffects")) {
                    PotionEffectType[] types;
                    for (PotionEffectType type : types = watcherMethod.getMethod().invoke()) {
                        if (type == null) continue;
                        stringBuilder.append(" ").append(TranslateType.DISGUISE_OPTIONS.reverseGet(setter.getMappedName())).append(" ").append(TranslateType.DISGUISE_OPTIONS_PARAMETERS.reverseGet(type.getName()));
                    }
                    continue;
                }
                if (setter.getMappedName().equals("setNoGravity") || disguise.isPlayerDisguise() && (setter.getMappedName().equals("setCustomName") || setter.getMappedName().equals("setTablistName") && ((PlayerDisguise)disguise).getName().equals(((PlayerDisguise)disguise).getTablistName()) || setter.getMappedName().equals("setSkin") && ((PlayerDisguise)disguise).getName().equals(((PlayerDisguise)disguise).getSkin()))) continue;
                Object invokeWith = setter.getWatcherClass().isInstance(disguise) ? disguise : disguise.getWatcher();
                Object ourValue = watcherMethod.getMethod().bindTo(invokeWith).invoke();
                if ("".equals(ourValue) && setter.getMappedName().equals("setCustomName")) {
                    ourValue = null;
                }
                if (setter.getMappedName().equals("setSkin") && !outputSkinData) {
                    PlayerDisguise pDisg = (PlayerDisguise)disguise;
                    ourValue = pDisg.getName();
                    if (pDisg.getSkin() != null) {
                        ourValue = pDisg.getSkin();
                    } else if (pDisg.getUserProfile() != null && pDisg.getUserProfile().getName() != null) {
                        ourValue = pDisg.getUserProfile().getName();
                    }
                    if (ourValue.equals(pDisg.getName())) {
                        continue;
                    }
                } else if (!setter.isRandomDefault() && Objects.deepEquals(getterSetter.getDefaultValue(), ourValue)) continue;
                stringBuilder.append(" ").append(TranslateType.DISGUISE_OPTIONS.reverseGet(setter.getMappedName()));
                if (ourValue instanceof Boolean && ((Boolean)ourValue).booleanValue()) continue;
                if (ourValue != null) {
                    ParamInfo paramInfo = ourValue instanceof String ? ParamInfoManager.getParamInfo(String.class) : ParamInfoManager.getParamInfo(watcherMethod.getReturnType());
                    if (paramInfo == null) {
                        LibsDisguises.getInstance().getLogger().info("Unhandled parameter for " + ourValue.getClass() + ", ParamInfo was not found");
                        continue;
                    }
                    valueString = paramInfo.toString(ourValue);
                    if (ourValue instanceof String) {
                        valueString = TranslateType.DISGUISE_OPTIONS_PARAMETERS.reverseGet(valueString);
                    }
                    valueString = DisguiseUtilities.quote(valueString);
                } else {
                    valueString = TranslateType.DISGUISE_OPTIONS_PARAMETERS.reverseGet("null");
                }
                stringBuilder.append(" ").append(valueString);
            }
            if (includeCustomData) {
                HashMap<String, Object> meta = disguise.getCustomData();
                LinkedHashMap<String, String> serializedMeta = new LinkedHashMap<String, String>();
                for (Map.Entry entry : meta.entrySet()) {
                    Object val = entry.getValue();
                    try {
                        if (val == null) {
                            serializedMeta.put((String)entry.getKey(), "null");
                            continue;
                        }
                        String serialized = DisguiseUtilities.getGson().toJson(val);
                        serializedMeta.put((String)entry.getKey(), val.getClass().getName() + ":" + serialized);
                    }
                    catch (Throwable throwable) {
                        LibsDisguises.getInstance().getLogger().warning("Unable to properly serialize the metadata on a disguise, the metadata was saved under name '" + (String)entry.getKey() + "'");
                        if (throwable instanceof StackOverflowError) continue;
                        throwable.printStackTrace();
                    }
                }
                if (!serializedMeta.isEmpty()) {
                    String serialized = DisguiseUtilities.getGson().toJson(serializedMeta);
                    stringBuilder.append(" ").append("setCustomData").append(" ").append(DisguiseUtilities.quote(serialized));
                }
            }
            return stringBuilder.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void addWatcherDefault(WatcherGetterSetter watcherGetterSetter) {
        List existing = watcherMethods.stream().filter(method -> method.getSetter().equals(watcherGetterSetter.getSetter())).collect(Collectors.toList());
        if (existing.isEmpty()) {
            if (watcherGetterSetter.getGetter().getOwner() != null || watcherGetterSetter.getSetter().getOwner() != null) {
                throw new IllegalStateException("Trying to register an older on an existing watcher! Lack of info as this shouldn't be called");
            }
            watcherGetterSetter.getSetter().setOwner(watcherGetterSetter);
            watcherGetterSetter.getGetter().setOwner(watcherGetterSetter);
            watcherMethods.add(watcherGetterSetter);
            return;
        }
        if (existing.size() > 1) {
            throw new IllegalStateException("Shouldn't have more than 1 getter/setter for " + watcherGetterSetter.getSetter().getName());
        }
        Object dObj = ((WatcherGetterSetter)existing.get(0)).getDefaultValue();
        if (!Objects.deepEquals(dObj, watcherGetterSetter.getDefaultValue())) {
            throw new IllegalStateException(String.format("%s has conflicting values in class %s! This means it expected the same value again but received a different value on a different disguise! %s is not the same as %s!", watcherGetterSetter.getSetter().toString(), watcherGetterSetter.getSetter(), watcherGetterSetter.getDefaultValue(), dObj));
        }
    }

    private static void doCheck(CommandSender sender, DisguisePermissions permissions, DisguisePerm disguisePerm, Collection<String> usedOptions) throws DisguiseParseException {
        DisguiseParseException exception = permissions.getReasonNotAllowed(disguisePerm, usedOptions);
        if (exception == null) {
            return;
        }
        throw exception;
    }

    public static DisguisePerm getDisguisePerm(String name) {
        name = name.replaceAll("[ |_]", "").toLowerCase(Locale.ENGLISH);
        for (DisguisePerm perm : DisguiseParser.getDisguisePerms()) {
            if (!perm.getRegexedName().equals(name)) continue;
            return perm;
        }
        if (name.equals("p")) {
            return DisguiseParser.getDisguisePerm(DisguiseType.PLAYER.toReadable());
        }
        return null;
    }

    public static DisguisePerm[] getDisguisePerms() {
        ArrayList<DisguisePerm> perms = new ArrayList<DisguisePerm>();
        for (DisguiseType disguiseType : DisguiseType.values()) {
            if (disguiseType.getEntityType() == null || disguiseType.isCustom()) continue;
            perms.add(new DisguisePerm(disguiseType));
        }
        for (Map.Entry entry : DisguiseConfig.getCustomDisguises().entrySet()) {
            perms.add((DisguisePerm)entry.getKey());
        }
        perms.addAll(ModdedManager.getDisguiseTypes());
        return perms.toArray(new DisguisePerm[0]);
    }

    public static DisguisePermissions getPermissions(CommandSender sender, String commandName) {
        return DisguisePermissions.getPermissions((Permissible)sender, commandName);
    }

    private static boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String getName(CommandSender entity) {
        if (entity == null) {
            return "??";
        }
        if (entity instanceof Player) {
            return entity.getName();
        }
        if (entity instanceof Entity && ((Entity)entity).getCustomName() != null && ((Entity)entity).getCustomName().length() > 0) {
            return ((Entity)entity).getCustomName();
        }
        return entity.getName();
    }

    private static String getSkin(CommandSender entity) {
        UserProfile gameProfile;
        if (entity == null) {
            return "??";
        }
        if (entity instanceof Player && (gameProfile = ReflectionManager.getUserProfile((Player)entity)) != null) {
            return DisguiseUtilities.getGson().toJson((Object)gameProfile);
        }
        return "{}";
    }

    public static String[] parsePlaceholders(String[] args, CommandSender user, CommandSender target) {
        return DisguiseParser.parsePlaceholders(args, DisguiseParser.getName(user), DisguiseUtilities.getDisplayName(user), DisguiseParser.getSkin(user), DisguiseParser.getName(target), DisguiseUtilities.getDisplayName(target), DisguiseParser.getSkin(target), DisguiseParser.getEntityEquipment(user), DisguiseParser.getEntityEquipment(target));
    }

    private static EntityEquipment getEntityEquipment(CommandSender entity) {
        return entity instanceof LivingEntity ? ((LivingEntity)entity).getEquipment() : null;
    }

    public static String[] parsePlaceholders(String[] args, String userName, String userSkin, String targetName, String targetSkin, EntityEquipment equip, EntityEquipment targetEquip) {
        return DisguiseParser.parsePlaceholders(args, userName, userName, userSkin, targetName, targetName, targetSkin, equip, targetEquip);
    }

    public static String[] parsePlaceholders(String[] args, String userName, String userDisplayname, String userSkin, String targetName, String targetDisplayname, String targetSkin, EntityEquipment equip, EntityEquipment targetEquip) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            arg = DisguiseParser.replace(arg, "%name%", userName);
            arg = DisguiseParser.replace(arg, "%displayname%", userDisplayname);
            arg = DisguiseParser.replace(arg, "%skin%", userSkin);
            arg = DisguiseParser.replace(arg, "%held-item%", equip == null ? null : equip.getItemInMainHand());
            arg = DisguiseParser.replace(arg, "%offhand-item%", equip == null ? null : equip.getItemInOffHand());
            arg = DisguiseParser.replace(arg, "%armor%", equip == null ? null : equip.getArmorContents());
            arg = DisguiseParser.replace(arg, "%helmet%", equip == null ? null : equip.getHelmet());
            arg = DisguiseParser.replace(arg, "%chestplate%", equip == null ? null : equip.getChestplate());
            arg = DisguiseParser.replace(arg, "%leggings%", equip == null ? null : equip.getLeggings());
            arg = DisguiseParser.replace(arg, "%boots%", equip == null ? null : equip.getBoots());
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!arg.contains("%" + p.getName() + "-")) continue;
                String name = p.getName();
                arg = DisguiseParser.replace(arg, "%" + name + "-name%", name);
                arg = DisguiseParser.replace(arg, "%" + name + "-displayname%", DisguiseUtilities.getDisplayName((CommandSender)p));
                arg = DisguiseParser.replace(arg, "%" + name + "-skin%", DisguiseParser.getSkin((CommandSender)p));
                EntityEquipment pEquip = p.getEquipment();
                arg = DisguiseParser.replace(arg, "%" + name + "-held-item%", pEquip == null ? null : pEquip.getItemInMainHand());
                arg = DisguiseParser.replace(arg, "%" + name + "-offhand-item%", pEquip == null ? null : pEquip.getItemInOffHand());
                arg = DisguiseParser.replace(arg, "%" + name + "-armor%", pEquip == null ? null : pEquip.getArmorContents());
                arg = DisguiseParser.replace(arg, "%" + name + "-helmet%", pEquip == null ? null : pEquip.getHelmet());
                arg = DisguiseParser.replace(arg, "%" + name + "-chestplate%", pEquip == null ? null : pEquip.getChestplate());
                arg = DisguiseParser.replace(arg, "%" + name + "-leggings%", pEquip == null ? null : pEquip.getLeggings());
                arg = DisguiseParser.replace(arg, "%" + name + "-boots%", pEquip == null ? null : pEquip.getBoots());
            }
            arg = DisguiseParser.replace(arg, "%target-name%", targetName);
            arg = DisguiseParser.replace(arg, "%target-displayname%", targetDisplayname);
            arg = DisguiseParser.replace(arg, "%target-skin%", targetSkin);
            arg = DisguiseParser.replace(arg, "%target-held-item%", targetEquip == null ? null : targetEquip.getItemInMainHand());
            arg = DisguiseParser.replace(arg, "%target-offhand-item%", targetEquip == null ? null : targetEquip.getItemInOffHand());
            arg = DisguiseParser.replace(arg, "%target-armor%", targetEquip == null ? null : targetEquip.getArmorContents());
            arg = DisguiseParser.replace(arg, "%target-helmet%", targetEquip == null ? null : targetEquip.getHelmet());
            arg = DisguiseParser.replace(arg, "%target-chestplate%", targetEquip == null ? null : targetEquip.getChestplate());
            arg = DisguiseParser.replace(arg, "%target-leggings%", targetEquip == null ? null : targetEquip.getLeggings());
            args[i] = arg = DisguiseParser.replace(arg, "%target-boots%", targetEquip == null ? null : targetEquip.getBoots());
        }
        return args;
    }

    private static String replace(String string, String value, Object toReplace) {
        if (!string.contains(value)) {
            return string;
        }
        String oValue = toReplace != null ? ParamInfoManager.toString(toReplace) : "null";
        return string.replace(value, oValue);
    }

    public static long parseStringToTime(String string) throws DisguiseParseException {
        return DisguiseParser.parseStringToTime(string, false);
    }

    public static long parseStringToTime(String string, boolean resolveToTicks) throws DisguiseParseException {
        if (!(string = string.toLowerCase(Locale.ENGLISH)).matches("([0-9]+[a-z]+)+")) {
            throw new DisguiseParseException(LibsMsg.PARSE_INVALID_TIME_SEQUENCE, string);
        }
        String[] split = string.split("((?<=[a-zA-Z])(?=[0-9]))|((?<=[0-9])(?=[a-zA-Z]))");
        long time = 0L;
        long ticks = 0L;
        for (int i = 0; i < split.length; i += 2) {
            String t = split[i + 1];
            long v = Long.parseLong(split[i]);
            if (t.equals("t") || t.equals("tick") || t.equals("ticks")) {
                ticks += v;
                continue;
            }
            if (t.equals("s") || t.equals("sec") || t.equals("secs") || t.equals("seconds")) {
                time += v;
                continue;
            }
            if (t.equals("m") || t.equals("min") || t.equals("minute") || t.equals("minutes")) {
                time += TimeUnit.MINUTES.toSeconds(v);
                continue;
            }
            if (t.equals("h") || t.equals("hour") || t.equals("hours")) {
                time += TimeUnit.HOURS.toSeconds(v);
                continue;
            }
            if (t.equals("d") || t.equals("day") || t.equals("days")) {
                time += TimeUnit.DAYS.toSeconds(v);
                continue;
            }
            if (t.equals("w") || t.equals("week") || t.equals("weeks")) {
                time += TimeUnit.DAYS.toSeconds(v) * 7L;
                continue;
            }
            if (t.equals("mon") || t.equals("month") || t.equals("months")) {
                time += TimeUnit.DAYS.toSeconds(v) * 31L;
                continue;
            }
            if (t.equals("y") || t.equals("year") || t.equals("years")) {
                time += TimeUnit.DAYS.toSeconds(v) * 365L;
                continue;
            }
            throw new DisguiseParseException(LibsMsg.PARSE_INVALID_TIME, t);
        }
        if (resolveToTicks) {
            return ticks + time * 20L;
        }
        return (long)Math.ceil((double)ticks / 20.0) + time;
    }

    public static Disguise parseTestDisguise(CommandSender sender, String permNode, String[] args, DisguisePermissions permissions) throws Throwable {
        args = Arrays.copyOf(args, args.length);
        String skin = "{\"id\":\"a149f81bf7844f8987c554afdd4db533\",\"name\":\"libraryaddict\",\"properties\":[]}";
        args = DisguiseParser.parsePlaceholders(args, "libraryaddict", skin, "libraryaddict", skin, null, null);
        return DisguiseParser.parseDisguise(sender, null, permNode, args, permissions);
    }

    public static void modifyDisguise(Disguise disguise, Entity target, String[] params) throws Throwable {
        if (target != null) {
            params = DisguiseParser.parsePlaceholders(params, (CommandSender)target, (CommandSender)target);
        }
        DisguiseParser.callMethods((CommandSender)Bukkit.getConsoleSender(), disguise, null, new DisguisePerm(disguise.getType()), new ArrayList<String>(), params, "Disguise");
    }

    public static void modifyDisguise(Disguise disguise, String[] params) throws Throwable {
        DisguiseParser.modifyDisguise(disguise, null, params);
    }

    public static void modifyDisguise(Disguise disguise, String params) throws Throwable {
        DisguiseParser.modifyDisguise(disguise, null, params);
    }

    public static void modifyDisguise(Disguise disguise, Entity target, String params) throws Throwable {
        DisguiseParser.modifyDisguise(disguise, target, DisguiseUtilities.split(params));
    }

    public static Disguise parseDisguise(String disguise) throws Throwable {
        return DisguiseParser.parseDisguise(null, disguise);
    }

    public static Disguise parseDisguise(Entity target, String disguise) throws Throwable {
        return DisguiseParser.parseDisguise((CommandSender)Bukkit.getConsoleSender(), target, "disguise", DisguiseUtilities.split(disguise), null);
    }

    public static Disguise parseDisguise(CommandSender sender, Entity target, String disguise) throws Throwable {
        return DisguiseParser.parseDisguise(sender, target, "disguise", DisguiseUtilities.split(disguise), DisguisePermissions.getPermissions((Permissible)sender, "disguise"));
    }

    public static Disguise parseDisguise(CommandSender sender, Entity target, String permNode, String[] args, @Nullable DisguisePermissions permissions) throws Throwable {
        String name;
        DisguisePerm disguisePerm;
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("DisguiseParser should not be called async!");
        }
        if (sender instanceof Player) {
            DisguiseUtilities.setCommandsUsed();
        }
        if (permissions != null && !permissions.hasPermissions()) {
            throw new DisguiseParseException(LibsMsg.NO_PERM, new String[0]);
        }
        if (args.length == 0) {
            throw new DisguiseParseException(LibsMsg.PARSE_NO_ARGS, new String[0]);
        }
        int toSkip = 1;
        ArrayList<String> usedOptions = new ArrayList<String>();
        Disguise disguise = null;
        boolean hasSetCustomName = false;
        if (args[0].startsWith("@")) {
            if (sender.hasPermission("libsdisguises.disguise.disguiseclone")) {
                disguise = DisguiseUtilities.getClonedDisguise(args[0].toLowerCase(Locale.ENGLISH));
                if (disguise == null) {
                    throw new DisguiseParseException(LibsMsg.PARSE_NO_REF, args[0]);
                }
            } else {
                throw new DisguiseParseException(LibsMsg.PARSE_NO_PERM_REF, new String[0]);
            }
            disguisePerm = new DisguisePerm(disguise.getType());
            name = disguise.getDisguiseName();
            hasSetCustomName = disguise.isCustomDisguiseName();
            if (disguisePerm.isUnknown()) {
                throw new DisguiseParseException(LibsMsg.PARSE_CANT_DISG_UNKNOWN, new String[0]);
            }
            if (disguisePerm.getEntityType() == null) {
                throw new DisguiseParseException(LibsMsg.PARSE_CANT_LOAD, new String[0]);
            }
            if (permissions != null && !permissions.isAllowedDisguise(disguisePerm)) {
                if (permissions.getDisabledInConfigDisguises().contains((Object)disguisePerm.getType())) {
                    throw new DisguiseParseException(LibsMsg.DISABLED_CONFIG_DISGUISE, new String[0]);
                }
                throw new DisguiseParseException(LibsMsg.NO_PERM_DISGUISE, new String[0]);
            }
        } else {
            Map.Entry<DisguisePerm, String> customDisguise;
            disguisePerm = DisguiseParser.getDisguisePerm(args[0]);
            if (disguisePerm == null) {
                throw new DisguiseParseException(LibsMsg.PARSE_DISG_NO_EXIST, args[0]);
            }
            name = disguisePerm.toReadable();
            if (disguisePerm.getType().isCustom()) {
                ModdedEntity ent = ModdedManager.getModdedEntity(disguisePerm.toReadable());
                if (ent == null) {
                    throw new DisguiseParseException(LibsMsg.PARSE_CANT_DISG_UNKNOWN, new String[0]);
                }
                disguise = new ModdedDisguise(ent);
                hasSetCustomName = true;
            }
            if ((customDisguise = DisguiseConfig.getRawCustomDisguise(args[0])) != null) {
                String[] oldArgs = Arrays.copyOfRange(args, 1, args.length);
                args = DisguiseUtilities.split(customDisguise.getValue());
                args = Arrays.copyOf(args, args.length + oldArgs.length);
                for (int i = 0; i < oldArgs.length; ++i) {
                    args[args.length - (oldArgs.length - i)] = oldArgs[i];
                }
                name = customDisguise.getKey().toReadable();
                hasSetCustomName = true;
            }
            args = DisguiseParser.parsePlaceholders(args, (CommandSender)(sender == null ? target : sender), (CommandSender)target);
            if (disguisePerm.isUnknown()) {
                throw new DisguiseParseException(LibsMsg.PARSE_CANT_DISG_UNKNOWN, new String[0]);
            }
            if (disguisePerm.getEntityType() == null) {
                throw new DisguiseParseException(LibsMsg.PARSE_CANT_LOAD, new String[0]);
            }
            if (permissions != null && !permissions.isAllowedDisguise(disguisePerm)) {
                if (permissions.getDisabledInConfigDisguises().contains((Object)disguisePerm.getType())) {
                    throw new DisguiseParseException(LibsMsg.DISABLED_CONFIG_DISGUISE, new String[0]);
                }
                throw new DisguiseParseException(LibsMsg.NO_PERM_DISGUISE, new String[0]);
            }
            if (disguise == null) {
                WatcherMethod[] watcherMethods = ParamInfoManager.getDisguiseWatcherMethods(disguisePerm.getWatcherClass(), true);
                String method = null;
                String param = null;
                if (args.length > 1) {
                    String[] argArray = args;
                    if (Arrays.stream(watcherMethods).noneMatch(m -> m.getMappedName().equalsIgnoreCase(argArray[1]))) {
                        WatcherMethod[] disguiseOptions = permissions == null ? null : DisguisePermissions.getDisguiseOptions((Permissible)sender, permNode, disguisePerm);
                        for (ExtraDisguiseParam extra : extraDisguiseParams) {
                            if (!extra.isApplicable(disguisePerm.getType(), args[1])) continue;
                            method = extra.getParameterMethod();
                            try {
                                param = extra.createParametervalue(sender, args[1]);
                            }
                            catch (DisguiseParseException ex) {
                                throw ex;
                            }
                            catch (Throwable throwable) {
                                throw new DisguiseParseException(LibsMsg.PARSE_EXPECTED_RECEIVED, extra.getParamInfo().getDescriptiveName(), args[1], TranslateType.DISGUISE_OPTIONS.reverseGet(TranslateType.DISGUISE_OPTIONS.reverseGet(method)));
                            }
                            if (permissions != null) {
                                extra.checkParameterPermission(sender, permissions, (HashMap<String, HashMap<String, Boolean>>)disguiseOptions, usedOptions, disguisePerm, param);
                            }
                            ++toSkip;
                            break;
                        }
                    }
                }
                if (disguisePerm.isPlayer()) {
                    if (args.length == 1) {
                        throw new DisguiseParseException(LibsMsg.PARSE_SUPPLY_PLAYER, new String[0]);
                    }
                    if (method == null) {
                        param = "Nameless Player";
                    } else if (!"setName".equalsIgnoreCase(method)) {
                        throw new IllegalStateException("Expected setName to be defined, this is an internal error, not a user error. Method was " + method);
                    }
                    disguise = new PlayerDisguise(param);
                    method = null;
                    if (!hasSetCustomName) {
                        name = ((PlayerDisguise)disguise).getName();
                    }
                } else if (disguisePerm.isMob()) {
                    disguise = new MobDisguise(disguisePerm.getType());
                } else if (disguisePerm.isMisc()) {
                    disguise = new MiscDisguise(disguisePerm.getType());
                }
                if (method != null && param != null) {
                    WatcherMethod m2 = null;
                    for (WatcherMethod method1 : watcherMethods) {
                        if (!method1.getMappedName().equalsIgnoreCase(method) || !method1.getParam().isAssignableFrom(param.getClass())) continue;
                        m2 = method1;
                        break;
                    }
                    if (m2 == null) {
                        throw new DisguiseParseException(LibsMsg.PARSE_CANT_LOAD_DETAILS, args[1], method);
                    }
                    MethodHandle handle = m2.getMethod();
                    handle = ReflectionManager.isAssignableFrom(FlagWatcher.class, m2.getWatcherClass()) ? handle.bindTo(disguise.getWatcher()) : handle.bindTo(disguise);
                    handle.invoke(param);
                }
                if (!hasSetCustomName) {
                    DisguiseParser.updateDisguiseName(disguise);
                    name = disguise.getDisguiseName();
                }
            }
        }
        disguise.setDisguiseName(name);
        disguise.setCustomDisguiseName(hasSetCustomName);
        String[] newArgs = new String[args.length - toSkip];
        System.arraycopy(args, toSkip, newArgs, 0, args.length - toSkip);
        DisguiseParser.callMethods(sender, disguise, permissions, disguisePerm, usedOptions, newArgs, permNode);
        if (sender instanceof Player && target instanceof Player && ("%%__USER__%%".equals("1592") || LibsPremium.getPluginInformation().isPremium() != LibsPremium.getPluginInformation().isPaid()) && ThreadLocalRandom.current().nextBoolean()) {
            ((TargetedDisguise)disguise).setDisguiseTarget(TargetedDisguise.TargetType.HIDE_DISGUISE_TO_EVERYONE_BUT_THESE_PLAYERS);
            ((TargetedDisguise)disguise).addPlayer((Player)sender);
        }
        return disguise;
    }

    public static void callMethods(CommandSender sender, Disguise disguise, @Nullable DisguisePermissions disguisePermission, DisguisePerm disguisePerm, Collection<String> usedOptions, String[] args, String permNode) throws Throwable {
        WatcherMethod[] methods = ParamInfoManager.getDisguiseWatcherMethods(disguise.getWatcher().getClass(), true);
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(args));
        HashMap<String, HashMap<String, Boolean>> disguiseOptions = disguisePermission == null ? null : DisguisePermissions.getDisguiseOptions((Permissible)sender, permNode, disguisePerm);
        for (int argIndex = 0; argIndex < args.length; ++argIndex) {
            String methodNameProvided = (String)list.remove(0);
            String methodNameJava = TranslateType.DISGUISE_OPTIONS.reverseGet(methodNameProvided);
            WatcherMethod methodToUse = null;
            String valueToSet = null;
            DisguiseParseException parseException = null;
            if (!list.isEmpty() && methodNameProvided.equalsIgnoreCase("setCustomData") && (sender == null || sender.isOp())) {
                ++argIndex;
                String string = (String)list.remove(0);
                Map deserial = (Map)DisguiseUtilities.getGson().fromJson(string, LinkedHashMap.class);
                for (Map.Entry entry : deserial.entrySet()) {
                    String val = (String)entry.getValue();
                    if (!val.contains(":")) {
                        disguise.addCustomData((String)entry.getKey(), null);
                        continue;
                    }
                    String className = val.substring(0, val.indexOf(":"));
                    val = val.substring(className.length() + 1);
                    disguise.addCustomData((String)entry.getKey(), DisguiseUtilities.getGson().fromJson(val, DisguiseMethods.parseType(className)));
                }
                continue;
            }
            for (WatcherMethod method : methods) {
                if (!method.getMappedName().equalsIgnoreCase(methodNameJava)) continue;
                ParamInfo paramInfo = ParamInfoManager.getParamInfo(method);
                try {
                    int argCount = list.size();
                    if (argCount < paramInfo.getMinArguments()) {
                        throw new DisguiseParseException(LibsMsg.PARSE_NO_OPTION_VALUE, TranslateType.DISGUISE_OPTIONS.reverseGet(method.getMappedName()));
                    }
                    valueToSet = (String)paramInfo.fromString(list);
                    if (valueToSet == null && !paramInfo.canReturnNull()) {
                        throw new IllegalStateException();
                    }
                    argIndex += argCount - list.size();
                    methodToUse = method;
                    break;
                }
                catch (DisguiseParseException ex) {
                    parseException = ex;
                }
                catch (Exception ex) {
                    parseException = new DisguiseParseException(LibsMsg.PARSE_EXPECTED_RECEIVED, paramInfo.getDescriptiveName(), list.isEmpty() ? null : (String)list.get(0), TranslateType.DISGUISE_OPTIONS.reverseGet(method.getMappedName()));
                }
            }
            if (methodToUse == null) {
                if (parseException != null) {
                    throw parseException;
                }
                throw new DisguiseParseException(LibsMsg.PARSE_OPTION_NA, methodNameProvided);
            }
            String string = methodToUse.getMappedName().toLowerCase(Locale.ENGLISH);
            if (!usedOptions.contains(string)) {
                usedOptions.add(string);
            }
            if (disguisePermission != null) {
                DisguiseParser.doCheck(sender, disguisePermission, disguisePerm, usedOptions);
                if (!disguiseOptions.isEmpty()) {
                    String stringValue = ParamInfoManager.toString(valueToSet);
                    if (!DisguisePermissions.hasPermissionOption(disguiseOptions, methodToUse.getMappedName(), stringValue)) {
                        throw new DisguiseParseException(LibsMsg.PARSE_NO_PERM_PARAM, stringValue, disguisePerm.toReadable());
                    }
                }
            }
            if ((DisguiseConfig.isArmorstandsName() || DisguiseConfig.isDisplayTextName()) && (methodToUse.getMappedName().equals("setName") && disguise.isPlayerDisguise() || DisguiseConfig.isOverrideCustomNames() && methodToUse.getMappedName().equals("setCustomName")) && !sender.hasPermission("libsdisguises.multiname")) {
                valueToSet = DisguiseUtilities.quoteNewLine(valueToSet);
            }
            MethodHandle handle = methodToUse.getMethod();
            handle = FlagWatcher.class.isAssignableFrom(methodToUse.getWatcherClass()) ? handle.bindTo(disguise.getWatcher()) : handle.bindTo(disguise);
            handle.invoke(valueToSet);
        }
        if (disguise instanceof PlayerDisguise) {
            DisguiseParser.grabSkin(sender, DisguiseParser.getSkin(args), (PlayerDisguise)disguise);
        }
        if (disguise instanceof PlayerDisguise && args.length > 1) {
            for (int i = 0; i < args.length - 1; ++i) {
                if (!args[i].equalsIgnoreCase("setSkin")) continue;
                DisguiseParser.grabSkin(sender, args[i + 1], (PlayerDisguise)disguise);
                break;
            }
        }
    }

    static {
        failedSkins = new ConcurrentLinkedQueue<Long>();
        invalidSkinFilesExpiresAt = new ConcurrentHashMap();
    }

    private static class InvalidSkinHits {
        private int occured;
        private long lastHit;

        private InvalidSkinHits() {
        }

        public void addHit() {
            ++this.occured;
            this.lastHit = System.currentTimeMillis();
        }

        public boolean isRemove() {
            return this.lastHit + TimeUnit.MILLISECONDS.toMillis(this.occured) < System.currentTimeMillis();
        }

        public boolean hasExpired() {
            int expiresMinutes = this.occured <= 10 ? this.occured * 3 : this.occured * 30;
            return this.lastHit + TimeUnit.MINUTES.toMillis(expiresMinutes) < System.currentTimeMillis();
        }
    }
}

