/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packetlisteners;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.event.SimplePacketListenerAbstract;
import com.github.retrooper.packetevents.event.simple.PacketPlayReceiveEvent;
import com.github.retrooper.packetevents.event.simple.PacketPlaySendEvent;
import com.github.retrooper.packetevents.protocol.item.type.ItemTypes;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientClickWindow;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientCreativeInventoryAction;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSetSlot;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerWindowItems;
import java.util.List;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PacketListenerInventory
extends SimplePacketListenerAbstract {
    public void onPacketPlayReceive(PacketPlayReceiveEvent event) {
        try {
            if (event.isCancelled()) {
                return;
            }
            if (event.getPacketType() != PacketType.Play.Client.CLICK_WINDOW && event.getPacketType() != PacketType.Play.Client.CREATIVE_INVENTORY_ACTION) {
                return;
            }
            if (!Bukkit.isPrimaryThread()) {
                final PacketPlayReceiveEvent cloned = event.clone();
                new BukkitRunnable(){

                    public void run() {
                        PacketListenerInventory.this.onPacketPlayReceive(cloned);
                    }
                }.runTask((Plugin)LibsDisguises.getInstance());
                return;
            }
            final Player player = (Player)event.getPlayer();
            if (player == null || player.getVehicle() != null) {
                return;
            }
            if (!DisguiseConfig.isHidingCreativeEquipmentFromSelf() && player.getGameMode() == GameMode.CREATIVE) {
                return;
            }
            Disguise disguise = DisguiseAPI.getDisguise(player, (Entity)player);
            if (disguise == null || !DisguiseUtilities.getSelfDisguised().contains(player.getUniqueId()) || !disguise.isHidingArmorFromSelf() && !disguise.isHidingHeldItemFromSelf()) {
                return;
            }
            if (event.getPacketType() == PacketType.Play.Client.CREATIVE_INVENTORY_ACTION) {
                ItemStack item;
                int currentSlot;
                WrapperPlayClientCreativeInventoryAction wrapper = new WrapperPlayClientCreativeInventoryAction((PacketReceiveEvent)event);
                int slot = wrapper.getSlot();
                if (slot >= 5 && slot <= 8) {
                    if (disguise.isHidingArmorFromSelf()) {
                        int armorSlot = Math.abs(slot - 5 - 3);
                        ItemStack item2 = player.getInventory().getArmorContents()[armorSlot];
                        if (DisguiseUtilities.shouldBeHiddenSelfDisguise(item2) && item2.getType() != Material.ELYTRA) {
                            int stateId = NmsVersion.v1_17.isSupported() ? ReflectionManager.getIncrementedStateId(player) : 0;
                            WrapperPlayServerSetSlot packet = new WrapperPlayServerSetSlot(0, stateId, slot, com.github.retrooper.packetevents.protocol.item.ItemStack.EMPTY);
                            PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)player, (PacketWrapper)packet);
                        }
                    }
                } else if (slot >= 36 && slot <= 45 && disguise.isHidingHeldItemFromSelf() && (slot + 36 == (currentSlot = player.getInventory().getHeldItemSlot()) || slot == 45) && DisguiseUtilities.shouldBeHiddenSelfDisguise(item = player.getInventory().getItemInMainHand())) {
                    int stateId = NmsVersion.v1_17.isSupported() ? ReflectionManager.getIncrementedStateId(player) : 0;
                    WrapperPlayServerSetSlot packet = new WrapperPlayServerSetSlot(0, stateId, slot, com.github.retrooper.packetevents.protocol.item.ItemStack.EMPTY);
                    PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)player, (PacketWrapper)packet);
                }
            } else if (event.getPacketType() == PacketType.Play.Client.CLICK_WINDOW) {
                WrapperPlayClientClickWindow packet = new WrapperPlayClientClickWindow((PacketReceiveEvent)event);
                int slot = packet.getSlot();
                WrapperPlayClientClickWindow.WindowClickType type = packet.getWindowClickType();
                if (type == WrapperPlayClientClickWindow.WindowClickType.QUICK_MOVE) {
                    com.github.retrooper.packetevents.protocol.item.ItemStack clickedItem = packet.getCarriedItemStack();
                    if (clickedItem != null && !clickedItem.isEmpty()) {
                        Bukkit.getScheduler().runTask((Plugin)LibsDisguises.getInstance(), new Runnable(){

                            @Override
                            public void run() {
                                player.updateInventory();
                            }
                        });
                    }
                    return;
                }
                if (packet.getWindowId() != 0) {
                    return;
                }
                com.github.retrooper.packetevents.protocol.item.ItemStack clickedItem = DisguiseUtilities.fromBukkitItemStack(player.getItemOnCursor());
                if (DisguiseUtilities.shouldBeHiddenSelfDisguise(clickedItem) && clickedItem.getType() != ItemTypes.ELYTRA) {
                    int currentSlot;
                    if (slot >= 5 && slot <= 8) {
                        if (disguise.isHidingArmorFromSelf()) {
                            int stateId = NmsVersion.v1_17.isSupported() ? ReflectionManager.getIncrementedStateId(player) : 0;
                            WrapperPlayServerSetSlot newPacket = new WrapperPlayServerSetSlot(0, stateId, slot, com.github.retrooper.packetevents.protocol.item.ItemStack.EMPTY);
                            PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)player, (PacketWrapper)newPacket);
                        }
                    } else if (slot >= 36 && slot <= 45 && disguise.isHidingHeldItemFromSelf() && (slot == (currentSlot = player.getInventory().getHeldItemSlot()) + 36 || slot == 45)) {
                        int stateId = NmsVersion.v1_17.isSupported() ? ReflectionManager.getIncrementedStateId(player) : 0;
                        WrapperPlayServerSetSlot newPacket = new WrapperPlayServerSetSlot(0, stateId, slot, com.github.retrooper.packetevents.protocol.item.ItemStack.EMPTY);
                        PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)player, (PacketWrapper)newPacket);
                    }
                }
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            event.setCancelled(true);
        }
    }

    public void onPacketPlaySend(PacketPlaySendEvent event) {
        try {
            if (event.isCancelled()) {
                return;
            }
            if (event.getPacketType() != PacketType.Play.Server.SET_SLOT && event.getPacketType() != PacketType.Play.Server.WINDOW_ITEMS) {
                return;
            }
            Player player = (Player)event.getPlayer();
            if (player == null || player.getVehicle() != null) {
                return;
            }
            if (!DisguiseConfig.isHidingCreativeEquipmentFromSelf() && player.getGameMode() == GameMode.CREATIVE) {
                return;
            }
            Disguise disguise = DisguiseAPI.getDisguise(player, (Entity)player);
            if (disguise == null || !DisguiseUtilities.getSelfDisguised().contains(player.getUniqueId()) || !disguise.isHidingArmorFromSelf() && !disguise.isHidingHeldItemFromSelf()) {
                return;
            }
            if (event.getPacketType() == PacketType.Play.Server.SET_SLOT) {
                ItemStack item;
                int currentSlot;
                WrapperPlayServerSetSlot packet = new WrapperPlayServerSetSlot((PacketSendEvent)event);
                if (packet.getWindowId() != 0) {
                    return;
                }
                int slot = packet.getSlot();
                if (slot >= 5 && slot <= 8) {
                    if (disguise.isHidingArmorFromSelf()) {
                        int armorSlot = Math.abs(slot - 5 - 3);
                        ItemStack item2 = player.getInventory().getArmorContents()[armorSlot];
                        if (DisguiseUtilities.shouldBeHiddenSelfDisguise(item2) && item2.getType() != Material.ELYTRA) {
                            packet.setItem(com.github.retrooper.packetevents.protocol.item.ItemStack.EMPTY);
                            event.markForReEncode(true);
                        }
                    }
                } else if (slot >= 36 && slot <= 45 && disguise.isHidingHeldItemFromSelf() && (slot == (currentSlot = player.getInventory().getHeldItemSlot()) + 36 || slot == 45) && DisguiseUtilities.shouldBeHiddenSelfDisguise(item = player.getInventory().getItemInMainHand())) {
                    packet.setItem(com.github.retrooper.packetevents.protocol.item.ItemStack.EMPTY);
                    event.markForReEncode(true);
                }
            } else if (event.getPacketType() == PacketType.Play.Server.WINDOW_ITEMS) {
                WrapperPlayServerWindowItems packet = new WrapperPlayServerWindowItems((PacketSendEvent)event);
                if (packet.getWindowId() != 0) {
                    return;
                }
                List items = packet.getItems();
                for (int slot = 0; slot < items.size(); ++slot) {
                    int currentSlot;
                    ItemStack item;
                    if (slot >= 5 && slot <= 8) {
                        if (!disguise.isHidingArmorFromSelf()) continue;
                        int armorSlot = Math.abs(slot - 5 - 3);
                        item = player.getInventory().getArmorContents()[armorSlot];
                        if (!DisguiseUtilities.shouldBeHiddenSelfDisguise(item) || item.getType() == Material.ELYTRA) continue;
                        items.set(slot, com.github.retrooper.packetevents.protocol.item.ItemStack.EMPTY);
                        event.markForReEncode(true);
                        continue;
                    }
                    if (slot < 36 || slot > 45 || !disguise.isHidingHeldItemFromSelf() || slot != (currentSlot = player.getInventory().getHeldItemSlot()) + 36 && slot != 45 || !DisguiseUtilities.shouldBeHiddenSelfDisguise(item = player.getInventory().getItemInMainHand())) continue;
                    items.set(slot, com.github.retrooper.packetevents.protocol.item.ItemStack.EMPTY);
                    event.markForReEncode(true);
                }
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            event.setCancelled(true);
        }
    }
}

