/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.animations;

import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityAnimation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.AbstractHorseWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.AllayWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ArmorStandWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.DolphinWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.EggWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.EvokerFangsWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.FireworkWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.FishingHookWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.FoxWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.GoatWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.GuardianWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.HoglinWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.InsentientWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.IronGolemWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.MinecartSpawnerWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.MinecartTntWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.OcelotWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.PlayerWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.RabbitWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.RavagerWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SheepWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SnifferWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SnowballWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SquidWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.TameableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.TippedArrowWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.VillagerWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.WardenWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.WitchWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.WolfWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ZoglinWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieVillagerWatcher;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.jetbrains.annotations.Nullable;

public enum DisguiseAnimation {
    ALLAY_HEARTS(AllayWatcher.class, 18),
    ANIMAL_HEARTS(AgeableWatcher.class, 18),
    ARMORSTAND_HIT(ArmorStandWatcher.class, 32),
    CRITICAL_HIT((Class)LivingWatcher.class, -4){

        @Override
        @Nullable
        public WrapperPlayServerEntityAnimation.EntityAnimationType getAnimationType() {
            return WrapperPlayServerEntityAnimation.EntityAnimationType.CRITICAL_HIT;
        }
    }
    ,
    DEATH(LivingWatcher.class, 3),
    DEATH_PARTICLES(LivingWatcher.class, 60),
    DOLPHIN_HAPPY(DolphinWatcher.class, 38),
    EGG_PARTICLES(EggWatcher.class, 3),
    EVOKER_FANGS_SNAP(EvokerFangsWatcher.class, 4),
    FIREWORKS_EXPLOSION(FireworkWatcher.class, 17),
    FISHING_HOOK_DRAG(FishingHookWatcher.class, 31),
    FOX_CHEW(FoxWatcher.class, 45),
    GOAT_LOWER_HEAD(GoatWatcher.class, 58),
    GOAT_RAISE_HEAD(GoatWatcher.class, 59),
    GUARDIAN_ATTACK(GuardianWatcher.class, 21, AnimationType.NO_EFFECT),
    HOGLIN_ATTACK(HoglinWatcher.class, 4, AnimationType.ATTACK),
    HONEY(FlagWatcher.class, 53),
    HORSE_TAMING_FAILED(AbstractHorseWatcher.class, 6),
    HORSE_TAMING_SUCCESS(AbstractHorseWatcher.class, 7),
    HURT(LivingWatcher.class),
    IRON_GOLEM_ATTACK(IronGolemWatcher.class, 4, AnimationType.ATTACK),
    IRON_GOLEM_ROSE_START(IronGolemWatcher.class, 11),
    IRON_GOLEM_ROSE_STOP(IronGolemWatcher.class, 34),
    LIVING_HONEY(LivingWatcher.class, 54),
    MAGIC_CRITICAL_HIT(LivingWatcher.class){

        @Override
        @Nullable
        public WrapperPlayServerEntityAnimation.EntityAnimationType getAnimationType() {
            return WrapperPlayServerEntityAnimation.EntityAnimationType.MAGIC_CRITICAL_HIT;
        }
    }
    ,
    MINECART_SPAWNER_RESET_DELAY(MinecartSpawnerWatcher.class, 1),
    MINECART_TNT_IGNITE(MinecartTntWatcher.class, 10),
    MOB_SPAWN(InsentientWatcher.class, 20),
    OCELOT_TAMING_FAILED(OcelotWatcher.class, 40),
    OCELOT_TAMING_SUCCESS(OcelotWatcher.class, 41),
    PLAYER_BAD_OMEN_CLOUD(PlayerWatcher.class, 43, AnimationType.NO_EFFECT),
    PLAYER_DISABLE_REDUCED_DEBUG_SCREEN(PlayerWatcher.class, 23, AnimationType.NO_EFFECT),
    PLAYER_ENABLE_REDUCED_DEBUG_SCREEN(PlayerWatcher.class, 22, AnimationType.NO_EFFECT),
    PLAYER_ITEM_USED(PlayerWatcher.class, 9, AnimationType.NO_EFFECT),
    PORTAL(LivingWatcher.class, 46),
    RABBIT_HOP(RabbitWatcher.class, 1),
    RAVAGER_ATTACK(RavagerWatcher.class, 4, AnimationType.ATTACK),
    RAVAGER_STUNNED(RavagerWatcher.class, 39),
    SHEEP_EAT_GRASS(SheepWatcher.class, 10),
    SHIELD_BLOCK(LivingWatcher.class, 29, AnimationType.NO_EFFECT),
    SHIELD_BREAK(LivingWatcher.class, 30, AnimationType.NO_EFFECT),
    SNIFFER_DIG(SnifferWatcher.class, 63, AnimationType.NO_EFFECT),
    SNOWBALL_PARTICLES(SnowballWatcher.class, 3),
    SQUID_SWIM(SquidWatcher.class, 19),
    SWAP_HELD_ITEMS(LivingWatcher.class, 55, AnimationType.NO_EFFECT),
    SWING_MAIN_HAND(LivingWatcher.class){

        @Override
        @Nullable
        public WrapperPlayServerEntityAnimation.EntityAnimationType getAnimationType() {
            return WrapperPlayServerEntityAnimation.EntityAnimationType.SWING_MAIN_ARM;
        }
    }
    ,
    SWING_OFF_HAND(LivingWatcher.class){

        @Override
        @Nullable
        public WrapperPlayServerEntityAnimation.EntityAnimationType getAnimationType() {
            return WrapperPlayServerEntityAnimation.EntityAnimationType.SWING_OFF_HAND;
        }
    }
    ,
    TAMING_FAILED(TameableWatcher.class, 6),
    TAMING_SUCCESS(TameableWatcher.class, 7),
    TIPPED_ARROW_PARTICLES(TippedArrowWatcher.class, 0),
    TOTEM_UNDYING(LivingWatcher.class, 35),
    VILLAGER_ANGRY(VillagerWatcher.class, 13),
    VILLAGER_HAPPY(VillagerWatcher.class, 14),
    VILLAGER_HEART(VillagerWatcher.class, 12),
    VILLAGER_SPLASH(VillagerWatcher.class, 42),
    WARDEN_ATTACK(WardenWatcher.class, 4, AnimationType.ATTACK),
    WARDEN_SONIC_BOOM(WardenWatcher.class, 62),
    WARDEN_TENDRILS(WardenWatcher.class, 61),
    WITCH_MAGIC_PARTICLES(WitchWatcher.class, 15),
    WOLF_SHAKING_START(WolfWatcher.class, 8),
    WOLF_SHAKING_STOP(WolfWatcher.class, 56),
    ZOGLIN_ATTACK(ZoglinWatcher.class, 4, AnimationType.ATTACK),
    ZOMBIE_VILLAGER_CURED_SOUND(ZombieVillagerWatcher.class, 16);

    private static final Map<Class<? extends FlagWatcher>, List<DisguiseAnimation>> animationCache;
    private static final Map<Class<? extends FlagWatcher>, DisguiseAnimation> attackAnimations;
    private final Class<? extends FlagWatcher> watcher;
    private final int status;
    private final AnimationType type;

    private DisguiseAnimation(Class<? extends FlagWatcher> flagWatcher) {
        this(flagWatcher, -1, AnimationType.PACKET);
    }

    private DisguiseAnimation(Class<? extends FlagWatcher> flagWatcher, int status) {
        this(flagWatcher, status, AnimationType.VISIBLE_EFFECT);
    }

    private DisguiseAnimation(Class<? extends FlagWatcher> flagWatcher, int status, AnimationType animationType) {
        this.watcher = flagWatcher;
        this.status = status;
        this.type = animationType;
    }

    @Nullable
    public WrapperPlayServerEntityAnimation.EntityAnimationType getAnimationType() {
        return null;
    }

    public boolean isAttack() {
        return this.type == AnimationType.ATTACK;
    }

    public boolean isHidden() {
        return this.type == AnimationType.NO_EFFECT;
    }

    public boolean isFake() {
        return this.type == AnimationType.PACKET;
    }

    public boolean isUsable(DisguiseType disguiseType) {
        return this.isUseable(disguiseType.getWatcherClass());
    }

    public boolean isUseable(Class<? extends FlagWatcher> flagWatcher) {
        return DisguiseAnimation.getAnimations(flagWatcher).contains((Object)this);
    }

    public static List<DisguiseAnimation> getAnimations(DisguiseType disguiseType) {
        return DisguiseAnimation.getAnimations(disguiseType.getWatcherClass());
    }

    public static List<DisguiseAnimation> getAnimations(Class<? extends FlagWatcher> clss) {
        return animationCache.computeIfAbsent(clss, key -> {
            HashMap<Integer, DisguiseAnimation> bestAnimations = new HashMap<Integer, DisguiseAnimation>();
            int fakeCounter = -1;
            for (DisguiseAnimation animation : DisguiseAnimation.values()) {
                int id;
                DisguiseAnimation existing;
                if (!ReflectionManager.isAssignableFrom(animation.getWatcher(), clss) || (existing = (DisguiseAnimation)((Object)((Object)bestAnimations.get(id = animation.isFake() ? fakeCounter-- : animation.getStatus())))) != null && !ReflectionManager.isAssignableFrom(existing.getWatcher(), animation.getWatcher())) continue;
                bestAnimations.put(id, animation);
            }
            return Collections.unmodifiableList(new ArrayList(bestAnimations.values()));
        });
    }

    public static DisguiseAnimation getAttackAnimation(Class<? extends FlagWatcher> clss) {
        return attackAnimations.computeIfAbsent(clss, key -> DisguiseAnimation.getAnimations(clss).stream().filter(DisguiseAnimation::isAttack).findAny().orElse(null));
    }

    @Nullable
    public static DisguiseAnimation getAnimation(Class<? extends FlagWatcher> clss, int id) {
        return DisguiseAnimation.getAnimations(clss).stream().filter(animation -> animation.getStatus() == id).findAny().orElse(null);
    }

    @Generated
    public Class<? extends FlagWatcher> getWatcher() {
        return this.watcher;
    }

    @Generated
    public int getStatus() {
        return this.status;
    }

    @Generated
    private AnimationType getType() {
        return this.type;
    }

    static {
        animationCache = new HashMap<Class<? extends FlagWatcher>, List<DisguiseAnimation>>();
        attackAnimations = new HashMap<Class<? extends FlagWatcher>, DisguiseAnimation>();
    }

    private static enum AnimationType {
        ATTACK,
        PACKET,
        NO_EFFECT,
        VISIBLE_EFFECT;

    }
}

