/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.resources.ResourceLocation;
import com.github.retrooper.packetevents.util.Vector3d;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRelativeMove;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRotation;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityVelocity;
import java.util.List;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.BatWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.HangingWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.DisguiseValues;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.sounds.SoundGroup;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class DisguiseRunnable
extends BukkitRunnable {
    private int blockX;
    private int blockY;
    private int blockZ;
    private int facing;
    private int deadTicks = 0;
    private int actionBarTicks = -1;
    private int refreshRate;
    private long lastRefreshed = System.currentTimeMillis();
    private int ambientSoundTime;
    private SoundGroup ignoredSoundGroup;
    private final Disguise disguise;
    final Double vectorY;
    final boolean alwaysSendVelocity;

    public DisguiseRunnable(Disguise disguise) {
        this.disguise = disguise;
        switch (disguise.getType()) {
            case FIREWORK: 
            case WITHER_SKULL: 
            case EXPERIENCE_ORB: {
                this.vectorY = 1.0E-6;
                this.alwaysSendVelocity = true;
                break;
            }
            default: {
                this.vectorY = null;
                this.alwaysSendVelocity = false;
            }
        }
        switch (disguise.getType()) {
            case FIREWORK: 
            case EXPERIENCE_ORB: {
                this.refreshRate = 40;
                break;
            }
            case EVOKER_FANGS: {
                this.refreshRate = 23;
                break;
            }
        }
        this.refreshRate *= 50;
        this.resetAmbientSoundTime();
    }

    public void resetAmbientSoundTime() {
        DisguiseValues values = DisguiseValues.getDisguiseValues(this.disguise.getType());
        if (values == null) {
            return;
        }
        this.ambientSoundTime = -values.getAmbientSoundInterval();
    }

    private void playIdleSound() {
        ResourceLocation idleSound;
        if (!(this.disguise.isPlayIdleSounds() && this.disguise.isReplaceSounds() && this.disguise.getEntity().isValid())) {
            return;
        }
        if (DisguiseUtilities.getRandom().nextInt(1000) >= this.ambientSoundTime++) {
            return;
        }
        this.resetAmbientSoundTime();
        SoundGroup group = SoundGroup.getGroup(this.disguise);
        if (group == this.ignoredSoundGroup) {
            return;
        }
        if (group == null || (idleSound = group.getSound(SoundGroup.SoundType.IDLE)) == null) {
            this.ignoredSoundGroup = group;
            return;
        }
        float volume = group.getDamageAndIdleSoundVolume();
        float volumeSquared = volume * 256.0f;
        float pitch = 1.0f;
        if (this.disguise instanceof MobDisguise && ((MobDisguise)this.disguise).doesDisguiseAge()) {
            pitch = ((MobDisguise)this.disguise).isAdult() ? (DisguiseUtilities.random.nextFloat() - DisguiseUtilities.random.nextFloat()) * 0.2f + 1.0f : (DisguiseUtilities.random.nextFloat() - DisguiseUtilities.random.nextFloat()) * 0.2f + 1.4f;
        }
        Vector disgLoc = this.disguise.getEntity().getLocation().toVector();
        List<Player> toPlay = DisguiseUtilities.getTrackingPlayers(this.disguise);
        if (this.disguise.getEntity() instanceof Player && this.disguise.isSelfDisguiseVisible() && this.disguise.isHearSelfDisguise()) {
            toPlay.add((Player)this.disguise.getEntity());
        }
        for (Player player : toPlay) {
            double dist = player.getLocation().toVector().distance(disgLoc);
            if (dist > (double)volumeSquared) continue;
            player.playSound(this.disguise.getEntity().getLocation(), NmsVersion.v1_16.isSupported() ? idleSound.toString() : idleSound.getKey(), volume, pitch);
        }
    }

    private boolean isDead() {
        if (this.disguise.getEntity() instanceof Player && !((Player)this.disguise.getEntity()).isOnline()) {
            this.disguise.removeDisguise();
            return true;
        }
        if (this.disguise.disguiseExpires > 0L && (DisguiseConfig.isDynamicExpiry() ? this.disguise.disguiseExpires-- == 1L : this.disguise.disguiseExpires < System.currentTimeMillis())) {
            this.disguise.removeDisguise();
            if (this.disguise.getEntity() instanceof Player) {
                LibsMsg.EXPIRED_DISGUISE.send((CommandSender)this.disguise.getEntity(), new Object[0]);
            }
            return true;
        }
        if (!this.disguise.getEntity().isValid()) {
            if (this.deadTicks++ > (this.disguise.getType() == DisguiseType.ENDER_DRAGON ? 200 : 20) && this.disguise.isRemoveDisguiseOnDeath()) {
                this.disguise.removeDisguise();
            }
            return true;
        }
        return false;
    }

    public void run() {
        if (!this.disguise.isDisguiseInUse() || this.disguise.getEntity() == null || !Bukkit.getWorlds().contains(this.disguise.getEntity().getWorld())) {
            this.disguise.stopDisguise();
            if (!this.isCancelled()) {
                this.cancel();
            }
            return;
        }
        if (++this.actionBarTicks % 15 == 0) {
            this.actionBarTicks = 0;
            this.disguise.doPeriodicTick();
        }
        if (NmsVersion.v1_21_R5.isSupported() && this.disguise.getWatcher() instanceof HangingWatcher) {
            ((HangingWatcher)this.disguise.getWatcher()).updateHangingRotation();
        }
        if (this.isDead()) {
            return;
        }
        this.deadTicks = 0;
        this.playIdleSound();
        if (this.refreshRate > 0 && this.lastRefreshed + (long)this.refreshRate < System.currentTimeMillis()) {
            this.lastRefreshed = System.currentTimeMillis();
            DisguiseUtilities.refreshTrackers((TargetedDisguise)this.disguise);
        }
        if (this.disguise.isModifyBoundingBox()) {
            DisguiseUtilities.doBoundingBox((TargetedDisguise)this.disguise);
        }
        if (this.disguise.getType() == DisguiseType.BAT && !((BatWatcher)this.disguise.getWatcher()).isHanging()) {
            return;
        }
        this.doVelocity(this.vectorY, this.alwaysSendVelocity);
        if (this.disguise.getType() == DisguiseType.EXPERIENCE_ORB) {
            for (Player player : DisguiseUtilities.getTrackingPlayers(this.disguise)) {
                if (this.disguise.getEntity() != player) {
                    WrapperPlayServerEntityRelativeMove packet = new WrapperPlayServerEntityRelativeMove(this.disguise.getEntity().getEntityId(), 0.0, 0.0, 0.0, true);
                    PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)player, (PacketWrapper)packet);
                    continue;
                }
                if (!this.disguise.isSelfDisguiseVisible() || !(this.disguise.getEntity() instanceof Player)) continue;
                WrapperPlayServerEntityRelativeMove selfPacket = new WrapperPlayServerEntityRelativeMove(DisguiseAPI.getSelfDisguiseId(), 0.0, 0.0, 0.0, true);
                PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)player, (PacketWrapper)selfPacket);
            }
        }
    }

    private void doVelocity(Double vectorY, boolean alwaysSendVelocity) {
        if (vectorY == null || !this.disguise.isVelocitySent()) {
            return;
        }
        Entity entity = this.disguise.getEntity();
        if (!alwaysSendVelocity && entity.isOnGround()) {
            return;
        }
        Vector vector = entity.getVelocity();
        if (!(vector.getY() == 0.0 || vector.getY() < 0.0 && alwaysSendVelocity && entity.isOnGround())) {
            return;
        }
        if (this.disguise.getType() == DisguiseType.EXPERIENCE_ORB && entity.isOnGround()) {
            return;
        }
        WrapperPlayServerEntityRotation lookPacket = null;
        if (this.disguise.getType() == DisguiseType.WITHER_SKULL && DisguiseConfig.isWitherSkullPacketsEnabled()) {
            Location loc = entity.getLocation();
            float yaw = DisguiseUtilities.getYaw(this.disguise.getType(), entity.getType(), loc.getYaw());
            float pitch = DisguiseUtilities.getPitch(this.disguise.getType(), entity.getType(), loc.getPitch());
            lookPacket = new WrapperPlayServerEntityRotation(entity.getEntityId(), yaw, pitch, entity.isOnGround());
            if (this.disguise.isSelfDisguiseVisible() && entity instanceof Player) {
                WrapperPlayServerEntityRotation selfPacket = new WrapperPlayServerEntityRotation(DisguiseAPI.getSelfDisguiseId(), yaw, pitch, entity.isOnGround());
                PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)entity, (PacketWrapper)selfPacket);
            }
        }
        try {
            for (Player player : DisguiseUtilities.getTrackingPlayers(this.disguise)) {
                int entityId = entity.getEntityId();
                if (entity == player) {
                    if (!this.disguise.isSelfDisguiseVisible()) continue;
                    entityId = DisguiseAPI.getSelfDisguiseId();
                } else if (lookPacket != null) {
                    PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)player, (PacketWrapper)new WrapperPlayServerEntityRotation(lookPacket.getEntityId(), lookPacket.getYaw(), lookPacket.getPitch(), lookPacket.isOnGround()));
                }
                WrapperPlayServerEntityVelocity velocity = new WrapperPlayServerEntityVelocity(entityId, new Vector3d(vector.getX(), vectorY * ReflectionManager.getPing(player) * 0.069, vector.getZ()));
                PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)player, (PacketWrapper)velocity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

