/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.undisguise;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class UndisguisePlayerCommand
implements CommandExecutor,
TabCompleter {
    protected ArrayList<String> filterTabs(ArrayList<String> list, String[] origArgs) {
        if (origArgs.length == 0) {
            return list;
        }
        Iterator<String> itel = list.iterator();
        String label = origArgs[origArgs.length - 1].toLowerCase(Locale.ENGLISH);
        while (itel.hasNext()) {
            String name = itel.next();
            if (name.toLowerCase(Locale.ENGLISH).startsWith(label)) continue;
            itel.remove();
        }
        return list;
    }

    protected String[] getArgs(String[] args) {
        ArrayList<String> newArgs = new ArrayList<String>();
        for (int i = 0; i < args.length - 1; ++i) {
            String s = args[i];
            if (s.trim().isEmpty()) continue;
            newArgs.add(s);
        }
        return newArgs.toArray(new String[0]);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(!(sender instanceof Player) || sender.isOp() || LibsPremium.isPremium().booleanValue() && LibsPremium.getPaidInformation() != LibsPremium.getPluginInformation())) {
            sender.sendMessage(ChatColor.RED + "This is the free version of Lib's Disguises, player commands are limited to console and Operators only! Purchase the plugin for non-admin usage!");
            return true;
        }
        if (!sender.hasPermission("libsdisguises.undisguiseplayer")) {
            LibsMsg.NO_PERM.send(sender, new Object[0]);
            return true;
        }
        if (args.length == 0) {
            LibsMsg.UNDISG_PLAYER_HELP.send(sender, new Object[0]);
            return true;
        }
        Player entityTarget = Bukkit.getPlayer((String)args[0]);
        if (entityTarget == null && args[0].contains("-")) {
            try {
                entityTarget = Bukkit.getEntity((UUID)UUID.fromString(args[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (entityTarget == null) {
            LibsMsg.CANNOT_FIND_PLAYER.send(sender, args[0]);
            return true;
        }
        if (DisguiseAPI.isDisguised((Entity)entityTarget)) {
            DisguiseAPI.undisguiseToAll(sender, (Entity)entityTarget);
            LibsMsg.UNDISG_PLAYER.send(sender, entityTarget instanceof Player ? entityTarget.getName() : DisguiseType.getType((Entity)entityTarget).toReadable());
        } else {
            LibsMsg.NOT_DISGUISED_FAIL.send(sender, entityTarget instanceof Player ? entityTarget.getName() : DisguiseType.getType((Entity)entityTarget).toReadable());
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] origArgs) {
        ArrayList<String> tabs = new ArrayList<String>();
        String[] args = this.getArgs(origArgs);
        if (args.length != 0) {
            return this.filterTabs(tabs, origArgs);
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (sender instanceof Player && !((Player)sender).canSee(player)) continue;
            tabs.add(player.getName());
        }
        return this.filterTabs(tabs, origArgs);
    }
}

