/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.interactions;

import java.util.List;
import lombok.Generated;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.commands.animate.BaseDisguiseAnimate;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.LibsEntityInteract;
import me.libraryaddict.disguise.utilities.animations.DisguiseAnimation;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class DisguiseAnimateInteraction
extends BaseDisguiseAnimate
implements LibsEntityInteract {
    private String[] options;

    @Override
    public void onInteract(Player p, Entity entity) {
        Disguise disguise = DisguiseAPI.getDisguise(p, entity);
        if (disguise == null) {
            String entityName = entity instanceof Player ? entity.getName() : DisguiseType.getType(entity).toReadable();
            LibsMsg.NOT_DISGUISED_FAIL.send((CommandSender)p, entityName);
            return;
        }
        Disguise[] disguises = DisguiseAPI.getDisguises(entity);
        if (disguises.length == 0) {
            LibsMsg.TARGET_NOT_DISGUISED.send((CommandSender)p, new Object[0]);
            return;
        }
        List[] validAnimations = new List[disguises.length];
        for (int i = 0; i < disguises.length; ++i) {
            validAnimations[i] = DisguiseAnimation.getAnimations(disguises[i].getWatcher().getClass());
        }
        DisguiseAnimation[] animations = this.getAnimations((CommandSender)p, validAnimations, this.options);
        if (animations == null) {
            return;
        }
        for (int i = 0; i < disguises.length; ++i) {
            for (int animation = 0; animation < validAnimations.length; ++animation) {
                if (!validAnimations[i].contains((Object)animations[i])) continue;
                disguises[i].playAnimation(animations[animation]);
            }
        }
    }

    @Generated
    public DisguiseAnimateInteraction(String[] options) {
        this.options = options;
    }
}

