/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.animate;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.commands.animate.BaseDisguiseAnimate;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.animations.DisguiseAnimation;
import me.libraryaddict.disguise.utilities.params.ParamInfoManager;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisguiseAnimationCommand
extends BaseDisguiseAnimate
implements TabExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull @NotNull String @NotNull [] strings) {
        if (sender instanceof Player && !sender.isOp() && !LibsPremium.isPremium().booleanValue()) {
            sender.sendMessage(ChatColor.RED + "This is the free version of Lib's Disguises, player commands are limited to console and Operators only! Purchase the plugin for non-admin usage!");
            return true;
        }
        if (strings.length == 0) {
            List valid;
            LibsMsg.DISGUISE_ANIMATE_HELP_COMMAND.send(sender, s.toLowerCase(Locale.ENGLISH));
            List<Object> list = valid = sender instanceof Entity ? this.getSupported((Entity)sender) : Collections.emptyList();
            if (valid.isEmpty()) {
                LibsMsg.DISGUISE_ANIMATE_SEE_ALL_ANIMATIONS.send(sender, ParamInfoManager.getParamInfo(DisguiseAnimation.class).getName().replace(" ", ""));
            } else {
                LibsMsg.DISGUISE_ANIMATE_HELP_DISGUISED.send(sender, String.join((CharSequence)LibsMsg.DISGUISE_ANIMATE_HELP_DISGUISED_SEPERATOR.get(new Object[0]), valid));
            }
            return true;
        }
        Disguise[] disguises = DisguiseAPI.getDisguises((Entity)sender);
        if (disguises.length == 0) {
            LibsMsg.NOT_DISGUISED.send(sender, new Object[0]);
            return true;
        }
        List[] validAnimations = new List[disguises.length];
        for (int i = 0; i < disguises.length; ++i) {
            validAnimations[i] = DisguiseAnimation.getAnimations(disguises[i].getWatcher().getClass());
        }
        DisguiseAnimation[] animations = this.getAnimations(sender, validAnimations, strings);
        if (animations == null) {
            return true;
        }
        for (int i = 0; i < disguises.length; ++i) {
            for (int animation = 0; animation < validAnimations.length; ++animation) {
                if (!validAnimations[i].contains((Object)animations[i])) continue;
                disguises[i].playAnimation(animations[animation]);
            }
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull @NotNull String @NotNull [] strings) {
        if (!(commandSender instanceof Player)) {
            return Collections.emptyList();
        }
        Disguise[] disguises = DisguiseAPI.getDisguises((Entity)((Player)commandSender));
        if (disguises.length == 0) {
            return Collections.emptyList();
        }
        List<String> valid = this.getSupported((Entity)commandSender);
        if (strings.length > 0) {
            String lower = strings[strings.length - 1].toLowerCase(Locale.ENGLISH);
            valid.removeIf(arg -> !arg.toLowerCase(Locale.ENGLISH).startsWith(lower));
        }
        return valid;
    }
}

