/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.updates;

import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.plugin.LibsDisgInfo;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import me.libraryaddict.disguise.utilities.updates.DisguiseUpdate;
import me.libraryaddict.disguise.utilities.updates.LDGithub;
import me.libraryaddict.disguise.utilities.updates.LDJenkins;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class UpdateChecker {
    private final long started = System.currentTimeMillis();
    private LibsDisgInfo lastDownload;
    private final AtomicBoolean downloading = new AtomicBoolean(false);
    private DisguiseUpdate update;
    private final LDGithub githubUpdater = new LDGithub(this);
    private final LDJenkins jenkinsUpdater = new LDJenkins();
    private String[] updateMessage = new String[0];
    private boolean quiet;

    public static boolean isFancyPluginUpdating() {
        return DisguiseConfig.isDynamicFilenames() && ReflectionManager.isRunningPaper() && NmsVersion.v1_21_R3.isSupported();
    }

    public static void removeOtherJars(File downloadedJar, String pluginName) {
        if (!downloadedJar.isFile() || !downloadedJar.exists()) {
            throw new IllegalArgumentException("Expected provided reference '" + downloadedJar + "' to point at an existing File");
        }
        List<File> jarsWithPlugin = ReflectionManager.getFilesByPlugin(downloadedJar.getAbsoluteFile().getParentFile(), pluginName);
        for (File file : jarsWithPlugin) {
            if (file.getName().equals(downloadedJar.getName())) continue;
            LibsDisguises.getInstance().getLogger().info("Deleting duplicate jar " + file.getName());
            file.delete();
        }
    }

    public boolean isServerLatestVersion() {
        return this.isOnLatestUpdate(false);
    }

    public boolean isOnLatestUpdate(boolean includeDownloaded) {
        boolean isRelease;
        if (this.getUpdate() == null) {
            return false;
        }
        boolean bl = includeDownloaded && this.getLastDownload() != null ? !this.getLastDownload().getVersion().contains("-SNAPSHOT") : (isRelease = LibsDisguises.getInstance().isReleaseBuild());
        if (this.getUpdate().isReleaseBuild() != isRelease) {
            return false;
        }
        String version = this.getUpdate().isReleaseBuild() ? (this.lastDownload != null && includeDownloaded ? this.lastDownload.getVersion() : LibsDisguises.getInstance().getDescription().getVersion()) : (this.lastDownload != null && includeDownloaded ? this.lastDownload.getBuildNumber() : LibsDisguises.getInstance().getBuildNo());
        return this.getUpdate() != null && this.getUpdate().getVersion().equals(version);
    }

    public boolean isDownloading() {
        return this.downloading.get();
    }

    public boolean isOldUpdate() {
        return this.getUpdate() == null || this.getUpdate().getFetched().before(new Date(System.currentTimeMillis() - TimeUnit.HOURS.toMillis(1L)));
    }

    public boolean isUsingReleaseBuilds() {
        DisguiseConfig.UpdatesBranch builds = DisguiseConfig.getUpdatesBranch();
        return builds == DisguiseConfig.UpdatesBranch.RELEASES || builds == DisguiseConfig.UpdatesBranch.SAME_BUILDS && DisguiseConfig.isUsingReleaseBuild();
    }

    public void notifyUpdate(CommandSender player) {
        if (this.isQuiet() || !DisguiseConfig.isNotifyUpdate() || !player.hasPermission("libsdisguises.update")) {
            return;
        }
        if (this.updateMessage == null || this.updateMessage.length == 0) {
            return;
        }
        if (player instanceof Player) {
            player.sendMessage(this.updateMessage);
        } else {
            for (String s : this.updateMessage) {
                LibsDisguises.getInstance().getLogger().info(s);
            }
        }
    }

    public void doAutoUpdateCheck() {
        try {
            DisguiseUpdate oldUpdate = this.getUpdate();
            this.updateMessage = new String[0];
            boolean alreadySilent = this.isQuiet();
            this.doUpdateCheck();
            if (this.isOnLatestUpdate(true) || oldUpdate != null && oldUpdate.getVersion().equals(this.getUpdate().getVersion())) {
                return;
            }
            this.notifyUpdate((CommandSender)Bukkit.getConsoleSender());
            if (this.isQuiet() ? !alreadySilent : DisguiseConfig.isAutoUpdate()) {
                this.grabJarDownload(this.getUpdate().getDownload());
                this.notifyUpdate((CommandSender)Bukkit.getConsoleSender());
            }
            Bukkit.getScheduler().runTask((Plugin)LibsDisguises.getInstance(), () -> {
                for (Player p : Bukkit.getOnlinePlayers()) {
                    this.notifyUpdate((CommandSender)p);
                }
            });
        }
        catch (Exception ex) {
            LibsDisguises.getInstance().getLogger().warning(String.format("Failed to check for update: %s", ex.getMessage()));
        }
    }

    public LibsDisgInfo doUpdate() {
        if (this.getUpdate() == null || this.getUpdate().getFetched().before(new Date(System.currentTimeMillis() - TimeUnit.HOURS.toMillis(6L)))) {
            this.doUpdateCheck();
        }
        if (this.getUpdate() == null) {
            return null;
        }
        return this.grabJarDownload(this.getUpdate().getDownload());
    }

    public LibsMsg doUpdateCheck() {
        DisguiseConfig.setLastUpdateRequest(System.currentTimeMillis());
        DisguiseConfig.saveInternalConfig();
        this.downloading.set(true);
        try {
            this.update = null;
            this.update = this.isUsingReleaseBuilds() ? this.githubUpdater.getLatestRelease() : this.jenkinsUpdater.getLatestSnapshot();
        }
        finally {
            this.downloading.set(false);
        }
        if (this.getUpdate() == null) {
            return LibsMsg.UPDATE_FAILED;
        }
        if (this.getUpdate().isReleaseBuild()) {
            String currentVersion = LibsDisguises.getInstance().getDescription().getVersion();
            if (LibsDisguises.getInstance().isReleaseBuild() && !this.isNewerVersion(currentVersion, this.getUpdate().getVersion())) {
                return LibsMsg.UPDATE_ON_LATEST;
            }
            this.updateMessage = new String[]{LibsMsg.UPDATE_READY.get(currentVersion, this.getUpdate().getVersion()), LibsMsg.UPDATE_HOW.get(new Object[0])};
        } else {
            if (!this.getUpdate().getVersion().matches("\\d+")) {
                return LibsMsg.UPDATE_FAILED;
            }
            int newBuild = Integer.parseInt(this.getUpdate().getVersion());
            if (newBuild <= LibsDisguises.getInstance().getBuildNumber()) {
                return LibsMsg.UPDATE_ON_LATEST;
            }
            String build = LibsDisguises.getInstance().getBuildNo();
            this.updateMessage = new String[]{LibsMsg.UPDATE_READY_SNAPSHOT.get((build.matches("\\d+") ? "#" : "") + build, newBuild), LibsMsg.UPDATE_HOW.get(new Object[0])};
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LibsDisgInfo grabJarDownload(String urlString) {
        this.downloading.set(true);
        Bukkit.getUpdateFolderFile().mkdirs();
        File dest = new File(Bukkit.getUpdateFolderFile(), LibsDisguises.getInstance().getFile().getName());
        if (!this.isQuiet()) {
            LibsDisguises.getInstance().getLogger().info("Now downloading update for Lib's Disguises from " + urlString);
        }
        if (dest.exists()) {
            dest.delete();
        }
        try {
            LibsDisgInfo result;
            URL url = new URL(urlString);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setDefaultUseCaches(false);
            try (InputStream input = con.getInputStream();){
                Files.copy(input, dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            con.disconnect();
            UpdateChecker.removeOtherJars(dest, "LibsDisguises");
            if (!this.isQuiet()) {
                LibsDisguises.getInstance().getLogger().info("Download success!");
            }
            this.lastDownload = result = LibsPremium.getInformation(dest);
            this.updateMessage = new String[]{LibsMsg.UPDATE_SUCCESS.get(new Object[0]), LibsMsg.UPDATE_INFO.get(result.getVersion(), result.getBuildNumber(), result.getParsedBuildDate().toString(), result.getSize() / 1024L)};
            if (UpdateChecker.isFancyPluginUpdating() && result.getVersion() != null && result.getVersion().contains(".")) {
                String version = result.getVersion();
                File newName = new File(Bukkit.getUpdateFolderFile(), "LibsDisguises-" + version + ".jar");
                if (!newName.exists()) {
                    dest.renameTo(newName);
                    dest = newName;
                    if (!this.isQuiet()) {
                        LibsDisguises.getInstance().getLogger().info("LibsDisguises update saved to " + dest.getName());
                    }
                }
            }
            LibsDisgInfo libsDisgInfo = result;
            return libsDisgInfo;
        }
        catch (Exception ex) {
            dest.delete();
            LibsDisguises.getInstance().getLogger().warning("Failed to download update for LibsDisguises.");
            ex.printStackTrace();
        }
        finally {
            this.downloading.set(false);
        }
        return null;
    }

    private boolean isNewerVersion(String currentVersion, String newVersion) {
        int nVersion;
        int cVersion;
        currentVersion = currentVersion.replaceAll("(v)|(-SNAPSHOT)", "");
        newVersion = newVersion.replaceAll("(v)|(-SNAPSHOT)", "");
        if (this.started + TimeUnit.HOURS.toMillis(6L) > System.currentTimeMillis() && currentVersion.matches("\\d+(\\.\\d+)*") && newVersion.matches("\\d+(\\.\\d+)*") && (cVersion = Integer.parseInt(currentVersion.replace(".", ""))) > (nVersion = Integer.parseInt(newVersion.replace(".", ""))) && nVersion + 3 > cVersion) {
            return false;
        }
        return !currentVersion.equals(newVersion);
    }

    @Generated
    public LibsDisgInfo getLastDownload() {
        return this.lastDownload;
    }

    @Generated
    public DisguiseUpdate getUpdate() {
        return this.update;
    }

    @Generated
    public String[] getUpdateMessage() {
        return this.updateMessage;
    }

    @Generated
    public boolean isQuiet() {
        return this.quiet;
    }

    @Generated
    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }
}

