/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.plugin;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import lombok.Generated;

public class LibsDisgInfo {
    private final long size;
    private final String userID;
    private final String resourceID;
    private final String downloadID;
    private final boolean premium;
    private final String version;
    private final String buildNumber;
    private final String buildDate;

    public LibsDisgInfo(long size, String userID, String resourceID, String downloadID, boolean premium, String version, String buildNumber, String buildDate) {
        this.size = size;
        this.userID = userID;
        this.resourceID = resourceID;
        this.downloadID = downloadID;
        this.premium = premium;
        this.version = version;
        this.buildNumber = buildNumber;
        this.buildDate = buildDate;
    }

    public Date getParsedBuildDate() {
        try {
            return new SimpleDateFormat("dd/MM/yyyy HH:mm").parse(this.getBuildDate());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isPaid() {
        return !"12345".equals(this.getUserID()) && this.getResourceID().equals("32453") && this.getUserID().matches("\\d+") && this.getDownloadID().matches("-?\\d+");
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LibsDisgInfo that = (LibsDisgInfo)object;
        return this.premium == that.premium && Objects.equals(this.userID, that.userID) && Objects.equals(this.resourceID, that.resourceID) && Objects.equals(this.downloadID, that.downloadID) && Objects.equals(this.version, that.version) && Objects.equals(this.buildNumber, that.buildNumber) && Objects.equals(this.buildDate, that.buildDate);
    }

    @Generated
    public long getSize() {
        return this.size;
    }

    @Generated
    public String getUserID() {
        return this.userID;
    }

    @Generated
    public String getResourceID() {
        return this.resourceID;
    }

    @Generated
    public String getDownloadID() {
        return this.downloadID;
    }

    @Generated
    public boolean isPremium() {
        return this.premium;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getBuildNumber() {
        return this.buildNumber;
    }

    @Generated
    public String getBuildDate() {
        return this.buildDate;
    }
}

