/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.config;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.config.ConfigMigrator;
import me.libraryaddict.disguise.utilities.reflection.ClassGetter;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigLoader {
    private final List<String> configs = new ArrayList<String>();

    public ConfigLoader() {
        for (String s : ClassGetter.getEntriesForPackage(ConfigLoader.class, "configs")) {
            if (!s.endsWith(".yml") || s.endsWith("/disguises.yml") || s.endsWith("/sounds.yml")) continue;
            this.configs.add(s);
        }
        new ConfigMigrator().runMigrations();
    }

    public void saveMissingConfigs() {
        for (String config : this.configs) {
            File f = new File(LibsDisguises.getInstance().getDataFolder(), config);
            if (f.exists()) continue;
            this.saveDefaultConfig(config);
        }
    }

    private YamlConfiguration loadDefaults(List<String> configs) {
        YamlConfiguration globalConfig = new YamlConfiguration();
        for (String config : configs) {
            try {
                YamlConfiguration c = new YamlConfiguration();
                c.loadFromString(ReflectionManager.getResourceAsString(LibsDisguises.getInstance().getFile(), config));
                for (String k : c.getKeys(true)) {
                    if (c.isConfigurationSection(k)) continue;
                    globalConfig.set(k, c.get(k));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return globalConfig;
    }

    public YamlConfiguration loadDefaults() {
        return this.loadDefaults(this.configs);
    }

    public YamlConfiguration load() {
        return this.load(this.configs);
    }

    public YamlConfiguration load(List<String> configNames) {
        YamlConfiguration globalConfig = new YamlConfiguration();
        for (String config : configNames) {
            YamlConfiguration c = YamlConfiguration.loadConfiguration((File)new File(LibsDisguises.getInstance().getDataFolder(), config));
            for (String k : c.getKeys(true)) {
                if (c.isConfigurationSection(k)) continue;
                globalConfig.set(k, c.get(k));
            }
        }
        return globalConfig;
    }

    public boolean isOutdated(String config) {
        File file;
        if (!config.startsWith("configs/")) {
            config = "configs/" + config;
        }
        if (!(file = new File(LibsDisguises.getInstance().getDataFolder(), config)).exists()) {
            return true;
        }
        try {
            YamlConfiguration savedConfig = YamlConfiguration.loadConfiguration((File)file);
            String ourConfig = ReflectionManager.getResourceAsString(LibsDisguises.getInstance().getFile(), config);
            YamlConfiguration internalConfig = new YamlConfiguration();
            internalConfig.loadFromString(ourConfig);
            for (String key : internalConfig.getKeys(true)) {
                if (internalConfig.isConfigurationSection(key) || savedConfig.isSet(key)) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return true;
        }
    }

    public void saveDefaultConfigs() {
        for (String config : this.configs) {
            if (!this.isOutdated(config)) continue;
            this.saveDefaultConfig(config);
        }
    }

    public void saveDefaultConfig(String configName) {
        File loadFrom = new File(LibsDisguises.getInstance().getDataFolder(), configName);
        YamlConfiguration savedConfig = null;
        String neatName = configName.replace("configs/", "");
        if (loadFrom.exists()) {
            LibsDisguises.getInstance().getLogger().info("Updating config " + neatName + " with missing entries.");
            savedConfig = YamlConfiguration.loadConfiguration((File)loadFrom);
        } else {
            LibsDisguises.getInstance().getLogger().info("Saving default config " + neatName);
        }
        ConfigLoader.saveConfig(savedConfig, configName);
    }

    static void saveConfig(YamlConfiguration savedConfig, String configName) {
        if (!configName.startsWith("configs/")) {
            configName = "configs/" + configName;
        }
        String ourConfig = ReflectionManager.getResourceAsString(LibsDisguises.getInstance().getFile(), configName);
        if (savedConfig == null) {
            try {
                savedConfig = new YamlConfiguration();
                savedConfig.loadFromString(ourConfig);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        ArrayList<String> strings = new ArrayList<String>();
        String[] string = ourConfig.split("\n");
        boolean loadingList = false;
        boolean useInternalList = false;
        StringBuilder section = new StringBuilder();
        for (String s : string) {
            String key;
            if (s.trim().startsWith("-") && loadingList) {
                if (!useInternalList) continue;
                strings.add(s);
                continue;
            }
            if (loadingList) {
                loadingList = false;
            }
            if (s.trim().startsWith("#") || !s.contains(":") || s.trim().startsWith("-")) {
                strings.add(s);
                continue;
            }
            String rawKey = s.split(":")[0];
            if (section.length() > 0) {
                int matches = StringUtils.countMatches((String)rawKey, (String)"  ");
                int allowed = 0;
                for (int a = 0; a < matches; ++a) {
                    allowed = section.indexOf(".", allowed) + 1;
                }
                section = new StringBuilder(section.substring(0, allowed));
            }
            if (savedConfig.isConfigurationSection(key = (rawKey.startsWith(" ") ? section.toString() : "") + rawKey.trim())) {
                section.append(key).append(".");
            } else {
                if (savedConfig.isList(key)) {
                    strings.add(s);
                    loadingList = true;
                    boolean bl = useInternalList = !savedConfig.isSet(key);
                    if (useInternalList) continue;
                    for (String a : savedConfig.getStringList(key)) {
                        strings.add(rawKey.substring(0, Math.max(0, rawKey.indexOf(" ") + 1)) + "  - " + a);
                    }
                    continue;
                }
                if (savedConfig.isSet(key)) {
                    String rawVal = s.split(":")[1].trim();
                    Object val = savedConfig.get(key);
                    if (savedConfig.isString(key) && !rawVal.equals("true") && !rawVal.equals("false")) {
                        val = "'" + StringEscapeUtils.escapeJava((String)val.toString().replace("\u00a7", "&")) + "'";
                    }
                    s = rawKey + ": " + val;
                }
            }
            strings.add(s);
        }
        File configFile = new File(LibsDisguises.getInstance().getDataFolder(), configName);
        try {
            if (!configFile.getParentFile().exists()) {
                configFile.mkdirs();
            }
            configFile.delete();
            configFile.createNewFile();
            try (PrintWriter out = new PrintWriter(configFile);){
                out.write(String.join((CharSequence)"\n", strings));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Generated
    public List<String> getConfigs() {
        return this.configs;
    }
}

