/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.github.retrooper.packetevents.protocol.entity.wolfvariant.WolfSoundVariant;
import com.github.retrooper.packetevents.protocol.entity.wolfvariant.WolfSoundVariants;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.AnimalColor;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.TameableWatcher;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.reflection.annotations.MethodDescription;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsAddedIn;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsRemovedIn;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.entity.Wolf;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public class WolfWatcher
extends TameableWatcher {
    public WolfWatcher(Disguise disguise) {
        super(disguise);
        if (DisguiseConfig.isRandomDisguises() && NmsVersion.v1_20_R4.isSupported()) {
            this.setVariant(ReflectionManager.randomEnum(Wolf.Variant.class));
            if (NmsVersion.v1_21_R4.isSupported()) {
                this.setSoundVariant((WolfSoundVariant)ReflectionManager.randomRegistry(WolfSoundVariants.getRegistry()));
            }
        }
    }

    @NmsAddedIn(value=NmsVersion.v1_21_R4)
    public WolfSoundVariant getSoundVariant() {
        return this.getData(MetaIndex.WOLF_SOUND_VARIANT);
    }

    @RandomDefaultValue
    @NmsAddedIn(value=NmsVersion.v1_21_R4)
    @MethodDescription(value="The sound a wolf makes")
    public void setSoundVariant(WolfSoundVariant soundVariant) {
        this.sendData(MetaIndex.WOLF_SOUND_VARIANT, soundVariant);
    }

    public DyeColor getCollarColor() {
        return this.getData(MetaIndex.WOLF_COLLAR).getDyeColor();
    }

    @Deprecated
    public void setCollarColor(AnimalColor color) {
        this.setCollarColor(color.getDyeColor());
    }

    @MethodDescription(value="The color of the wolf's collar")
    public void setCollarColor(DyeColor newColor) {
        if (!this.isTamed()) {
            this.setTamed(true);
        }
        if (this.hasValue(MetaIndex.WOLF_COLLAR) && newColor == this.getCollarColor()) {
            return;
        }
        this.sendData(MetaIndex.WOLF_COLLAR, AnimalColor.getColorByWool(newColor.getWoolData()));
    }

    public boolean isBegging() {
        return this.getData(MetaIndex.WOLF_BEGGING);
    }

    public void setBegging(boolean begging) {
        this.sendData(MetaIndex.WOLF_BEGGING, begging);
    }

    public boolean isAngry() {
        if (!NmsVersion.v1_16.isSupported()) {
            return this.isTameableFlag(2);
        }
        return this.getAnger() > 0;
    }

    @MethodDescription(value="If the wolf should look angry")
    public void setAngry(boolean angry) {
        if (!NmsVersion.v1_16.isSupported()) {
            this.setTameableFlag(2, angry);
        } else {
            this.setAnger(angry ? 1 : 0);
        }
    }

    @NmsAddedIn(value=NmsVersion.v1_16)
    public int getAnger() {
        return this.getData(MetaIndex.WOLF_ANGER);
    }

    @NmsAddedIn(value=NmsVersion.v1_16)
    public void setAnger(int anger) {
        this.sendData(MetaIndex.WOLF_ANGER, anger);
    }

    @NmsRemovedIn(value=NmsVersion.v1_15)
    @Deprecated
    public float getDamageTaken() {
        return this.getData(MetaIndex.WOLF_DAMAGE).floatValue();
    }

    @Deprecated
    @NmsRemovedIn(value=NmsVersion.v1_15)
    @MethodDescription(value="Controls the angle of the wolf's tail")
    public void setDamageTaken(float damage) {
        this.sendData(MetaIndex.WOLF_DAMAGE, Float.valueOf(damage));
    }

    @RandomDefaultValue
    @NmsAddedIn(value=NmsVersion.v1_20_R4)
    @MethodDescription(value="The variant that controls the wolf's appearance")
    public void setVariant(Wolf.Variant variant) {
        this.sendData(MetaIndex.WOLF_VARIANT, variant);
    }

    @NmsAddedIn(value=NmsVersion.v1_20_R4)
    public Wolf.Variant getVariant() {
        return this.getData(MetaIndex.WOLF_VARIANT);
    }

    @NmsAddedIn(value=NmsVersion.v1_20_R4)
    public ItemStack getWolfArmor() {
        return this.getEquipment().getItem(EquipmentSlot.BODY);
    }

    @NmsAddedIn(value=NmsVersion.v1_20_R4)
    @MethodDescription(value="The item that renders as the wolf's armor, only a certain subset of items will display")
    public void setWolfArmor(ItemStack item) {
        this.getEquipment().setItem(EquipmentSlot.BODY, item);
    }

    @NmsAddedIn(value=NmsVersion.v1_20_R4)
    public Color getWolfArmorColor() {
        ItemStack item = this.getWolfArmor();
        if (item == null || item.getType() != Material.WOLF_ARMOR) {
            return null;
        }
        return ((LeatherArmorMeta)item.getItemMeta()).getColor();
    }

    @NmsAddedIn(value=NmsVersion.v1_20_R4)
    @MethodDescription(value="The color the wolf's armor will be dyed to, if null, armor will also be treated as null")
    public void setWolfArmorColor(Color color) {
        if (color == null) {
            this.setWolfArmor(null);
            return;
        }
        ItemStack item = this.getWolfArmor();
        if (item == null || item.getType() != Material.WOLF_ARMOR) {
            item = new ItemStack(Material.WOLF_ARMOR);
        }
        LeatherArmorMeta meta = (LeatherArmorMeta)item.getItemMeta();
        meta.setColor(color);
        item.setItemMeta((ItemMeta)meta);
        this.setWolfArmor(item);
    }
}

