/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import com.github.retrooper.packetevents.protocol.world.states.type.StateType;
import com.github.retrooper.packetevents.protocol.world.states.type.StateTypes;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRelativeMove;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import lombok.Generated;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.DisplayWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.GridLockedWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import me.libraryaddict.disguise.utilities.reflection.annotations.MethodDescription;
import me.libraryaddict.disguise.utilities.reflection.annotations.MethodMappedAs;
import org.bukkit.Location;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.joml.Vector3f;

public class BlockDisplayWatcher
extends DisplayWatcher
implements GridLockedWatcher {
    private boolean autoCenter = true;
    private boolean gridLocked;

    public BlockDisplayWatcher(Disguise disguise) {
        super(disguise);
        this.setBlockState(WrappedBlockState.getDefaultState((StateType)StateTypes.STONE));
        this.adjustCenter();
    }

    @Override
    public BlockDisplayWatcher clone(Disguise owningDisguise) {
        BlockDisplayWatcher displayWatcher = (BlockDisplayWatcher)super.clone(owningDisguise);
        displayWatcher.setAutoCentered(this.autoCenter);
        return displayWatcher;
    }

    @MethodMappedAs(value="getBlock")
    public WrappedBlockState getBlockState() {
        return this.getData(MetaIndex.BLOCK_DISPLAY_BLOCK_STATE);
    }

    @MethodDescription(value="What block can players see?")
    @MethodMappedAs(value="setBlock")
    public void setBlockState(WrappedBlockState block) {
        this.sendData(MetaIndex.BLOCK_DISPLAY_BLOCK_STATE, block);
        DisguiseParser.updateDisguiseName(this.getDisguise());
    }

    public BlockData getBlock() {
        return SpigotConversionUtil.toBukkitBlockData((WrappedBlockState)this.getData(MetaIndex.BLOCK_DISPLAY_BLOCK_STATE));
    }

    public void setBlock(BlockData block) {
        this.sendData(MetaIndex.BLOCK_DISPLAY_BLOCK_STATE, SpigotConversionUtil.fromBukkitBlockData((BlockData)block));
        DisguiseParser.updateDisguiseName(this.getDisguise());
    }

    public boolean isAutoCentered() {
        return this.autoCenter;
    }

    public void setAutoCentered(boolean autoCenter) {
        this.autoCenter = autoCenter;
        this.adjustCenter();
    }

    @Override
    @RandomDefaultValue
    public void setTranslation(Vector3f translation) {
        super.setTranslation(translation);
        Vector3f scale = this.getScale();
        if (translation.y() == 0.0f && translation.x() == -scale.x() / 2.0f && translation.z() == -scale.z() / 2.0f) {
            return;
        }
        this.setAutoCentered(false);
    }

    @Override
    public Vector3f getTranslation() {
        return super.getTranslation();
    }

    private void adjustCenter() {
        if (!this.isAutoCentered()) {
            return;
        }
        Vector3f scale = this.getScale();
        Vector3f oldTranslation = this.getTranslation();
        Vector3f newTranslation = new Vector3f(-scale.x() / 2.0f, 0.0f, -scale.z() / 2.0f);
        if (oldTranslation.x() == newTranslation.x() && oldTranslation.y() == newTranslation.y() && oldTranslation.z() == newTranslation.z()) {
            return;
        }
        this.setTranslation(newTranslation);
    }

    @Override
    public Vector3f getScale() {
        return super.getScale();
    }

    @Override
    public void setScale(Vector3f scale) {
        super.setScale(scale);
        this.adjustCenter();
    }

    @Override
    public void setGridLocked(boolean gridLocked) {
        if (this.isGridLocked() == gridLocked) {
            return;
        }
        this.gridLocked = gridLocked;
        if (!this.getDisguise().isDisguiseInUse() || this.getDisguise().getEntity() == null) {
            return;
        }
        Location loc = this.getDisguise().getEntity().getLocation();
        double centerX = GridLockedWatcher.center(loc.getX(), this.getWidthX());
        double centerY = (double)loc.getBlockY() + (loc.getY() % 1.0 >= 0.85 ? 1.0 : (loc.getY() % 1.0 >= 0.35 ? 0.5 : 0.0));
        double centerZ = GridLockedWatcher.center(loc.getZ(), this.getWidthZ());
        double x = this.conRel(loc.getX(), centerX);
        double y = this.conRel(loc.getY(), centerY);
        double z = this.conRel(loc.getZ(), centerZ);
        for (Player player : DisguiseUtilities.getTrackingPlayers(this.getDisguise())) {
            int entityId = this.getDisguise().getEntity() == player ? DisguiseAPI.getSelfDisguiseId() : this.getDisguise().getEntity().getEntityId();
            WrapperPlayServerEntityRelativeMove relMov = new WrapperPlayServerEntityRelativeMove(entityId, x, y, z, true);
            if (this.isGridLocked()) {
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)relMov);
                continue;
            }
            PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)player, (PacketWrapper)relMov);
        }
    }

    private short conRel(double oldCord, double newCord) {
        return (short)((oldCord - newCord) * 4096.0 * (double)(this.isGridLocked() ? -1 : 1));
    }

    @Override
    public double getWidthX() {
        return this.getScale().x;
    }

    @Override
    public double getWidthZ() {
        return this.getScale().z;
    }

    @Override
    @Generated
    public boolean isGridLocked() {
        return this.gridLocked;
    }
}

