/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.mineskin.models.structures;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.UUID;
import java.util.regex.Pattern;
import lombok.Generated;
import me.libraryaddict.disguise.utilities.mineskin.models.structures.SkinVariant;
import me.libraryaddict.disguise.utilities.mineskin.models.structures.SkinVisibility;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.Nullable;

public class MineSkinSkin {
    private String uuid;
    private String name;
    private SkinVisibility visibility;
    private SkinVariant variant;
    private Texture texture;
    private Generator generator;
    private long views;
    private boolean duplicate;

    public GameProfile getGameProfile() {
        String id = this.getUuid();
        if (!id.contains("-")) {
            id = Pattern.compile("([\\da-fA-F]{8})([\\da-fA-F]{4})([\\da-fA-F]{4})([\\da-fA-F]{4})([\\da-fA-F]+)").matcher(id).replaceFirst("$1-$2-$3-$4-$5");
        }
        GameProfile profile = new GameProfile(UUID.fromString(id), StringUtils.stripToNull((String)this.getName()) == null ? "Unknown" : this.getName());
        if (this.getTexture() != null && this.getTexture().getData() != null) {
            Property property = new Property("textures", this.getTexture().getData().getValue(), this.getTexture().getData().getSignature());
            profile.getProperties().put((Object)"textures", (Object)property);
        }
        return profile;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public SkinVisibility getVisibility() {
        return this.visibility;
    }

    @Generated
    public SkinVariant getVariant() {
        return this.variant;
    }

    @Generated
    public Texture getTexture() {
        return this.texture;
    }

    @Generated
    public Generator getGenerator() {
        return this.generator;
    }

    @Generated
    public long getViews() {
        return this.views;
    }

    @Generated
    public boolean isDuplicate() {
        return this.duplicate;
    }

    public static class Texture {
        private TextureData data;
        private TextureHash hash;
        private TextureUrl url;

        @Generated
        public TextureData getData() {
            return this.data;
        }

        @Generated
        public TextureHash getHash() {
            return this.hash;
        }

        @Generated
        public TextureUrl getUrl() {
            return this.url;
        }

        public static class TextureData {
            private String value;
            private String signature;

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public String getSignature() {
                return this.signature;
            }
        }

        public static class TextureHash {
            private String skin;
            @Nullable
            private String cape;

            @Generated
            public String getSkin() {
                return this.skin;
            }

            @Nullable
            @Generated
            public String getCape() {
                return this.cape;
            }
        }

        public static class TextureUrl {
            private String skin;
            @Nullable
            private String cape;

            @Generated
            public String getSkin() {
                return this.skin;
            }

            @Nullable
            @Generated
            public String getCape() {
                return this.cape;
            }
        }
    }

    public static class Generator {
        private String version;
        private long timestamp;
        private long duration;
        private String account;
        private String server;

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public long getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public long getDuration() {
            return this.duration;
        }

        @Generated
        public String getAccount() {
            return this.account;
        }

        @Generated
        public String getServer() {
            return this.server;
        }
    }
}

