/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.github.retrooper.packetevents.protocol.entity.villager.VillagerData;
import com.github.retrooper.packetevents.protocol.entity.villager.profession.VillagerProfessions;
import com.github.retrooper.packetevents.protocol.entity.villager.type.VillagerTypes;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieWatcher;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.reflection.annotations.MethodDescription;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsAddedIn;
import org.bukkit.entity.Villager;

public class ZombieVillagerWatcher
extends ZombieWatcher {
    public ZombieVillagerWatcher(Disguise disguise) {
        super(disguise);
        if (DisguiseConfig.isRandomDisguises()) {
            this.setProfession(ReflectionManager.randomEnum(Villager.Profession.class));
        }
    }

    public boolean isShaking() {
        return this.getData(MetaIndex.ZOMBIE_VILLAGER_SHAKING);
    }

    @MethodDescription(value="If the Zombie Villager is shaking, this normally happens during the 'curing' processes")
    public void setShaking(boolean shaking) {
        this.sendData(MetaIndex.ZOMBIE_VILLAGER_SHAKING, shaking);
    }

    public boolean isVillager() {
        if (NmsVersion.v1_14.isSupported()) {
            return this.getData(MetaIndex.ZOMBIE_VILLAGER_PROFESSION).getProfession() != VillagerProfessions.NONE;
        }
        return this.getData(MetaIndex.ZOMBIE_VILLAGER_PROFESSION_OLD) != 0;
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public VillagerData getVillagerData() {
        return this.getData(MetaIndex.ZOMBIE_VILLAGER_PROFESSION);
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    @RandomDefaultValue
    @MethodDescription(value="The villager data that is displayed")
    public void setVillagerData(VillagerData villagerData) {
        this.sendData(MetaIndex.ZOMBIE_VILLAGER_PROFESSION, villagerData);
    }

    public Villager.Profession getProfession() {
        if (NmsVersion.v1_14.isSupported()) {
            return ReflectionManager.fromEnum(Villager.Profession.class, this.getVillagerData().getProfession().getName().getKey());
        }
        return ReflectionManager.fromEnum(Villager.Profession.class, this.getData(MetaIndex.ZOMBIE_VILLAGER_PROFESSION_OLD) + 1);
    }

    @RandomDefaultValue
    @MethodDescription(value="The profession of the villager")
    public void setProfession(Villager.Profession profession) {
        if (NmsVersion.v1_14.isSupported()) {
            this.setVillagerData(new VillagerData(VillagerTypes.getByName((String)ReflectionManager.keyedName(this.getType())), VillagerProfessions.getByName((String)ReflectionManager.keyedName(profession)), this.getLevel()));
        } else {
            this.sendData(MetaIndex.ZOMBIE_VILLAGER_PROFESSION_OLD, ReflectionManager.enumOrdinal(profession) - 1);
        }
    }

    @Deprecated
    @NmsAddedIn(value=NmsVersion.v1_14)
    public Villager.Type getType() {
        return ReflectionManager.fromEnum(Villager.Type.class, this.getVillagerData().getType().getName().getKey());
    }

    @Deprecated
    @NmsAddedIn(value=NmsVersion.v1_14)
    public void setType(Villager.Type type) {
        this.setVillagerData(new VillagerData(VillagerTypes.getByName((String)ReflectionManager.keyedName(type)), VillagerProfessions.getByName((String)ReflectionManager.keyedName(this.getProfession())), this.getLevel()));
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public Villager.Type getBiome() {
        return this.getType();
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    @MethodDescription(value="The villager biome variant")
    public void setBiome(Villager.Type type) {
        this.setType(type);
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public int getLevel() {
        return this.getVillagerData().getLevel();
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    @MethodDescription(value="The villager level shown")
    public void setLevel(int level) {
        this.setVillagerData(new VillagerData(VillagerTypes.getByName((String)ReflectionManager.keyedName(this.getType())), VillagerProfessions.getByName((String)ReflectionManager.keyedName(this.getProfession())), Math.max(1, Math.min(5, level))));
    }
}

