/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.github.retrooper.packetevents.protocol.entity.villager.VillagerData;
import com.github.retrooper.packetevents.protocol.entity.villager.profession.VillagerProfessions;
import com.github.retrooper.packetevents.protocol.entity.villager.type.VillagerTypes;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.AbstractVillagerWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsAddedIn;
import org.bukkit.entity.Villager;

public class VillagerWatcher
extends AbstractVillagerWatcher {
    public VillagerWatcher(Disguise disguise) {
        super(disguise);
        if (DisguiseConfig.isRandomDisguises()) {
            this.setProfession(ReflectionManager.randomEnum(Villager.Profession.class));
            if (NmsVersion.v1_14.isSupported()) {
                this.setBiome(ReflectionManager.randomEnum(Villager.Type.class));
                this.setLevel(DisguiseUtilities.random.nextInt(5) + 1);
            }
        }
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public VillagerData getVillagerData() {
        return this.getData(MetaIndex.VILLAGER_DATA);
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public void setVillagerData(VillagerData villagerData) {
        this.sendData(MetaIndex.VILLAGER_DATA, villagerData);
    }

    public Villager.Profession getProfession() {
        if (!NmsVersion.v1_14.isSupported()) {
            return ReflectionManager.fromEnum(Villager.Profession.class, this.getData(MetaIndex.VILLAGER_PROFESSION) + 1);
        }
        return ReflectionManager.fromEnum(Villager.Profession.class, this.getVillagerData().getProfession().getName().toString());
    }

    @RandomDefaultValue
    public void setProfession(Villager.Profession profession) {
        if (NmsVersion.v1_14.isSupported()) {
            this.setVillagerData(new VillagerData(VillagerTypes.getByName((String)ReflectionManager.keyedName(this.getType())), VillagerProfessions.getByName((String)ReflectionManager.keyedName(profession)), this.getLevel()));
        } else {
            this.sendData(MetaIndex.VILLAGER_PROFESSION, ReflectionManager.enumOrdinal(profession) - 1);
        }
    }

    @Deprecated
    @NmsAddedIn(value=NmsVersion.v1_14)
    public Villager.Type getType() {
        return ReflectionManager.fromEnum(Villager.Type.class, this.getVillagerData().getType().getName().getKey());
    }

    @Deprecated
    @NmsAddedIn(value=NmsVersion.v1_14)
    public void setType(Villager.Type type) {
        this.setVillagerData(new VillagerData(VillagerTypes.getByName((String)ReflectionManager.keyedName(type)), VillagerProfessions.getByName((String)ReflectionManager.keyedName(this.getProfession())), this.getLevel()));
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public Villager.Type getBiome() {
        return this.getType();
    }

    @RandomDefaultValue
    @NmsAddedIn(value=NmsVersion.v1_14)
    public void setBiome(Villager.Type type) {
        this.setType(type);
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public int getLevel() {
        return this.getVillagerData().getLevel();
    }

    @RandomDefaultValue
    @NmsAddedIn(value=NmsVersion.v1_14)
    public void setLevel(int level) {
        this.setVillagerData(new VillagerData(VillagerTypes.getByName((String)ReflectionManager.keyedName(this.getType())), VillagerProfessions.getByName((String)ReflectionManager.keyedName(this.getProfession())), Math.max(1, Math.min(5, level))));
    }
}

