/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.placeholderapi;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.libraryaddict.disguise.utilities.placeholderapi.DPlaceholder;
import me.libraryaddict.disguise.utilities.placeholderapi.PlaceholderDisguiseFlag;
import me.libraryaddict.disguise.utilities.placeholderapi.PlaceholderDisguiseHeight;
import me.libraryaddict.disguise.utilities.placeholderapi.PlaceholderDisguiseMaterial;
import me.libraryaddict.disguise.utilities.placeholderapi.PlaceholderDisguiseName;
import me.libraryaddict.disguise.utilities.placeholderapi.PlaceholderDisguiseSkin;
import me.libraryaddict.disguise.utilities.placeholderapi.PlaceholderDisguiseType;
import me.libraryaddict.disguise.utilities.placeholderapi.PlaceholderIsDisguised;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisguisePlaceholders
extends PlaceholderExpansion {
    private final HashMap<String, DPlaceholder> placeholders = new HashMap();

    public DisguisePlaceholders() {
        this.add(new PlaceholderDisguiseType());
        this.add(new PlaceholderDisguiseName());
        this.add(new PlaceholderDisguiseHeight());
        this.add(new PlaceholderIsDisguised());
        this.add(new PlaceholderDisguiseSkin());
        this.add(new PlaceholderDisguiseMaterial());
        this.add(new PlaceholderDisguiseFlag());
    }

    private void add(DPlaceholder dPlaceholder) {
        if (this.placeholders.containsKey(dPlaceholder.getName())) {
            throw new IllegalStateException(String.format("Error while trying to register the placeholder '%s' for class %s. The placeholder was already registered by %s", dPlaceholder.getName(), dPlaceholder.getClass().getName(), this.placeholders.get(dPlaceholder.getName()).getClass().getSimpleName()));
        }
        this.placeholders.put(dPlaceholder.getName(), dPlaceholder);
    }

    @NotNull
    public List<String> getPlaceholders() {
        return this.placeholders.values().stream().map(DPlaceholder::getStructure).collect(Collectors.toList());
    }

    @NotNull
    public String getIdentifier() {
        return "libsdisguises";
    }

    @NotNull
    public String getAuthor() {
        return "libraryaddict";
    }

    @NotNull
    public String getVersion() {
        return "1.0.0";
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onPlaceholderRequest(Player player, @NotNull String params) {
        String[] split = params.split(":");
        DPlaceholder placeholder = this.placeholders.get(split[0]);
        if (placeholder == null) {
            return null;
        }
        return placeholder.parse(player, Arrays.copyOfRange(split, 1, split.length));
    }
}

