/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.params.types.custom;

import com.github.retrooper.packetevents.protocol.color.AlphaColor;
import com.github.retrooper.packetevents.protocol.color.Color;
import com.github.retrooper.packetevents.protocol.item.type.ItemTypes;
import com.github.retrooper.packetevents.protocol.particle.Particle;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleBlockStateData;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleColorData;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleData;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleDustColorTransitionData;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleDustData;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleItemStackData;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleSculkChargeData;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleShriekData;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleTrailData;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleVibrationData;
import com.github.retrooper.packetevents.protocol.particle.type.ParticleType;
import com.github.retrooper.packetevents.protocol.particle.type.ParticleTypes;
import com.github.retrooper.packetevents.protocol.world.positionsource.builtin.BlockPositionSource;
import com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import com.github.retrooper.packetevents.protocol.world.states.type.StateType;
import com.github.retrooper.packetevents.protocol.world.states.type.StateTypes;
import com.github.retrooper.packetevents.util.Vector3d;
import com.github.retrooper.packetevents.util.Vector3i;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.params.ParamInfoManager;
import me.libraryaddict.disguise.utilities.params.types.ParamInfoEnum;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoColor;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoItemStack;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoWrappedBlockData;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ParamInfoParticle
extends ParamInfoEnum {
    private final Material[] materials;
    private static final Map<String, ParticleInfo> particleMap = new HashMap<String, ParticleInfo>();

    public ParamInfoParticle(String name, String description, Material[] materials) {
        super((Class)Particle.class, name, description, particleMap);
        this.materials = materials;
    }

    private static void fillMap() {
        for (Field field : ParticleTypes.class.getFields()) {
            ParameterizedType pType;
            Type type;
            int mods = field.getModifiers();
            if (!Modifier.isFinal(mods) || !Modifier.isPublic(mods) || !Modifier.isStatic(mods) || field.isAnnotationPresent(Deprecated.class) || !((type = field.getGenericType()) instanceof ParameterizedType) || (pType = (ParameterizedType)type).getActualTypeArguments().length != 1 || pType.getRawType() != ParticleType.class) continue;
            ParticleType particleType = (ParticleType)field.get(null);
            Class dataClass = (Class)pType.getActualTypeArguments()[0];
            particleMap.put(particleType.getName().getKey(), new ParticleInfo(particleType, dataClass));
        }
    }

    @Override
    public boolean hasTabCompletion() {
        return true;
    }

    private String convertName(String oldName) {
        if (oldName.equalsIgnoreCase("ITEM_CRACK")) {
            return "ITEM";
        }
        if (oldName.equalsIgnoreCase("BLOCK_CRACK")) {
            return "BLOCK";
        }
        if (oldName.equalsIgnoreCase("BLOCK_DUST")) {
            return "FALLING_DUST";
        }
        return oldName;
    }

    @Override
    public Set<String> getEnums(String tabComplete) {
        HashSet<String> enums = new HashSet<String>(this.getValues().keySet());
        if (tabComplete.isEmpty()) {
            return enums;
        }
        String tabCompleteUpperCase = tabComplete.toUpperCase(Locale.ENGLISH);
        String[] blockDatas = new String[]{"BLOCK", "BLOCK_MARKER", "FALLING_DUST", "DUST_PILLAR"};
        for (int i = -1; i < blockDatas.length; ++i) {
            String particleName = i < 0 ? "ITEM" : blockDatas[i];
            enums.remove(particleName);
            for (Material mat : this.materials) {
                String name;
                if (!mat.isBlock() && i == -1 || !(name = particleName + ":" + mat.name()).startsWith(tabCompleteUpperCase)) continue;
                enums.add(name);
            }
        }
        String startsWith = tabComplete.split(":")[0];
        if (Stream.of(blockDatas).noneMatch(s -> s.equalsIgnoreCase(startsWith))) {
            return enums;
        }
        Set<String> newEnums = ParamInfoManager.getParamInfo(WrappedBlockState.class).getEnums(tabComplete.replaceAll("^" + startsWith + ":?", ""));
        if (newEnums == null) {
            return enums;
        }
        newEnums.forEach(s -> enums.add(startsWith + ":" + s));
        return enums;
    }

    private String alphaColorToString(int color) {
        if (color == -1) {
            return String.valueOf(color);
        }
        AlphaColor alphaColor = new AlphaColor(color);
        for (Map.Entry<String, org.bukkit.Color> entry : ParamInfoColor.getStaticColors().entrySet()) {
            org.bukkit.Color c = entry.getValue();
            if (c.getRed() != alphaColor.red() || c.getGreen() != alphaColor.green() || c.getBlue() != alphaColor.blue()) continue;
            return alphaColor.alpha() + ":" + entry.getKey();
        }
        return alphaColor.alpha() + ":" + alphaColor.red() + "," + alphaColor.green() + "," + alphaColor.blue();
    }

    private String colorToString(int red, int green, int blue) {
        for (Map.Entry<String, org.bukkit.Color> entry : ParamInfoColor.getStaticColors().entrySet()) {
            org.bukkit.Color c = entry.getValue();
            if (red != c.getRed() || green != c.getGreen() || blue != c.getBlue()) continue;
            return entry.getKey();
        }
        return red + "," + green + "," + blue;
    }

    @Override
    public String toString(Object object) {
        Particle particle = (Particle)object;
        ParticleData data = particle.getData();
        String returns = particle.getType().getName().getKey();
        if (data != null) {
            if (data instanceof ParticleItemStackData) {
                returns = returns + ":" + ((ParticleItemStackData)data).getItemStack().getType().getName().getKey();
            } else if (data instanceof ParticleBlockStateData) {
                returns = returns + ":" + ParamInfoManager.getParamInfo(WrappedBlockState.class).toString(((ParticleBlockStateData)data).getBlockState());
            } else if (data instanceof ParticleDustData) {
                ParticleDustData dust = (ParticleDustData)data;
                if (dust.getScale() != 1.0f) {
                    returns = returns + ":" + dust.getScale();
                }
                returns = returns + ":" + this.colorToString((int)(dust.getRed() * 255.0f), (int)(dust.getGreen() * 255.0f), (int)(dust.getBlue() * 255.0f));
            } else if (data instanceof ParticleColorData) {
                returns = returns + ":" + this.alphaColorToString(((ParticleColorData)data).getColor());
            } else if (data instanceof ParticleTrailData) {
                ParticleTrailData trail = (ParticleTrailData)data;
                returns = returns + ":" + trail.getTarget().getX() + "," + trail.getTarget().getY() + "," + trail.getTarget().getZ() + ":" + this.colorToString(trail.getColor().red(), trail.getColor().green(), trail.getColor().blue());
            } else if (data instanceof ParticleDustColorTransitionData) {
                ParticleDustColorTransitionData dust = (ParticleDustColorTransitionData)data;
                returns = returns + ":";
                if (dust.getScale() != 1.0f) {
                    returns = returns + dust.getScale() + ":";
                }
                returns = returns + this.colorToString((int)(dust.getStartRed() * 255.0f), (int)(dust.getStartGreen() * 255.0f), (int)(dust.getStartBlue() * 255.0f));
                returns = returns + ":";
                returns = returns + this.colorToString((int)(dust.getEndRed() * 255.0f), (int)(dust.getEndGreen() * 255.0f), (int)(dust.getEndBlue() * 255.0f));
            } else if (data instanceof ParticleSculkChargeData) {
                returns = returns + ":" + ((ParticleSculkChargeData)data).getRoll();
            } else if (data instanceof ParticleVibrationData) {
                ParticleVibrationData vib = (ParticleVibrationData)data;
                @Nullable Vector3i start = vib.getStartingPosition();
                BlockPositionSource source = vib.getSource() instanceof BlockPositionSource ? (BlockPositionSource)vib.getSource() : new BlockPositionSource(new Vector3i(0, 0, 0));
                returns = returns + ":" + source.getPos().getX() + "," + source.getPos().getY() + "," + source.getPos().getZ();
                if (start != null) {
                    returns = returns + ":" + start.getX() + "," + start.getY() + "," + start.getZ();
                }
                returns = returns + ":" + vib.getTicks();
            } else if (data instanceof ParticleShriekData) {
                returns = returns + ":" + ((ParticleShriekData)data).getDelay();
            }
        }
        return returns;
    }

    @Override
    public Object fromString(String string) throws DisguiseParseException {
        String[] split = string.split("[:,]", -1);
        ParticleInfo info = (ParticleInfo)super.fromString(this.convertName(split[0]));
        if (info == null) {
            return null;
        }
        split = Arrays.copyOfRange(split, 1, split.length);
        String name = info.type.getName().getKey();
        ParticleType<?> pType = info.getType();
        Class<? extends ParticleData> cl = info.getData();
        ParticleBlockStateData data = null;
        if (cl == ParticleBlockStateData.class) {
            if (split.length == 0) {
                data = new ParticleBlockStateData(WrappedBlockState.getDefaultState((StateType)StateTypes.STONE));
            } else {
                try {
                    String unSplit = string.substring(string.split("[:,]", -1)[0].length() + 1);
                    if (unSplit.isEmpty()) {
                        throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_BLOCK, name, string);
                    }
                    WrappedBlockState state = (WrappedBlockState)((ParamInfoWrappedBlockData)ParamInfoManager.getParamInfo(WrappedBlockState.class)).fromString(unSplit);
                    if (state == null) {
                        throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_BLOCK, name, string);
                    }
                    data = new ParticleBlockStateData(state);
                }
                catch (DisguiseParseException ex) {
                    throw ex;
                }
                catch (Exception exception) {
                    throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_BLOCK, name, string);
                }
            }
        } else if (cl == ParticleItemStackData.class) {
            if (split.length > 0) {
                ItemStack item = ParamInfoItemStack.parseToItemstack(split);
                data = new ParticleItemStackData(DisguiseUtilities.fromBukkitItemStack(item));
            } else {
                data = new ParticleItemStackData(com.github.retrooper.packetevents.protocol.item.ItemStack.builder().type(ItemTypes.STONE).build());
            }
        } else if (cl == ParticleDustData.class) {
            Color color = new Color(0, 0, 0);
            float scale = 1.0f;
            if (split.length > 0) {
                ColorParser parser = new ColorParser(split).setAlphaColor(false);
                if (!parser.canConsume()) {
                    throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_DUST, name, string);
                }
                try {
                    color = parser.getColor();
                }
                catch (DisguiseParseException ex) {
                    throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_DUST, name, string);
                }
                int remain = parser.getArgsRemaining();
                if (remain != 0) {
                    if (!split[0].matches("\\d+(\\.\\d+)?") || remain > 1) {
                        throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_DUST, name, string);
                    }
                    scale = Float.parseFloat(split[0]);
                    scale = Math.min(100.0f, Math.max(0.2f, scale));
                }
            }
            data = new ParticleDustData(scale, color);
        } else if (cl == ParticleDustColorTransitionData.class) {
            Color color1;
            Color color2;
            ColorParser parser = new ColorParser(split).setAlphaColor(false);
            try {
                color2 = parser.getColor();
                color1 = parser.getColor();
            }
            catch (Exception ex) {
                throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_DUST_TRANSITION, name, string);
            }
            float scale = 1.0f;
            int remain = parser.getArgsRemaining();
            if (remain != 0) {
                if (!split[0].matches("\\d+(\\.\\d+)?") || remain > 1) {
                    throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_DUST_TRANSITION, name, string);
                }
                scale = Float.parseFloat(split[0]);
                scale = Math.min(100.0f, Math.max(0.2f, scale));
            }
            data = new ParticleDustColorTransitionData(scale, color1, color2);
        } else if (cl == ParticleShriekData.class) {
            int delay = 60;
            if (split.length > 0) {
                if (split.length > 1 || !split[0].matches("\\d+")) {
                    throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_SHRIEK, name, string);
                }
                delay = Integer.parseInt(split[0]);
            }
            data = new ParticleShriekData(delay);
        } else if (cl == ParticleSculkChargeData.class) {
            float roll = 60.0f;
            if (split.length > 0) {
                if (split.length > 1 || !split[0].matches("\\d+(\\.\\d+)")) {
                    throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_SHULK_CHARGE, name, string);
                }
                roll = Float.parseFloat(split[0]);
            }
            data = new ParticleSculkChargeData(roll);
        } else if (cl == ParticleColorData.class) {
            int color = ParamInfoParticle.getColorAsInt(string, split, name, true);
            data = new ParticleColorData(color);
        } else if (cl == ParticleVibrationData.class) {
            if (split.length != 4 && split.length != 7) {
                throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_VIBRATION, name, string);
            }
            for (String s : split) {
                if (s.matches("-?\\d+")) continue;
                throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_VIBRATION, name, string);
            }
            Vector3i sourceBlock = new Vector3i(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
            Vector3i startBlock = null;
            int ticks = Integer.parseInt(split[split.length - 1]);
            if (split.length == 7) {
                startBlock = new Vector3i(Integer.parseInt(split[3]), Integer.parseInt(split[4]), Integer.parseInt(split[5]));
            }
            data = new ParticleVibrationData(startBlock, sourceBlock, ticks);
        } else if (cl == ParticleTrailData.class) {
            Color color;
            if (split.length < 3 || split.length == 5 || split.length > 6) {
                throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_TRAIL, name, string);
            }
            for (int i = 0; i < 3; ++i) {
                if (split[i].matches("-?\\d+(\\.\\d+)?")) continue;
                throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_TRAIL, name, string);
            }
            Vector3d target = new Vector3d(Double.parseDouble(split[0]), Double.parseDouble(split[1]), Double.parseDouble(split[2]));
            if (split.length > 3) {
                try {
                    color = new ColorParser(Arrays.copyOfRange(split, 3, split.length)).getColor();
                }
                catch (Exception ex) {
                    throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_TRAIL, name, string);
                }
            } else {
                color = new Color(95, 95, 255);
            }
            data = new ParticleTrailData(target, color);
        }
        if (data == null) {
            if (split.length > 0) {
                return null;
            }
            data = ParticleData.emptyData();
        }
        return new Particle(pType, (ParticleData)data);
    }

    private static int getColorAsInt(String string, String[] split, String name, boolean alphaColor) throws DisguiseParseException {
        int color;
        int n = color = alphaColor ? -1 : 0;
        if (split.length == 1 && split[0].matches("-?\\d+")) {
            color = Integer.parseInt(split[0]);
        } else if (split.length > 0) {
            ColorParser parser = new ColorParser(split).setAlphaColor(alphaColor);
            try {
                color = parser.getColor().asRGB();
            }
            catch (Exception ex) {
                throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_COLOR, name, string);
            }
            if (parser.getArgsRemaining() > 0) {
                throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_COLOR, name, string);
            }
        }
        return color;
    }

    @Override
    public boolean isCustomValues() {
        return true;
    }

    static {
        ParamInfoParticle.fillMap();
    }

    private static class ParticleInfo {
        private final ParticleType<?> type;
        private final Class<? extends ParticleData> data;

        @Generated
        public ParticleType<?> getType() {
            return this.type;
        }

        @Generated
        public Class<? extends ParticleData> getData() {
            return this.data;
        }

        @Generated
        public ParticleInfo(ParticleType<?> type, Class<? extends ParticleData> data) {
            this.type = type;
            this.data = data;
        }
    }

    private static class ColorParser {
        private final String[] split;
        private boolean alphaColor;
        private int argsConsumed;

        public Color getColor() throws DisguiseParseException {
            int need = this.getArgsNeed();
            int start = this.split.length - (this.argsConsumed + need);
            String[] copyOf = Arrays.copyOfRange(this.split, start, start + need);
            this.argsConsumed += need;
            return new PacketColorParser(copyOf, this.alphaColor).parse();
        }

        public int getArgsRemaining() {
            return this.split.length - this.getArgsConsumed();
        }

        private int getArgsNeed() {
            if (this.alphaColor) {
                return this.getArgsRemaining();
            }
            return this.split[this.split.length - (1 + this.argsConsumed)].matches("-?\\d+(\\.\\d+)?") ? 3 : 1;
        }

        public boolean canConsume() {
            return this.getArgsRemaining() > 0 && this.split.length >= this.getArgsNeed() + this.getArgsConsumed();
        }

        @Generated
        public ColorParser(String[] split) {
            this.split = split;
        }

        @Generated
        public ColorParser setAlphaColor(boolean alphaColor) {
            this.alphaColor = alphaColor;
            return this;
        }

        @Generated
        public ColorParser setArgsConsumed(int argsConsumed) {
            this.argsConsumed = argsConsumed;
            return this;
        }

        @Generated
        public int getArgsConsumed() {
            return this.argsConsumed;
        }
    }

    public static class PacketColorParser {
        private final String[] args;
        private final boolean decimalMode;
        private final boolean alphaColor;

        PacketColorParser(String[] args, boolean alphaColor) {
            this.args = args;
            this.decimalMode = Arrays.stream(args).anyMatch(s -> s.contains("."));
            this.alphaColor = alphaColor;
        }

        private void validateArgs() {
            int expect;
            int n = expect = this.args.length >= 3 ? 3 : 1;
            if (expect != this.args.length && this.alphaColor) {
                ++expect;
            }
            if (this.args.length != expect) {
                throw new IllegalArgumentException("Expected " + expect + " args, but got " + this.args.length);
            }
        }

        public Color parseFromNameOrInt() throws DisguiseParseException {
            String colorStr = this.args[this.args.length - 1];
            if (colorStr.matches("-?\\d+")) {
                if (this.args.length != 1) {
                    throw new IllegalArgumentException("Only expected 1 arg, not 2 when parsing int color");
                }
                if (this.alphaColor) {
                    return new AlphaColor(Integer.parseInt(colorStr));
                }
                return new Color(Integer.parseInt(colorStr));
            }
            int alpha = this.args.length > 1 ? this.getInt(this.args[0]) : 255;
            Object[] toPass = this.args;
            if (this.alphaColor && (toPass.length == 2 || toPass.length == 4)) {
                toPass = (String[])Arrays.copyOfRange(toPass, 1, toPass.length);
            }
            org.bukkit.Color color = ((ParamInfoColor)ParamInfoManager.getParamInfo(org.bukkit.Color.class)).parseToColor(StringUtils.join((Object[])toPass, (String)","));
            if (this.alphaColor) {
                return new AlphaColor(alpha, color.getRed(), color.getGreen(), color.getBlue());
            }
            return new Color(color.getRed(), color.getGreen(), color.getBlue());
        }

        public Color parseFromRGB() {
            int r = this.getInt(this.args[this.args.length - 3]);
            int g = this.getInt(this.args[this.args.length - 2]);
            int b = this.getInt(this.args[this.args.length - 1]);
            if (this.alphaColor) {
                int alpha = this.args.length > 3 ? this.getInt(this.args[0]) : 255;
                return new AlphaColor(alpha, r, g, b);
            }
            return new Color(r, g, b);
        }

        public Color parse() throws DisguiseParseException {
            this.validateArgs();
            if (this.args.length > 2) {
                return this.parseFromRGB();
            }
            return this.parseFromNameOrInt();
        }

        private int getInt(String s) {
            if (this.decimalMode) {
                return (int)(Double.parseDouble(s) * 255.0);
            }
            return Integer.parseInt(s);
        }
    }
}

