/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.watchers;

import com.google.gson.Gson;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.PlayerWatcher;
import me.libraryaddict.disguise.utilities.params.ParamInfo;
import me.libraryaddict.disguise.utilities.params.ParamInfoManager;
import me.libraryaddict.disguise.utilities.parser.WatcherMethod;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.reflection.WatcherInfo;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;

public class DisguiseMethods {
    private final HashMap<Class<? extends FlagWatcher>, List<WatcherMethod>> watcherMethods = new HashMap();
    private final HashMap<Class<? extends Disguise>, List<WatcherMethod>> disguiseMethods = new HashMap();
    private final ArrayList<WatcherMethod> methods = new ArrayList();

    public List<WatcherMethod> getMethods(Class c) {
        ArrayList<WatcherMethod> methods = new ArrayList<WatcherMethod>();
        if (this.watcherMethods.containsKey(c)) {
            methods.addAll((Collection<WatcherMethod>)this.watcherMethods.get(c));
        }
        if (c != FlagWatcher.class) {
            methods.addAll(this.getMethods(c.getSuperclass()));
        }
        return methods;
    }

    public DisguiseMethods() {
        DisguiseConfig.loadPreConfig();
        this.loadMethods();
        this.validateMethods();
    }

    private void validateMethods() {
        for (Map.Entry<Class<? extends FlagWatcher>, List<WatcherMethod>> entry : this.watcherMethods.entrySet()) {
            for (WatcherMethod method : entry.getValue()) {
                if (method.getMappedName().equals(method.getMappedName())) continue;
                for (WatcherMethod method2 : entry.getValue()) {
                    if (method == method2 || !method.getMappedName().equalsIgnoreCase(method2.getMappedName())) continue;
                    throw new IllegalArgumentException("In " + entry.getKey() + ", " + method.getMappedName() + " wants to overload " + method2.getMappedName() + " but " + method2.getMappedName() + " well, exists. Which shouldn't be the case. It should either be unsupported version or unsupported parameter. Otherwise it shouldn't be trying to overload it");
                }
            }
        }
    }

    private void loadMethods() {
        ArrayList<String> notedSkippedParamTypes = new ArrayList<String>();
        try (InputStream stream = LibsDisguises.getInstance().getResource("METHOD_MAPPINGS.txt");){
            WatcherInfo[] watcherInfos;
            HashMap<String, Class> classes = new HashMap<String, Class>();
            classes.put(FlagWatcher.class.getSimpleName(), FlagWatcher.class);
            block7: for (DisguiseType t : DisguiseType.values()) {
                if (t.getWatcherClass() == null) continue;
                Class c = t.getWatcherClass();
                while (!classes.containsKey(c.getSimpleName())) {
                    classes.put(c.getSimpleName(), c);
                    if (c == FlagWatcher.class) continue block7;
                    c = ReflectionManager.getSuperClass(c);
                }
            }
            for (WatcherInfo info : watcherInfos = (WatcherInfo[])new Gson().fromJson(new String(ReflectionManager.readFuzzyFully(stream), StandardCharsets.UTF_8), WatcherInfo[].class)) {
                Class watcher;
                if (!info.isSupported() || info.isDeprecated() && info.getAdded() != 0 && info.getRemoved() < 0 || (watcher = (Class)classes.get(info.getWatcher())) == null) continue;
                Class<?> param = DisguiseMethods.parseType(info.getParam());
                Class<?> returnType = DisguiseMethods.parseType(info.getReturnType());
                Class<?> methodType = param == null || param == Void.TYPE ? returnType : param;
                ParamInfo paramType = ParamInfoManager.getParamInfo(methodType);
                if (paramType == null) {
                    String name;
                    String string = name = methodType.isArray() ? methodType.getComponentType().getName() + "[]" : methodType.getName();
                    if (notedSkippedParamTypes.contains(name) || LibsDisguises.getInstance().isJenkins()) continue;
                    notedSkippedParamTypes.add(name);
                    LibsDisguises.getInstance().getLogger().info("DEBUG: Skipped method using " + name + ", don't need it in experimental builds");
                    continue;
                }
                MethodType type = param == null || param == Void.TYPE ? MethodType.methodType(returnType) : MethodType.methodType(returnType, param);
                MethodHandle method = MethodHandles.publicLookup().findVirtual(watcher, info.getMethod(), type);
                boolean[] unusableBy = new boolean[DisguiseType.values().length];
                boolean[] hiddenFor = new boolean[DisguiseType.values().length];
                for (int unusable : info.getUnusableBy()) {
                    unusableBy[unusable] = true;
                }
                for (int unusable : info.getHiddenFor()) {
                    hiddenFor[unusable] = true;
                }
                WatcherMethod m = new WatcherMethod(watcher, method, info.getMappedAs(), info.getMethod(), returnType, param, info.isRandomDefault(), info.isDeprecated() && info.getAdded() == 0, unusableBy, hiddenFor, info.getDescription(), info.isNoVisibleDifference(), info.getAdded(), info.getRemoved());
                this.methods.add(m);
                if (m.getMappedName().startsWith("get") || m.getMappedName().equals("hasPotionEffect") || param == null || param == Void.TYPE || ParamInfoManager.getParamInfo(m) == null) continue;
                this.watcherMethods.computeIfAbsent(watcher, a -> new ArrayList()).add(m);
            }
            this.addExtraMethods();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void addExtraMethods() {
        ArrayList<String> extraMethods = new ArrayList<String>(Arrays.asList("setSelfDisguiseVisible", "setHideHeldItemFromSelf", "setHideArmorFromSelf", "setHearSelfDisguise", "setReplaceSounds", "setHidePlayer", "setExpires", "setNotifyBar", "setBossBarColor", "setBossBarStyle", "setDynamicName", "setSoundGroup", "setDisguiseName", "setDeadmau5Ears", "setTallSelfDisguise"));
        ArrayList<String> hiddenAndIgnored = new ArrayList<String>(Arrays.asList("setTallDisguisesVisible", "setTallSelfDisguisesScaling"));
        if (NmsVersion.v1_20_R4.isSupported()) {
            extraMethods.add("setScalePlayerToDisguise");
        }
        extraMethods.addAll(hiddenAndIgnored);
        block24: for (Class[] classArray : extraMethods) {
            try {
                Class<Object> cl = Boolean.TYPE;
                Class<Disguise> disguiseClass = Disguise.class;
                boolean randomDefault = false;
                switch (classArray) {
                    case "setExpires": {
                        cl = Long.TYPE;
                        break;
                    }
                    case "setNotifyBar": {
                        cl = DisguiseConfig.NotifyBar.class;
                        break;
                    }
                    case "setBossBarColor": {
                        cl = BarColor.class;
                        break;
                    }
                    case "setBossBarStyle": {
                        cl = BarStyle.class;
                        break;
                    }
                    case "setDisguiseName": {
                        randomDefault = true;
                        cl = String.class;
                        break;
                    }
                    case "setSoundGroup": {
                        cl = String.class;
                        break;
                    }
                    case "setDeadmau5Ears": {
                        disguiseClass = PlayerDisguise.class;
                        break;
                    }
                    case "setTallSelfDisguise": {
                        cl = DisguiseConfig.TallSelfDisguise.class;
                    }
                }
                for (Class returnType : new Class[]{Void.TYPE, disguiseClass}) {
                    try {
                        boolean hidden = hiddenAndIgnored.contains(classArray);
                        WatcherMethod setMethod = new WatcherMethod(disguiseClass, MethodHandles.publicLookup().findVirtual(disguiseClass, (String)classArray, MethodType.methodType(returnType, cl)), (String)classArray, (String)classArray, null, cl, randomDefault, hidden, new boolean[DisguiseType.values().length], new boolean[DisguiseType.values().length], null, false, 0, 0);
                        this.methods.add(setMethod);
                        this.watcherMethods.computeIfAbsent(disguiseClass == Disguise.class ? FlagWatcher.class : PlayerWatcher.class, a -> new ArrayList()).add(setMethod);
                        String getName = (cl == Boolean.TYPE ? "is" : "get") + classArray.substring(3);
                        WatcherMethod getMethod = new WatcherMethod(disguiseClass, MethodHandles.publicLookup().findVirtual(disguiseClass, getName, MethodType.methodType(cl)), getName, getName, cl, null, randomDefault, hidden, new boolean[DisguiseType.values().length], new boolean[DisguiseType.values().length], null, false, 0, 0);
                        this.methods.add(getMethod);
                        continue block24;
                    }
                    catch (NoSuchMethodException ex) {
                        if (returnType != disguiseClass) continue;
                        ex.printStackTrace();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static Class<?> parseType(String className) throws ClassNotFoundException {
        if (className == null) {
            return null;
        }
        if (className.contains(".")) {
            return Class.forName(className);
        }
        switch (className) {
            case "void": {
                return Void.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "[I": {
                return int[].class;
            }
            case "[Z": {
                return boolean[].class;
            }
        }
        throw new IllegalArgumentException("Class not found: " + className);
    }

    @Generated
    public ArrayList<WatcherMethod> getMethods() {
        return this.methods;
    }
}

