/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.reflection;

import io.papermc.paper.ServerBuildInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ClassMappings {
    private static final HashMap<String, String> classLocations = new HashMap();
    private static final String[] packages = ClassMappings.getPackages();
    private static boolean updatingCache = false;
    private static final File mappingsFile = new File(DisguiseUtilities.getInternalFolder(), "mappings_cache");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getClass(String packageHint, String className) {
        String key = packageHint + "." + className;
        String location = classLocations.get(key);
        if (location != null) {
            return location;
        }
        location = "???";
        for (String pack : packages) {
            if (!pack.startsWith(packageHint)) continue;
            String toTry = pack + "." + className;
            try {
                Class.forName(toTry);
                location = toTry;
                break;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        classLocations.put(key, location);
        HashMap<String, String> hashMap = classLocations;
        synchronized (hashMap) {
            if (!updatingCache && LibsDisguises.getInstance() != null && LibsDisguises.getInstance().isEnabled()) {
                updatingCache = true;
                new BukkitRunnable(){

                    public void run() {
                        ClassMappings.saveMappingsCache(LibsDisguises.getInstance().getDataFolder());
                    }
                }.runTaskLater((Plugin)LibsDisguises.getInstance(), 200L);
            }
        }
        return location;
    }

    private static String[] getPackages() {
        String[] s = new String[]{"net.minecraft.server", "net.minecraft.server.$version$", "org.bukkit.craftbukkit.$version$", "org.bukkit.craftbukkit.$version$.block.data", "org.bukkit.craftbukkit.$version$.entity", "org.bukkit.craftbukkit.$version$.inventory", "org.bukkit.craftbukkit.$version$.util"};
        String replaceStr = "$version$";
        String version = ReflectionManager.getNmsPackage();
        if (version.isEmpty()) {
            replaceStr = "." + replaceStr;
        }
        for (int i = 0; i < s.length; ++i) {
            s[i] = s[i].replace(replaceStr, version);
        }
        return s;
    }

    private static String getVersion() {
        ServerBuildInfo buildInfo;
        String version = Bukkit.getVersion() + "\t" + LibsDisguises.getInstance().getDescription().getVersion();
        if (ReflectionManager.isRunningPaper() && NmsVersion.v1_21_R2.isSupported() && (buildInfo = ServerBuildInfo.buildInfo()) != null && buildInfo.buildTime() != null) {
            version = version + "\t" + buildInfo.buildTime();
        }
        return "Built for: " + version;
    }

    public static void deleteMappingsCache() {
        ClassMappings.getMappingsFile().delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveMappingsCache(File dataFolder) {
        HashMap<String, String> hashMap = classLocations;
        synchronized (hashMap) {
            if (!updatingCache) {
                return;
            }
            updatingCache = false;
        }
        ClassMappings.getMappingsFile().getParentFile().mkdirs();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(ClassMappings.getMappingsFile()));){
            writer.write(ClassMappings.getVersion() + "\n");
            for (Map.Entry<String, String> entry : classLocations.entrySet()) {
                writer.write(entry.getKey() + " " + entry.getValue() + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadMappingsCache() {
        if (!ClassMappings.getMappingsFile().exists()) {
            return;
        }
        try (BufferedReader reader2 = new BufferedReader(new FileReader(ClassMappings.getMappingsFile()));){
            String line = reader2.readLine();
            if (line == null || !line.equals(ClassMappings.getVersion())) {
                LibsDisguises.getInstance().getLogger().info("Outdated mappings cache, will rebuild.");
                return;
            }
            while ((line = reader2.readLine()) != null) {
                String[] parts = line.split(" ", 2);
                if (parts.length != 2) continue;
                try {
                    if (parts[1].contains(".")) {
                        Class.forName(parts[1]);
                    }
                    classLocations.put(parts[0], parts[1]);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        catch (FileNotFoundException reader2) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Generated
    public static File getMappingsFile() {
        return mappingsFile;
    }

    static {
        ClassMappings.loadMappingsCache();
    }
}

