/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packethandlers;

import com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.github.retrooper.packetevents.protocol.player.Equipment;
import com.github.retrooper.packetevents.protocol.player.EquipmentSlot;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityEquipment;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.packets.IPacketHandler;
import me.libraryaddict.disguise.utilities.packets.LibsPackets;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.reflection.WatcherValue;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PacketHandlerEquipment
implements IPacketHandler<WrapperPlayServerEntityEquipment> {
    @Override
    public PacketTypeCommon[] getHandledPackets() {
        return new PacketTypeCommon[]{PacketType.Play.Server.ENTITY_EQUIPMENT};
    }

    @Override
    public void handle(Disguise disguise, LibsPackets<WrapperPlayServerEntityEquipment> packets, Player observer, Entity entity) {
        WrapperPlayServerEntityEquipment originalPacket = packets.getOriginalPacket();
        ArrayList<Equipment> equipmentBeingSent = new ArrayList<Equipment>();
        for (Equipment equipment : originalPacket.getEquipment()) {
            MetaIndex<Byte> toUse;
            EquipmentSlot slot = equipment.getSlot();
            ItemStack itemInDisguise = disguise.getWatcher().getItemStack(DisguiseUtilities.getSlot(slot));
            com.github.retrooper.packetevents.protocol.item.ItemStack itemInPacket = equipment.getItem();
            equipment.setItem(itemInPacket);
            if (itemInDisguise != null) {
                if (packets.getPackets().contains(originalPacket)) {
                    packets.getPackets().remove(originalPacket);
                    packets.addPacket((PacketWrapper)new WrapperPlayServerEntityEquipment(originalPacket.getEntityId(), equipmentBeingSent));
                }
                itemInPacket = itemInDisguise.getType() == Material.AIR ? com.github.retrooper.packetevents.protocol.item.ItemStack.EMPTY : DisguiseUtilities.fromBukkitItemStack(itemInDisguise);
                equipmentBeingSent.add(new Equipment(slot, itemInPacket));
            } else {
                equipmentBeingSent.add(equipment);
            }
            if (itemInPacket.isEmpty() || (slot != EquipmentSlot.MAIN_HAND || !disguise.getWatcher().isMainHandRaised()) && (slot != EquipmentSlot.OFF_HAND || !(disguise.getWatcher() instanceof LivingWatcher) || !((LivingWatcher)disguise.getWatcher()).isOffhandRaised())) continue;
            List<WatcherValue> list = new ArrayList<WatcherValue>();
            MetaIndex<Byte> metaIndex = toUse = NmsVersion.v1_13.isSupported() ? MetaIndex.LIVING_META : MetaIndex.ENTITY_META;
            if (DisguiseConfig.isMetaPacketsEnabled()) {
                List<EntityData<?>> data = ReflectionManager.getEntityWatcher(entity);
                byte b = toUse.getDefault();
                Iterator iterator = data.iterator();
                while (iterator.hasNext()) {
                    EntityData d = (EntityData)iterator.next();
                    if (d.getIndex() != toUse.getIndex()) continue;
                    b = (Byte)d.getValue();
                    break;
                }
                list.add(new WatcherValue(toUse, b, true));
                list = disguise.getWatcher().convert(observer, list);
            } else {
                for (WatcherValue obj : disguise.getWatcher().getWatchableObjects()) {
                    if (obj.getIndex() != toUse.getIndex()) continue;
                    list.add(obj);
                    break;
                }
            }
            WrapperPlayServerEntityMetadata packetBlock = ReflectionManager.getMetadataPacket(entity.getEntityId(), list);
            list.forEach(v -> v.setValue(NmsVersion.v1_13.isSupported() ? (byte)0 : (byte)((Byte)v.getValue() & 0xFFFFFFEF)));
            WrapperPlayServerEntityMetadata packetUnblock = ReflectionManager.getMetadataPacket(entity.getEntityId(), list);
            packets.getPackets().add(0, (PacketWrapper)packetUnblock);
            packets.addPacket((PacketWrapper)packetBlock);
        }
    }
}

