/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.config;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.config.ConfigLoader;
import me.libraryaddict.disguise.utilities.config.migrations.ConfigMigration_DisabledMethods;
import me.libraryaddict.disguise.utilities.config.migrations.ConfigMigration_DisguiseScaling;
import me.libraryaddict.disguise.utilities.config.migrations.ConfigMigration_DisplayTextNames;
import me.libraryaddict.disguise.utilities.config.migrations.ConfigMigration_RenamedFiles;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigMigrator {
    private final Set<String> alreadyLoaded = new HashSet<String>();
    private final Set<String> toDelete = new HashSet<String>();
    private final Set<String> toWrite = new HashSet<String>();

    private static List<ConfigMigration> getMigrations() {
        ArrayList<ConfigMigration> list = new ArrayList<ConfigMigration>();
        list.add(new ConfigMigration_RenamedFiles());
        list.add(new ConfigMigration_DisabledMethods(1, "setNameYModifier", "setInvisible", "setUnsafeSize", "setScalePlayerToDisguise"));
        list.add(new ConfigMigration_DisguiseScaling());
        list.add(new ConfigMigration_DisplayTextNames());
        return list;
    }

    public static int getLastMigrationVersion() {
        return ConfigMigrator.getMigrations().stream().mapToInt(ConfigMigration::getVersion).max().orElse(-1);
    }

    public void runMigrations() {
        List<ConfigMigration> migrations = ConfigMigrator.getMigrations();
        int currentMigration = DisguiseConfig.getLastConfigVersion();
        Iterator<ConfigMigration> iterator = migrations.iterator();
        while (iterator.hasNext()) {
            ConfigMigration migration = iterator.next();
            if (migration.getVersion() > currentMigration) continue;
            if (migration.isRelevant()) {
                currentMigration = Math.min(currentMigration, migration.getVersion() - 1);
                LibsDisguises.getInstance().getLogger().info("Old config migration doesn't seem to have applied properly, will try migrating configs again.");
                continue;
            }
            iterator.remove();
        }
        if (migrations.isEmpty()) {
            return;
        }
        int version = currentMigration;
        int finalVersion = migrations.stream().map(ConfigMigration::getVersion).max(Integer::compareTo).get();
        LibsDisguises.getInstance().getLogger().info("Running " + migrations.size() + " config migrations.. Jumping from version " + version + " to " + finalVersion);
        YamlConfiguration globalConfig = new YamlConfiguration();
        for (ConfigMigration migration : migrations) {
            this.runMigration(migration, globalConfig);
            version = Math.max(version, migration.getVersion());
        }
        for (String filename : this.toWrite) {
            LibsDisguises.getInstance().getLogger().info("Saving config " + filename);
            ConfigLoader.saveConfig(globalConfig, filename);
        }
        for (String oldFile : this.toDelete) {
            File file = this.getConfig(oldFile);
            if (!file.exists()) continue;
            file.delete();
            LibsDisguises.getInstance().getLogger().info("Removing legacy config file " + oldFile);
        }
        DisguiseConfig.setLastConfigVersion(version);
        DisguiseConfig.saveInternalConfig();
    }

    private void runMigration(ConfigMigration migration, YamlConfiguration globalConfig) {
        for (String filename : migration.getAllFilesTouched()) {
            this.addConfigToConfig(filename, globalConfig);
        }
        migration.migrate(globalConfig);
        for (String migrateFrom : migration.getFilesToMigrateFrom()) {
            if (Arrays.asList(migration.getFilesToMigrateTo()).contains(migrateFrom)) continue;
            this.toDelete.add(migrateFrom);
            this.toWrite.remove(migrateFrom);
        }
        for (String migrateTo : migration.getFilesToMigrateTo()) {
            this.toDelete.remove(migrateTo);
            this.toWrite.add(migrateTo);
        }
    }

    private File getConfig(String name) {
        return new File(LibsDisguises.getInstance().getDataFolder(), "configs/" + name);
    }

    private void addConfigToConfig(String filename, YamlConfiguration globalConfig) {
        if (this.alreadyLoaded.contains(filename)) {
            return;
        }
        this.alreadyLoaded.add(filename);
        File file = this.getConfig(filename);
        if (!file.exists()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        for (String k : config.getKeys(true)) {
            if (config.isConfigurationSection(k) || globalConfig.isConfigurationSection(k) || globalConfig.isSet(k)) continue;
            globalConfig.set(k, config.get(k));
        }
    }

    public static interface ConfigMigration {
        public String[] getFilesToMigrateFrom();

        default public String[] getFilesToMigrateTo() {
            return this.getFilesToMigrateFrom();
        }

        default public List<String> getAllFilesTouched() {
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(this.getFilesToMigrateFrom()));
            for (String string : this.getFilesToMigrateTo()) {
                if (list.stream().anyMatch(string::equals)) continue;
                list.add(string);
            }
            return list;
        }

        public int getVersion();

        public void migrate(YamlConfiguration var1);

        default public boolean isRelevant() {
            return false;
        }
    }
}

