/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packetlisteners;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.SimplePacketListenerAbstract;
import com.github.retrooper.packetevents.event.simple.PacketPlaySendEvent;
import com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import com.github.retrooper.packetevents.protocol.mapper.MappedEntity;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.world.damagetype.DamageTypes;
import com.github.retrooper.packetevents.resources.ResourceLocation;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityAnimation;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityStatus;
import java.util.ArrayList;
import java.util.Map;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.packets.LibsPackets;
import me.libraryaddict.disguise.utilities.packets.PacketsManager;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.reflection.WatcherValue;
import me.libraryaddict.disguise.utilities.sounds.SoundGroup;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PacketListenerViewSelfDisguise
extends SimplePacketListenerAbstract {
    private final boolean[] listenedPackets = new boolean[PacketType.Play.Server.values().length];

    public PacketListenerViewSelfDisguise() {
        for (PacketType.Play.Server packet : new PacketType.Play.Server[]{NmsVersion.v1_20_R2.isSupported() ? PacketType.Play.Server.SPAWN_ENTITY : PacketType.Play.Server.SPAWN_PLAYER, PacketType.Play.Server.SET_PASSENGERS, PacketType.Play.Server.ENTITY_RELATIVE_MOVE_AND_ROTATION, PacketType.Play.Server.ENTITY_RELATIVE_MOVE, PacketType.Play.Server.ENTITY_HEAD_LOOK, PacketType.Play.Server.ENTITY_ROTATION, PacketType.Play.Server.ENTITY_TELEPORT, PacketType.Play.Server.ENTITY_MOVEMENT, PacketType.Play.Server.ENTITY_METADATA, PacketType.Play.Server.ENTITY_EQUIPMENT, PacketType.Play.Server.ENTITY_ANIMATION, PacketType.Play.Server.ENTITY_EFFECT, PacketType.Play.Server.ENTITY_VELOCITY, PacketType.Play.Server.UPDATE_ATTRIBUTES, PacketType.Play.Server.ENTITY_STATUS, PacketType.Play.Server.ENTITY_POSITION_SYNC, PacketType.Play.Server.DAMAGE_EVENT}) {
            if (packet == PacketType.Play.Server.DAMAGE_EVENT && (!DisguiseUtilities.isRegistered((MappedEntity)DamageTypes.CRAMMING) || NmsVersion.v1_21_R1.isVersion())) continue;
            this.listenedPackets[packet.ordinal()] = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onPacketPlaySend(PacketPlaySendEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!this.listenedPackets[event.getPacketType().ordinal()]) {
            return;
        }
        try {
            SoundGroup group;
            Player observer = (Player)event.getPlayer();
            if (observer == null) {
                return;
            }
            PacketWrapper wrapper = DisguiseUtilities.constructWrapper(event);
            int entityId = DisguiseUtilities.getEntityId(wrapper);
            if (entityId != observer.getEntityId() && entityId != DisguiseAPI.getSelfDisguiseId()) {
                return;
            }
            if (!DisguiseAPI.isSelfDisguised(observer)) {
                return;
            }
            Disguise disguise = DisguiseAPI.getDisguise(observer, (Entity)observer);
            if (disguise == null) {
                return;
            }
            LibsPackets transformed = PacketsManager.getPacketsHandler().transformPacket(wrapper, disguise, observer, (Entity)observer);
            if (transformed.isUnhandled()) {
                transformed.addPacket(DisguiseUtilities.unsafeClone(event, wrapper));
            }
            LibsPackets<PacketWrapper> selfTransformed = new LibsPackets<PacketWrapper>(wrapper, disguise);
            selfTransformed.setSkinHandling(transformed.isSkinHandling());
            for (PacketWrapper packetWrapper : transformed.getPackets()) {
                void var9_10;
                if (packetWrapper == selfTransformed.getOriginalPacket()) {
                    PacketWrapper packetWrapper2 = DisguiseUtilities.unsafeClone(event, packetWrapper);
                }
                if (var9_10.getPacketTypeData().getPacketType() != PacketType.Play.Server.PLAYER_INFO && var9_10.getPacketTypeData().getPacketType() != PacketType.Play.Server.PLAYER_INFO_UPDATE && var9_10.getPacketTypeData().getPacketType() != PacketType.Play.Server.DESTROY_ENTITIES && DisguiseUtilities.getEntityId((PacketWrapper)var9_10).intValue() == observer.getEntityId()) {
                    DisguiseUtilities.writeSelfDisguiseId(observer.getEntityId(), (PacketWrapper)var9_10);
                }
                selfTransformed.addPacket((PacketWrapper)var9_10);
            }
            for (Map.Entry entry : transformed.getDelayedPacketsMap().entrySet()) {
                for (PacketWrapper newPacket : (ArrayList)entry.getValue()) {
                    if (newPacket == selfTransformed.getOriginalPacket()) {
                        newPacket = DisguiseUtilities.unsafeClone(event, newPacket);
                    }
                    if (newPacket.getPacketTypeData().getPacketType() != PacketType.Play.Server.PLAYER_INFO && newPacket.getPacketTypeData().getPacketType() != PacketType.Play.Server.PLAYER_INFO_UPDATE && newPacket.getPacketTypeData().getPacketType() != PacketType.Play.Server.DESTROY_ENTITIES) {
                        DisguiseUtilities.writeSelfDisguiseId(observer.getEntityId(), newPacket);
                    }
                    selfTransformed.addDelayedPacket(newPacket, (Integer)entry.getKey());
                }
            }
            if (disguise.isPlayerDisguise()) {
                LibsDisguises.getInstance().getSkinHandler().handlePackets(observer, (PlayerDisguise)disguise, selfTransformed);
            }
            for (PacketWrapper packetWrapper : selfTransformed.getPackets()) {
                PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)observer, packetWrapper);
            }
            selfTransformed.sendDelayed(observer);
            if (event.getPacketType() == PacketType.Play.Server.ENTITY_METADATA) {
                WrapperPlayServerEntityMetadata metadata = (WrapperPlayServerEntityMetadata)wrapper;
                if (metadata.getEntityId() == observer.getEntityId()) {
                    for (EntityData data : metadata.getEntityMetadata()) {
                        if (data.getIndex() != 0) continue;
                        byte b = (Byte)data.getValue();
                        byte a = (byte)((b | 0x20) & 0xFFFFFFBF);
                        data.setValue((Object)a);
                    }
                }
            } else if (event.getPacketType() == PacketType.Play.Server.SPAWN_PLAYER || event.getPacketType() == PacketType.Play.Server.SPAWN_ENTITY) {
                byte by;
                byte by2;
                event.setCancelled(true);
                ArrayList<WatcherValue> watchableList = new ArrayList<WatcherValue>();
                int n = 32;
                if (observer.isSprinting()) {
                    by2 = (byte)(n | 8);
                }
                if (observer.isGliding()) {
                    by = (byte)(by2 | 0x80);
                }
                WatcherValue watch = new WatcherValue(MetaIndex.ENTITY_META, by, true);
                watchableList.add(watch);
                WrapperPlayServerEntityMetadata metaPacket = ReflectionManager.getMetadataPacket(observer.getEntityId(), watchableList);
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)observer, (PacketWrapper)metaPacket);
            } else if (event.getPacketType() == PacketType.Play.Server.ENTITY_ANIMATION) {
                if (((WrapperPlayServerEntityAnimation)wrapper).getType() != WrapperPlayServerEntityAnimation.EntityAnimationType.WAKE_UP) {
                    event.setCancelled(true);
                }
            } else if (event.getPacketType() == PacketType.Play.Server.ATTACH_ENTITY || event.getPacketType() == PacketType.Play.Server.SET_PASSENGERS || event.getPacketType() == PacketType.Play.Server.ENTITY_RELATIVE_MOVE || event.getPacketType() == PacketType.Play.Server.ENTITY_RELATIVE_MOVE_AND_ROTATION || event.getPacketType() == PacketType.Play.Server.ENTITY_HEAD_LOOK || event.getPacketType() == PacketType.Play.Server.ENTITY_POSITION_SYNC || event.getPacketType() == PacketType.Play.Server.ENTITY_TELEPORT || event.getPacketType() == PacketType.Play.Server.ENTITY_ROTATION || event.getPacketType() == PacketType.Play.Server.ENTITY_EQUIPMENT) {
                event.setCancelled(true);
            } else if (event.getPacketType() == PacketType.Play.Server.ENTITY_STATUS) {
                if (disguise.isSelfDisguiseSoundsReplaced() && !disguise.getType().isPlayer() && ((WrapperPlayServerEntityStatus)wrapper).getStatus() == 2) {
                    ResourceLocation resourceLocation;
                    event.setCancelled(true);
                    if (NmsVersion.v1_19_R2.isSupported() && (resourceLocation = (group = SoundGroup.getGroup(disguise)).getSound(SoundGroup.SoundType.HURT)) != null) {
                        observer.playSound(observer.getLocation(), resourceLocation.toString(), 1.0f, 1.0f);
                    }
                }
            } else if (event.getPacketType() == PacketType.Play.Server.DAMAGE_EVENT) {
                if (disguise.isSelfDisguiseSoundsReplaced()) {
                    ResourceLocation resourceLocation;
                    event.setCancelled(true);
                    group = SoundGroup.getGroup(disguise);
                    if (group != null && (resourceLocation = group.getSound(SoundGroup.SoundType.HURT)) != null) {
                        observer.playSound(observer.getLocation(), resourceLocation.toString(), 1.0f, 1.0f);
                    }
                }
            } else if (event.getPacketType() == PacketType.Play.Server.ENTITY_VELOCITY && !DisguiseUtilities.isPlayerVelocity(observer)) {
                event.setCancelled(true);
                DisguiseUtilities.clearPlayerVelocity(observer);
            }
        }
        catch (Throwable ex) {
            event.setCancelled(true);
            ex.printStackTrace();
        }
    }
}

