/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.stream.Collectors;
import lombok.Generated;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.plugin.BisectHosting;
import me.libraryaddict.disguise.utilities.plugin.LibsDisgInfo;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.util.FileUtil;

public class LibsPremium {
    private static Boolean thisPluginIsPaidFor;
    private static LibsDisgInfo pluginInformation;
    private static LibsDisgInfo paidInformation;
    private static boolean bisectHosted;

    public static String getUserID() {
        return "%%__USER__%%";
    }

    public static String getResourceID() {
        return "%%__RESOURCE__%%";
    }

    public static String getDownloadID() {
        return "%%__NONCE__%%";
    }

    private static Boolean isPremium(String resourceID, String userID) {
        return !userID.contains("__USER__") && resourceID.equals("32453");
    }

    public static Boolean isPremium() {
        if (thisPluginIsPaidFor != null) {
            return thisPluginIsPaidFor;
        }
        return LibsPremium.isPremium(LibsPremium.getResourceID(), LibsPremium.getUserID());
    }

    private static boolean isValidVersion(String currentVersion, String premiumVersion) {
        currentVersion = currentVersion.replaceAll("(v)|(-SNAPSHOT)", "");
        if (!premiumVersion.matches("\\d+(\\.\\d+)+")) {
            return false;
        }
        if (premiumVersion.startsWith("9.")) {
            return false;
        }
        if (!currentVersion.matches("\\d+(\\.\\d+)+")) {
            return true;
        }
        String[] currentSplit = currentVersion.split("\\.");
        String[] premSplit = premiumVersion.split("\\.");
        return true;
    }

    public static LibsDisgInfo getInformation(File file) throws Exception {
        try (URLClassLoader cl = new URLClassLoader(new URL[]{file.toURI().toURL()});){
            Class<?> c = cl.loadClass(LibsPremium.class.getName());
            YamlConfiguration config = ReflectionManager.getPluginYAMLEx(file);
            String userId = (String)c.getMethod("getUserID", new Class[0]).invoke(null, new Object[0]);
            String downloadId = (String)c.getMethod("getDownloadID", new Class[0]).invoke(null, new Object[0]);
            String resourceId = (String)c.getMethod("getResourceID", new Class[0]).invoke(null, new Object[0]);
            Boolean premium = LibsPremium.isPremium(resourceId, userId);
            String pluginBuildDate = "??/??/????";
            if (config.contains("build-date")) {
                pluginBuildDate = config.getString("build-date");
            }
            String pluginBuildNumber = "???";
            if (config.contains("build-number") && (pluginBuildNumber = config.getString("build-number")).matches("\\d+")) {
                pluginBuildNumber = "#" + pluginBuildNumber;
            }
            String pluginVersion = config.getString("version");
            LibsDisgInfo libsDisgInfo = new LibsDisgInfo(file.length(), userId, resourceId, downloadId, premium, pluginVersion, pluginBuildNumber, pluginBuildDate);
            return libsDisgInfo;
        }
    }

    private static void doSecondaryCheck(String version) {
        File[] files;
        File pluginDir = new File(LibsDisguises.getInstance().getDataFolder(), "LibsDisguises/");
        if (!pluginDir.exists() && LibsDisguises.getInstance() != null) {
            pluginDir = LibsDisguises.getInstance().getDataFolder();
        }
        if ((files = pluginDir.listFiles()) == null) {
            return;
        }
        for (File file : files) {
            LibsDisgInfo plugin;
            if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
            try {
                plugin = LibsPremium.getInformation(file);
            }
            catch (ClassNotFoundException | NoClassDefFoundError ex) {
                LibsDisguises.getInstance().getLogger().warning("Found an unrecognized jar in the LibsDisguises folder (" + file.getName() + ") - It may need replacing with a newer jar from SpigotMC");
                continue;
            }
            catch (Exception ex) {
                LibsDisguises.getInstance().getLogger().warning("Error while trying to handle the file " + file.getName());
                ex.printStackTrace();
                continue;
            }
            String fileInfo = String.format("v%s, build %s, created %s", plugin.getVersion(), plugin.getBuildNumber(), plugin.getBuildDate());
            thisPluginIsPaidFor = plugin.isPremium();
            if (thisPluginIsPaidFor.booleanValue()) {
                if (!LibsPremium.isValidVersion(version, plugin.getVersion()) || plugin.getUserID() == null || plugin.getDownloadID() == null || plugin.getUserID().equals("666666")) {
                    LibsDisguises.getInstance().getLogger().warning("You have an old Lib's Disguises jar (" + file.getName() + " " + fileInfo + ") in the LibsDisguises folder! Please replace this with a new version from SpigotMC - https://www.spigotmc.org/resources/libs-disguises.32453/");
                    continue;
                }
                paidInformation = plugin;
                LibsDisguises.getInstance().getLogger().info("Found a premium Lib's Disguises jar (" + fileInfo + ")");
                LibsDisguises.getInstance().getLogger().info("Registered to: " + LibsPremium.getSanitizedUser(plugin.getUserID()));
                if (plugin.getBuildNumber() != null && plugin.getBuildNumber().matches("#\\d+") && Integer.parseInt(plugin.getBuildNumber().substring(1)) >= 300) break;
                file.delete();
                continue;
            }
            LibsDisguises.getInstance().getLogger().warning("You have a non-premium Lib's Disguises jar (" + file.getName() + " " + fileInfo + ") in the LibsDisguises folder!");
            LibsDisguises.getInstance().getLogger().warning("Please place the premium jar downloaded from https://www.spigotmc.org/resources/libs-disguises.32453/ in here!");
        }
        if (!LibsPremium.isPremium().booleanValue()) {
            bisectHosted = new BisectHosting().isBisectHosted("LibsDisguises");
            if (bisectHosted) {
                LibsDisguises.getInstance().getLogger().info("Hosted by BisectHosting! Premium enabled!");
                paidInformation = new LibsDisgInfo(0L, "13", "32453", "2", true, "0", "#1", "0");
                thisPluginIsPaidFor = true;
            } else {
                LibsDisguises.getInstance().getLogger().info("If you own the plugin, place the premium jar downloaded from https://www.spigotmc.org/resources/libs-disguises.32453/ in plugins/LibsDisguises/");
            }
        }
    }

    private static String getSanitizedUser(String userID) {
        if (userID == null) {
            return "N/A";
        }
        if (!userID.matches("\\d+")) {
            return String.format("... %s? Am I reading this right?", userID);
        }
        int total = 0;
        for (char c : userID.toCharArray()) {
            total += Character.getNumericValue(c);
        }
        return String.format("%s (%s)", userID, total);
    }

    /*
     * WARNING - void declaration
     */
    public static void check(String version, File file) {
        thisPluginIsPaidFor = LibsDisguises.getInstance().isJenkins() && LibsPremium.isPremium() != false;
        try {
            pluginInformation = LibsPremium.getInformation(file);
        }
        catch (Exception e) {
            void var3_7;
            String string = "??/??/????";
            YamlConfiguration config = new YamlConfiguration();
            try {
                try (InputStream stream = LibsDisguises.getInstance().getResource("plugin.yml");){
                    config.loadFromString(new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n")));
                }
                if (config.contains("build-date")) {
                    String string2 = config.getString("build-date");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            String buildNo = LibsDisguises.getInstance().getBuildNo();
            if (buildNo != null && buildNo.matches("\\d+")) {
                buildNo = "#" + buildNo;
            }
            pluginInformation = new LibsDisgInfo(LibsDisguises.getInstance().getFile().length(), LibsPremium.getUserID(), LibsPremium.getResourceID(), LibsPremium.getDownloadID(), LibsPremium.isPremium(LibsPremium.getResourceID(), LibsPremium.getUserID()), version, buildNo, (String)var3_7);
        }
        if (!LibsPremium.isPremium().booleanValue() || !LibsDisguises.getInstance().isReleaseBuild()) {
            LibsPremium.doSecondaryCheck(version);
        } else {
            LibsDisguises.getInstance().getLogger().info("Registered to: " + LibsPremium.getSanitizedUser(LibsPremium.getUserID()));
            boolean updateJar = LibsPremium.getPluginInformation().isPaid();
            for (File f : LibsDisguises.getInstance().getDataFolder().listFiles()) {
                if (f.isDirectory() || !f.getName().endsWith(".jar")) continue;
                try {
                    LibsDisgInfo info = LibsPremium.getInformation(f);
                    if (info.getBuildNumber() == null || !info.getBuildNumber().matches("#\\d+")) {
                        f.delete();
                        LibsDisguises.getInstance().getLogger().info("Unknown file detected and deleted: LibsDisguises/" + f.getName());
                        continue;
                    }
                    if (Integer.parseInt(info.getBuildNumber().replace("#", "")) < Integer.parseInt(LibsDisguises.getInstance().getBuildNo().replace("#", ""))) {
                        f.delete();
                        LibsDisguises.getInstance().getLogger().info("Outdated file deleted: LibsDisguises/" + f.getName());
                        continue;
                    }
                    if (!info.isPaid()) {
                        f.delete();
                        LibsDisguises.getInstance().getLogger().info("Potential virus was deleted: LibsDisguises/" + f.getName());
                        continue;
                    }
                    Date d1 = LibsPremium.getPluginInformation().getParsedBuildDate();
                    Date d2 = info.getParsedBuildDate();
                    if (LibsPremium.getPluginInformation().equals(info) || d1 == null || d2 != null && d2.getTime() >= d1.getTime()) {
                        updateJar = false;
                        break;
                    }
                    if (!updateJar) break;
                    f.delete();
                    break;
                }
                catch (ClassNotFoundException | NoClassDefFoundError e) {
                    LibsDisguises.getInstance().getLogger().info("Invalid Lib's Disguises jar has errored, deleting LibsDisguises/" + f.getName());
                    f.delete();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            bisectHosted = LibsPremium.isPremium("", "");
            if (updateJar) {
                File file2 = LibsDisguises.getInstance().getFile();
                File dest = new File(LibsDisguises.getInstance().getDataFolder(), file2.getName());
                dest.delete();
                FileUtil.copy((File)file2, (File)dest);
                LibsDisguises.getInstance().getLogger().info("Added " + file2.getName() + " to the 'plugins/LibsDisguises/' folder! You can use dev builds with premium enabled!");
            }
        }
        if (LibsPremium.isPremium().booleanValue()) {
            boolean prem = LibsPremium.getPaidInformation() == null ? LibsPremium.getPluginInformation().isPaid() : LibsPremium.getPaidInformation().isPaid();
            LibsDisguises.getInstance().getLogger().info("Premium enabled, thank you for supporting Lib's Disguises!" + (!prem ? "!" : ""));
        }
    }

    @Generated
    public static LibsDisgInfo getPluginInformation() {
        return pluginInformation;
    }

    @Generated
    public static LibsDisgInfo getPaidInformation() {
        return paidInformation;
    }

    @Generated
    public static boolean isBisectHosted() {
        return bisectHosted;
    }
}

