/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsAddedIn;
import org.bukkit.entity.Fox;

@NmsAddedIn(value=NmsVersion.v1_14)
public class FoxWatcher
extends AgeableWatcher {
    public FoxWatcher(Disguise disguise) {
        super(disguise);
        if (DisguiseConfig.isRandomDisguises()) {
            this.setType(ReflectionManager.randomEnum(Fox.Type.class));
        }
    }

    public boolean isSitting() {
        return this.getFoxFlag(1);
    }

    public void setSitting(boolean value) {
        this.setFoxFlag(1, value);
    }

    public boolean isCrouching() {
        return this.getFoxFlag(4);
    }

    public void setCrouching(boolean value) {
        this.setFoxFlag(4, value);
    }

    @Override
    public boolean isSleeping() {
        return this.getFoxFlag(32);
    }

    @Override
    public void setSleeping(boolean value) {
        this.setFoxFlag(32, value);
    }

    public Fox.Type getType() {
        return this.getData(MetaIndex.FOX_TYPE);
    }

    @RandomDefaultValue
    public void setType(Fox.Type type) {
        this.sendData(MetaIndex.FOX_TYPE, type);
    }

    public boolean isHeadTilted() {
        return this.getFoxFlag(8);
    }

    public void setHeadTilted(boolean value) {
        this.setFoxFlag(8, value);
    }

    public boolean isSpringing() {
        return this.getFoxFlag(16);
    }

    public void setSpringing(boolean value) {
        this.setFoxFlag(16, value);
    }

    public boolean isTipToeing() {
        return this.getFoxFlag(64);
    }

    public void setTipToeing(boolean value) {
        this.setFoxFlag(64, value);
    }

    public boolean isAngry() {
        return this.getFoxFlag(128);
    }

    public void setAngry(boolean value) {
        this.setFoxFlag(128, value);
    }

    private boolean getFoxFlag(int value) {
        return (this.getData(MetaIndex.FOX_META) & value) != 0;
    }

    private void setFoxFlag(int no, boolean flag) {
        byte b1 = this.getData(MetaIndex.FOX_META);
        b1 = flag ? (byte)(b1 | no) : (byte)(b1 & ~no);
        this.sendData(MetaIndex.FOX_META, b1);
    }
}

