/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoBoatType;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.annotations.MethodDescription;
import me.libraryaddict.disguise.utilities.reflection.annotations.MethodMappedAs;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsAddedIn;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsRemovedIn;
import org.bukkit.TreeSpecies;
import org.bukkit.entity.Boat;

public class BoatWatcher
extends FlagWatcher {
    public BoatWatcher(Disguise disguise) {
        super(disguise);
        if (NmsVersion.v1_21_R2.isSupported()) {
            return;
        }
        if (NmsVersion.v1_19_R1.isSupported()) {
            this.setType(Boat.Type.OAK);
        } else {
            this.setBoatType(TreeSpecies.GENERIC);
        }
    }

    public float getDamage() {
        return this.getData(MetaIndex.BOAT_DAMAGE).floatValue();
    }

    @MethodDescription(value="No visible difference")
    public void setDamage(float dmg) {
        this.sendData(MetaIndex.BOAT_DAMAGE, Float.valueOf(dmg));
    }

    public boolean isRightPaddling() {
        return this.getData(MetaIndex.BOAT_RIGHT_PADDLING);
    }

    @MethodDescription(value="Is the boat's right paddle moving?")
    public void setRightPaddling(boolean rightPaddling) {
        this.sendData(MetaIndex.BOAT_RIGHT_PADDLING, rightPaddling);
    }

    public boolean isLeftPaddling() {
        return this.getData(MetaIndex.BOAT_LEFT_PADDLING);
    }

    @MethodDescription(value="Is the boat's left paddle moving?")
    public void setLeftPaddling(boolean leftPaddling) {
        this.sendData(MetaIndex.BOAT_LEFT_PADDLING, leftPaddling);
    }

    @NmsAddedIn(value=NmsVersion.v1_13)
    public int getBoatShake() {
        return this.getData(MetaIndex.BOAT_SHAKE);
    }

    @NmsAddedIn(value=NmsVersion.v1_13)
    @MethodDescription(value="How violently does this boat shake when damaged?")
    public void setBoatShake(int number) {
        this.sendData(MetaIndex.BOAT_SHAKE, number);
    }

    @NmsAddedIn(value=NmsVersion.v1_19_R1)
    @NmsRemovedIn(value=NmsVersion.v1_21_R2)
    @MethodMappedAs(value="getBoatType")
    public Boat.Type getType() {
        return this.getData(MetaIndex.BOAT_TYPE_NEW);
    }

    @NmsAddedIn(value=NmsVersion.v1_19_R1)
    @NmsRemovedIn(value=NmsVersion.v1_21_R2)
    @MethodMappedAs(value="setBoatType")
    @MethodDescription(value="What type of wood is this boat made of?")
    public void setType(Boat.Type type) {
        this.sendData(MetaIndex.BOAT_TYPE_NEW, type);
    }

    @NmsRemovedIn(value=NmsVersion.v1_19_R1)
    public TreeSpecies getBoatType() {
        if (NmsVersion.v1_19_R1.isSupported()) {
            return ParamInfoBoatType.getSpeciesFromType(this.getType());
        }
        return this.getData(MetaIndex.BOAT_TYPE_OLD);
    }

    @NmsRemovedIn(value=NmsVersion.v1_19_R1)
    @MethodDescription(value="What type of wood is this boat made of?")
    public void setBoatType(TreeSpecies boatType) {
        if (NmsVersion.v1_19_R1.isSupported()) {
            this.setType(ParamInfoBoatType.getTypeFromSpecies(boatType));
            return;
        }
        this.sendData(MetaIndex.BOAT_TYPE_OLD, boatType);
    }
}

